/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.download;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.download.BaseExporter;
import org.alfresco.repo.download.ContentServiceHelper;
import org.alfresco.repo.download.DownloadCancelledException;
import org.alfresco.repo.download.DownloadServiceException;
import org.alfresco.repo.download.DownloadStatusUpdateService;
import org.alfresco.repo.download.DownloadStorage;
import org.alfresco.repo.download.ZipDownloadExporter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.coci.CheckOutCheckInService;
import org.alfresco.service.cmr.download.DownloadRequest;
import org.alfresco.service.cmr.download.DownloadStatus;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.view.ExporterCrawlerParameters;
import org.alfresco.service.cmr.view.ExporterService;
import org.alfresco.service.cmr.view.Location;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.TempFileProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateDownloadArchiveAction
extends ActionExecuterAbstractBase {
    private static final Logger log = LoggerFactory.getLogger(CreateDownloadArchiveAction.class);
    private static final String CREATION_ERROR = "Unexpected error creating archive file for download";
    private static final String TEMP_FILE_PREFIX = "download";
    private static final String TEMP_FILE_SUFFIX = ".zip";
    private CheckOutCheckInService checkOutCheckInService;
    private ContentServiceHelper contentServiceHelper;
    private DownloadStorage downloadStorage;
    private ExporterService exporterService;
    private NodeService nodeService;
    private RetryingTransactionHelper transactionHelper;
    private DownloadStatusUpdateService updateService;
    private long maximumContentSize = -1L;

    public void setCheckOutCheckInSerivce(CheckOutCheckInService checkOutCheckInService) {
        this.checkOutCheckInService = checkOutCheckInService;
    }

    public void setContentServiceHelper(ContentServiceHelper contentServiceHelper) {
        this.contentServiceHelper = contentServiceHelper;
    }

    public void setDownloadStorage(DownloadStorage downloadStorage) {
        this.downloadStorage = downloadStorage;
    }

    public void setExporterService(ExporterService exporterService) {
        this.exporterService = exporterService;
    }

    public void setMaximumContentSize(long maximumContentSize) {
        this.maximumContentSize = maximumContentSize;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTransactionHelper(RetryingTransactionHelper transactionHelper) {
        this.transactionHelper = transactionHelper;
    }

    public void setUpdateService(DownloadStatusUpdateService updateService) {
        this.updateService = updateService;
    }

    @Override
    protected void executeImpl(Action action, final NodeRef actionedUponNodeRef) {
        final DownloadRequest downloadRequest = this.downloadStorage.getDownloadRequest(actionedUponNodeRef);
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                ExporterCrawlerParameters crawlerParameters = new ExporterCrawlerParameters();
                Location exportFrom = new Location(downloadRequest.getRequetedNodeRefs());
                crawlerParameters.setExportFrom(exportFrom);
                crawlerParameters.setCrawlSelf(true);
                crawlerParameters.setExcludeChildAssocs(new QName[]{RenditionModel.ASSOC_RENDITION});
                crawlerParameters.setExcludeAspects(new QName[]{ContentModel.ASPECT_WORKING_COPY});
                SizeEstimator estimator = new SizeEstimator(CreateDownloadArchiveAction.this.checkOutCheckInService, CreateDownloadArchiveAction.this.nodeService);
                CreateDownloadArchiveAction.this.exporterService.exportView(estimator, crawlerParameters, null);
                if (CreateDownloadArchiveAction.this.maximumContentSize > 0L && estimator.getSize() > CreateDownloadArchiveAction.this.maximumContentSize) {
                    CreateDownloadArchiveAction.this.maximumContentSizeExceeded(actionedUponNodeRef, estimator.getSize(), estimator.getFileCount());
                } else {
                    CreateDownloadArchiveAction.this.createDownload(actionedUponNodeRef, crawlerParameters, estimator);
                }
                return null;
            }
        }, (String)downloadRequest.getOwner());
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
    }

    private void maximumContentSizeExceeded(final NodeRef actionedUponNodeRef, final long size, final long fileCount) {
        log.debug("Maximum contentent size ({}), exceeded ({})", (Object)this.maximumContentSize, (Object)size);
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                DownloadStatus status = new DownloadStatus(DownloadStatus.Status.MAX_CONTENT_SIZE_EXCEEDED, CreateDownloadArchiveAction.this.maximumContentSize, size, 0L, fileCount);
                CreateDownloadArchiveAction.this.updateService.update(actionedUponNodeRef, status, 1);
                return null;
            }
        }, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDownload(NodeRef actionedUponNodeRef, ExporterCrawlerParameters crawlerParameters, SizeEstimator estimator) {
        File tempFile = TempFileProvider.createTempFile((String)TEMP_FILE_PREFIX, (String)TEMP_FILE_SUFFIX);
        ZipDownloadExporter handler = new ZipDownloadExporter(tempFile, this.checkOutCheckInService, this.nodeService, this.transactionHelper, this.updateService, this.downloadStorage, actionedUponNodeRef, estimator.getSize(), estimator.getFileCount());
        try {
            this.exporterService.exportView(handler, crawlerParameters, null);
            this.archiveCreationComplete(actionedUponNodeRef, tempFile, handler);
        }
        catch (DownloadCancelledException ex) {
            this.downloadCancelled(actionedUponNodeRef, handler);
        }
        finally {
            tempFile.delete();
        }
    }

    private void archiveCreationComplete(final NodeRef actionedUponNodeRef, final File tempFile, final ZipDownloadExporter handler) {
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                try {
                    CreateDownloadArchiveAction.this.contentServiceHelper.updateContent(actionedUponNodeRef, tempFile);
                    DownloadStatus status = new DownloadStatus(DownloadStatus.Status.DONE, handler.getDone(), handler.getTotal(), handler.getFilesAdded(), handler.getTotalFiles());
                    CreateDownloadArchiveAction.this.updateService.update(actionedUponNodeRef, status, handler.getNextSequenceNumber());
                    return null;
                }
                catch (ContentIOException ex) {
                    throw new DownloadServiceException(CreateDownloadArchiveAction.CREATION_ERROR, ex);
                }
                catch (FileNotFoundException ex) {
                    throw new DownloadServiceException(CreateDownloadArchiveAction.CREATION_ERROR, ex);
                }
                catch (IOException ex) {
                    throw new DownloadServiceException(CreateDownloadArchiveAction.CREATION_ERROR, ex);
                }
            }
        }, false, true);
    }

    private void downloadCancelled(final NodeRef actionedUponNodeRef, final ZipDownloadExporter handler) {
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Throwable {
                DownloadStatus status = new DownloadStatus(DownloadStatus.Status.CANCELLED, handler.getDone(), handler.getTotal(), handler.getFilesAdded(), handler.getTotalFiles());
                CreateDownloadArchiveAction.this.updateService.update(actionedUponNodeRef, status, handler.getNextSequenceNumber());
                return null;
            }
        }, false, true);
    }

    private static class SizeEstimator
    extends BaseExporter {
        private long size = 0L;
        private long fileCount = 0L;

        SizeEstimator(CheckOutCheckInService checkOutCheckInService, NodeService nodeService) {
            super(checkOutCheckInService, nodeService);
        }

        @Override
        protected void contentImpl(NodeRef nodeRef, QName property, InputStream content, ContentData contentData, int index) {
            this.size += contentData.getSize();
            ++this.fileCount;
        }

        public long getSize() {
            return this.size;
        }

        public long getFileCount() {
            return this.fileCount;
        }
    }
}

