/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forms.script;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JSPropertyExtractor {
    private StringBuilder getCapitalisedPropertyName(String name) {
        StringBuilder capitalisedPropertyName = new StringBuilder();
        capitalisedPropertyName.append(name.substring(0, 1).toUpperCase());
        if (name.length() > 1) {
            capitalisedPropertyName.append(name.substring(1));
        }
        return capitalisedPropertyName;
    }

    boolean propertyExists(String propertyName, Object jsObject) {
        return this.resolveMethod(propertyName, jsObject) != null;
    }

    Object extractProperty(String propertyName, Object jsObject) {
        Method resolvedMethod = this.resolveMethod(propertyName, jsObject);
        if (resolvedMethod == null) {
            return null;
        }
        try {
            Object propertyValue = resolvedMethod.invoke(jsObject, new Object[0]);
            return propertyValue;
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private Method resolveMethod(String propertyName, Object jsObject) {
        StringBuilder capitalisedPropertyName = this.getCapitalisedPropertyName(propertyName);
        String nameOfPotentialGetMethod = "get" + capitalisedPropertyName;
        String nameOfPotentialIsMethod = "is" + capitalisedPropertyName;
        Method[] availableMethods = jsObject.getClass().getMethods();
        Method resolvedMethod = null;
        for (Method method : availableMethods) {
            if (resolvedMethod == null && nameOfPotentialIsMethod.equals(method.getName()) && method.getParameterTypes().length == 0) {
                resolvedMethod = method;
            }
            if (!nameOfPotentialGetMethod.equals(method.getName()) || method.getParameterTypes().length != 0) continue;
            resolvedMethod = method;
            break;
        }
        return resolvedMethod;
    }
}

