/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.forum;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ForumModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.extensions.surf.util.I18NUtil;

public class DiscussableAspect
implements NodeServicePolicies.OnAddAspectPolicy,
CopyServicePolicies.OnCopyNodePolicy,
CopyServicePolicies.OnCopyCompletePolicy {
    private static final String KEY_WORKING_COPIES = DiscussableAspect.class.getName() + ".WorkingCopies";
    private static final Log logger = LogFactory.getLog(DiscussableAspect.class);
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private FileFolderService fileFolderService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public final void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ForumModel.ASPECT_DISCUSSABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ForumModel.ASPECT_DISCUSSABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onCopyComplete"), ForumModel.ASPECT_DISCUSSABLE, (Behaviour)new JavaBehaviour(this, "onCopyComplete"));
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DiscussableAspectCopyBehaviourCallback.INSTANCE;
    }

    @Override
    public void onAddAspect(NodeRef discussableNodeRef, QName aspectTypeQName) {
        String name = (String)((Object)this.nodeService.getProperty(discussableNodeRef, ContentModel.PROP_NAME));
        String forumName = I18NUtil.getMessage((String)"discussion.discussion_for", (Object[])new Object[]{name});
        NodeRef forumNodeRef = this.getForum(discussableNodeRef);
        if (forumNodeRef == null) {
            HashMap<QName, String> forumProps = new HashMap<QName, String>(1);
            forumProps.put(ContentModel.PROP_NAME, forumName);
            ChildAssociationRef childRef = this.nodeService.createNode(discussableNodeRef, ForumModel.ASSOC_DISCUSSION, QName.createQName((String)"http://www.alfresco.org/model/forum/1.0", (String)"discussion"), ForumModel.TYPE_FORUM, forumProps);
            forumNodeRef = childRef.getChildRef();
        } else {
            this.nodeService.setProperty(forumNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)forumName));
        }
        HashMap<QName, String> uiFacetsProps = new HashMap<QName, String>(5);
        uiFacetsProps.put(ApplicationModel.PROP_ICON, "forum");
        this.nodeService.addAspect(forumNodeRef, ApplicationModel.ASPECT_UIFACETS, uiFacetsProps);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created forum node for discussion: \n   Discussable Node: " + discussableNodeRef + "\n" + "   Forum Node:       " + forumNodeRef));
        }
    }

    private NodeRef getForum(NodeRef discussableNodeRef) {
        List destChildren = this.nodeService.getChildAssocs(discussableNodeRef, (QNamePattern)ForumModel.ASSOC_DISCUSSION, RegexQNamePattern.MATCH_ALL);
        if (destChildren.size() == 0) {
            return null;
        }
        ChildAssociationRef discussionAssoc = (ChildAssociationRef)destChildren.get(0);
        return discussionAssoc.getChildRef();
    }

    @Override
    public void onCopyComplete(QName classRef, NodeRef sourceNodeRef, NodeRef targetNodeRef, boolean copyToNewNode, Map<NodeRef, NodeRef> copyMap) {
        Set workingCopyNodeRefs = TransactionalResourceHelper.getSet(KEY_WORKING_COPIES);
        if (!workingCopyNodeRefs.contains(sourceNodeRef)) {
            return;
        }
        NodeRef sourceForumNodeRef = this.getForum(sourceNodeRef);
        if (sourceForumNodeRef == null) {
            this.nodeService.removeAspect(sourceNodeRef, ForumModel.ASPECT_DISCUSSABLE);
            return;
        }
        if (!this.nodeService.hasAspect(targetNodeRef, ForumModel.ASPECT_DISCUSSABLE)) {
            this.nodeService.addAspect(targetNodeRef, ForumModel.ASPECT_DISCUSSABLE, null);
        }
        NodeRef targetForumNodeRef = this.getForum(targetNodeRef);
        List topicAssocRefs = this.nodeService.getChildAssocs(sourceForumNodeRef, Collections.singleton(ForumModel.TYPE_TOPIC));
        int copied = 0;
        for (ChildAssociationRef topicAssocRef : topicAssocRefs) {
            NodeRef topicNodeRef = topicAssocRef.getChildRef();
            try {
                String topicName;
                String topicNodeName = this.nodeService.getProperty(topicNodeRef, ContentModel.PROP_NAME).toString();
                Serializable labelProp = this.nodeService.getProperty(targetNodeRef, ContentModel.PROP_VERSION_LABEL);
                if (labelProp == null) {
                    SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MM-yyyy-HH-mm-ss");
                    topicName = topicNodeName + " - " + dateFormat.format(new Date());
                } else {
                    topicName = topicNodeName + " (" + labelProp.toString() + ")";
                }
                if (this.fileFolderService.searchSimple(targetForumNodeRef, topicName) != null) continue;
                this.fileFolderService.copy(topicNodeRef, targetForumNodeRef, topicName);
                ++copied;
            }
            catch (FileExistsException e) {
                throw new ConcurrencyFailureException("Target topic exists: " + e.getMessage(), (Throwable)e);
            }
            catch (FileNotFoundException e) {
                throw new ConcurrencyFailureException("Forum was deleted: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static class DiscussableAspectCopyBehaviourCallback
    extends DoNothingCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new DiscussableAspectCopyBehaviourCallback();

        private DiscussableAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            if (copyDetails.getSourceNodeAspectQNames().contains(ContentModel.ASPECT_WORKING_COPY) && !copyDetails.isTargetNodeIsNew()) {
                Set nodeRefs = TransactionalResourceHelper.getSet(KEY_WORKING_COPIES);
                nodeRefs.add(copyDetails.getSourceNodeRef());
            }
            return false;
        }
    }
}

