/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.imap.AuthorizationException;
import com.icegreen.greenmail.imap.ImapHostManager;
import com.icegreen.greenmail.store.FolderException;
import com.icegreen.greenmail.store.MailFolder;
import com.icegreen.greenmail.user.GreenMailUser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.util.Utf7;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoImapHostManager
implements ImapHostManager {
    private ImapService imapService;
    private Map<String, AlfrescoImapFolder> folderCache;
    private static Log logger = LogFactory.getLog(AlfrescoImapHostManager.class);

    public AlfrescoImapHostManager(ImapService imapService) {
        this.imapService = imapService;
    }

    public char getHierarchyDelimiter() {
        return '/';
    }

    public Collection<MailFolder> listMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            return this.registerMailboxes(this.imapService.listMailboxes(alfrescoUser, this.getUnqualifiedMailboxPattern(alfrescoUser, mailboxPattern), false));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public Collection<MailFolder> listSubscribedMailboxes(GreenMailUser user, String mailboxPattern) throws FolderException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            return this.registerMailboxes(this.imapService.listMailboxes(alfrescoUser, this.getUnqualifiedMailboxPattern(alfrescoUser, mailboxPattern), true));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void renameMailbox(GreenMailUser user, String oldMailboxName, String newMailboxName) throws FolderException, AuthorizationException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            String oldFolderPath = this.getUnqualifiedMailboxPattern(alfrescoUser, oldMailboxName);
            String newFolderpath = this.getUnqualifiedMailboxPattern(alfrescoUser, newMailboxName);
            this.imapService.renameMailbox(alfrescoUser, oldFolderPath, newFolderpath);
            if (this.folderCache != null) {
                this.folderCache.remove(oldFolderPath);
                this.folderCache.remove(newFolderpath);
            }
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public MailFolder createMailbox(GreenMailUser user, String mailboxName) throws AuthorizationException, FolderException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            return this.registerMailBox(this.imapService.getOrCreateMailbox(alfrescoUser, this.getUnqualifiedMailboxPattern(alfrescoUser, mailboxName), false, true));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void deleteMailbox(GreenMailUser user, String mailboxName) throws FolderException, AuthorizationException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            String folderPath = this.getUnqualifiedMailboxPattern(alfrescoUser, mailboxName);
            this.imapService.deleteMailbox(alfrescoUser, folderPath);
            if (this.folderCache != null) {
                this.folderCache.remove(folderPath);
            }
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName) {
        AlfrescoImapFolder result;
        AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
        String folderPath = this.getUnqualifiedMailboxPattern(alfrescoUser, mailboxName);
        if (this.folderCache == null) {
            this.registerMailboxes(this.imapService.listMailboxes(alfrescoUser, "*", true));
        }
        if ((result = this.folderCache.get(folderPath)) != null && result.reset()) {
            return result;
        }
        return this.registerMailBox(this.imapService.getOrCreateMailbox(alfrescoUser, folderPath, true, false));
    }

    public MailFolder getFolder(GreenMailUser user, String mailboxName, boolean mustExist) throws FolderException {
        return this.getFolder(user, mailboxName);
    }

    public MailFolder getInbox(GreenMailUser user) throws FolderException {
        return this.getFolder(new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword()), "INBOX");
    }

    public void createPrivateMailAccount(GreenMailUser user) throws FolderException {
        throw new UnsupportedOperationException();
    }

    public void subscribe(GreenMailUser user, String mailbox) throws FolderException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            this.imapService.subscribe(alfrescoUser, this.getUnqualifiedMailboxPattern(alfrescoUser, mailbox));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public void unsubscribe(GreenMailUser user, String mailbox) throws FolderException {
        try {
            AlfrescoImapUser alfrescoUser = new AlfrescoImapUser(user.getEmail(), user.getLogin(), user.getPassword());
            this.imapService.unsubscribe(alfrescoUser, this.getUnqualifiedMailboxPattern(alfrescoUser, mailbox));
        }
        catch (Throwable e) {
            logger.debug((Object)e.getMessage(), e);
            throw new FolderException(e.getMessage());
        }
    }

    public List<?> getAllMessages() {
        throw new UnsupportedOperationException();
    }

    private String getUnqualifiedMailboxPattern(AlfrescoImapUser user, String mailboxPattern) {
        if ((mailboxPattern = Utf7.decode(mailboxPattern, "X-MODIFIED-UTF-7")).startsWith("#")) {
            int sepIndex = mailboxPattern.indexOf(47);
            return sepIndex == -1 ? (mailboxPattern.endsWith("*") ? "*" : "") : mailboxPattern.substring(sepIndex + 1);
        }
        return mailboxPattern;
    }

    private Collection<MailFolder> registerMailboxes(Collection<AlfrescoImapFolder> mailboxes) {
        int size = mailboxes.size();
        if (size == 0) {
            return Collections.emptyList();
        }
        ArrayList<MailFolder> result = new ArrayList<MailFolder>(size);
        if (this.folderCache == null) {
            this.folderCache = new HashMap<String, AlfrescoImapFolder>(size * 2);
        }
        for (AlfrescoImapFolder mailbox : mailboxes) {
            result.add(this.registerMailBox(mailbox));
        }
        return result;
    }

    private MailFolder registerMailBox(AlfrescoImapFolder mailbox) {
        String folderPath = mailbox.getFolderPath();
        if ((mailbox.isSelectable() || folderPath.isEmpty()) && this.folderCache != null) {
            AlfrescoImapFolder oldFolder = this.folderCache.get(folderPath);
            if (oldFolder != null && oldFolder.getFolderInfo().getNodeRef().equals((Object)mailbox.getFolderInfo().getNodeRef()) && oldFolder.reset()) {
                mailbox = oldFolder;
            } else {
                this.folderCache.put(folderPath, mailbox);
            }
        }
        return mailbox;
    }
}

