/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeUtility;
import org.alfresco.model.ContentModel;
import org.alfresco.model.ImapModel;
import org.alfresco.repo.imap.ImapService;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.util.config.RepositoryFolderConfigBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.FileCopyUtils;

public class AttachmentsExtractor {
    private Log logger = LogFactory.getLog(AttachmentsExtractor.class);
    private FileFolderService fileFolderService;
    private NodeService nodeService;
    private ImapService imapService;
    private ServiceRegistry serviceRegistry;
    private RepositoryFolderConfigBean attachmentsFolder;
    private NodeRef attachmentsFolderRef;
    private AttachmentsExtractorMode attachmentsExtractorMode;

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setImapService(ImapService imapService) {
        this.imapService = imapService;
    }

    public void setAttachmentsFolder(RepositoryFolderConfigBean attachmentsFolder) {
        this.attachmentsFolder = attachmentsFolder;
    }

    public void setServiceRegistry(ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void setAttachmentsExtractorMode(String attachmentsExtractorMode) {
        this.attachmentsExtractorMode = AttachmentsExtractorMode.valueOf(attachmentsExtractorMode);
    }

    public void init() {
        this.attachmentsFolderRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef attFolderRef = AttachmentsExtractor.this.attachmentsFolder.getOrCreateFolderPath(AttachmentsExtractor.this.serviceRegistry.getNamespaceService(), AttachmentsExtractor.this.nodeService, AttachmentsExtractor.this.serviceRegistry.getSearchService(), AttachmentsExtractor.this.fileFolderService);
                AttachmentsExtractor.this.serviceRegistry.getPermissionService().setPermission(attFolderRef, "GROUP_EVERYONE", "FullControl", true);
                return attFolderRef;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    public void extractAttachments(NodeRef messageRef, MimeMessage originalMessage) throws IOException, MessagingException {
        NodeRef attachmentsFolderRef = null;
        switch (this.attachmentsExtractorMode) {
            case SAME: {
                attachmentsFolderRef = this.nodeService.getPrimaryParent(messageRef).getParentRef();
                break;
            }
            case COMMON: {
                attachmentsFolderRef = this.attachmentsFolderRef;
                break;
            }
            default: {
                NodeRef parentFolder = this.nodeService.getPrimaryParent(messageRef).getParentRef();
                String messageName = (String)((Object)this.nodeService.getProperty(messageRef, ContentModel.PROP_NAME));
                String attachmentsFolderName = messageName + "-attachments";
                attachmentsFolderRef = this.fileFolderService.create(parentFolder, attachmentsFolderName, ContentModel.TYPE_FOLDER).getNodeRef();
            }
        }
        this.nodeService.createAssociation(messageRef, attachmentsFolderRef, ImapModel.ASSOC_IMAP_ATTACHMENTS_FOLDER);
        Object content = originalMessage.getContent();
        if (content instanceof Multipart) {
            Multipart multipart = (Multipart)content;
            int n = multipart.getCount();
            for (int i = 0; i < n; ++i) {
                BodyPart part = multipart.getBodyPart(i);
                if (!"attachment".equalsIgnoreCase(part.getDisposition())) continue;
                this.createAttachment(messageRef, attachmentsFolderRef, (Part)part);
            }
        }
    }

    private void createAttachment(NodeRef messageFile, NodeRef attachmentsFolderRef, Part part) throws MessagingException, IOException {
        String fileName;
        block5: {
            fileName = part.getFileName();
            if (fileName == null || fileName.isEmpty()) {
                fileName = "unnamed";
            }
            try {
                fileName = MimeUtility.decodeText((String)fileName);
            }
            catch (UnsupportedEncodingException e) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn((Object)("Cannot decode file name '" + fileName + "'"), (Throwable)e);
            }
        }
        ContentType contentType = new ContentType(part.getContentType());
        NodeRef attachmentFile = this.fileFolderService.searchSimple(attachmentsFolderRef, fileName);
        if (attachmentFile == null) {
            FileInfo createdFile = this.fileFolderService.create(attachmentsFolderRef, fileName, ContentModel.TYPE_CONTENT);
            this.nodeService.createAssociation(messageFile, createdFile.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENT);
            attachmentFile = createdFile.getNodeRef();
        } else {
            String newFileName = this.imapService.generateUniqueFilename(attachmentsFolderRef, fileName);
            FileInfo createdFile = this.fileFolderService.create(attachmentsFolderRef, newFileName, ContentModel.TYPE_CONTENT);
            this.nodeService.createAssociation(messageFile, createdFile.getNodeRef(), ImapModel.ASSOC_IMAP_ATTACHMENT);
            attachmentFile = createdFile.getNodeRef();
        }
        this.nodeService.setProperty(attachmentFile, ContentModel.PROP_DESCRIPTION, this.nodeService.getProperty(messageFile, ContentModel.PROP_NAME));
        ContentWriter writer = this.fileFolderService.getWriter(attachmentFile);
        writer.setMimetype(contentType.getBaseType());
        OutputStream os = writer.getContentOutputStream();
        FileCopyUtils.copy((InputStream)part.getInputStream(), (OutputStream)os);
    }

    public static enum AttachmentsExtractorMode {
        SAME,
        COMMON,
        SEPARATE;

    }
}

