/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.imap;

import com.icegreen.greenmail.store.SimpleStoredMessage;
import java.io.IOException;
import java.util.List;
import java.util.NavigableMap;
import javax.mail.Flags;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.alfresco.repo.imap.AlfrescoImapConst;
import org.alfresco.repo.imap.AlfrescoImapFolder;
import org.alfresco.repo.imap.AlfrescoImapUser;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;

public interface ImapService {
    public List<AlfrescoImapFolder> listMailboxes(AlfrescoImapUser var1, String var2, boolean var3);

    public void deleteMailbox(AlfrescoImapUser var1, String var2);

    public void renameMailbox(AlfrescoImapUser var1, String var2, String var3);

    public AlfrescoImapFolder getOrCreateMailbox(AlfrescoImapUser var1, String var2, boolean var3, boolean var4);

    public NodeRef getUserImapHomeRef(String var1);

    public void subscribe(AlfrescoImapUser var1, String var2);

    public void unsubscribe(AlfrescoImapUser var1, String var2);

    public FolderStatus getFolderStatus(String var1, NodeRef var2, AlfrescoImapConst.ImapViewMode var3);

    public SimpleStoredMessage getMessage(FileInfo var1) throws MessagingException;

    public SimpleStoredMessage createImapMessage(FileInfo var1, boolean var2) throws MessagingException;

    public void expungeMessage(FileInfo var1);

    public Flags getFlags(FileInfo var1);

    public void setFlags(FileInfo var1, Flags var2, boolean var3);

    public void setFlag(FileInfo var1, Flags.Flag var2, boolean var3);

    public String getDefaultFromAddress();

    public String getDefaultToAddress();

    public String getRepositoryTemplatePath();

    public String getWebApplicationContextUrl();

    public String getShareApplicationContextUrl();

    public String getDefaultEmailBodyTemplate(EmailBodyFormat var1);

    public boolean isNodeInSitesLibrary(NodeRef var1);

    public NodeRef extractAttachments(NodeRef var1, NodeRef var2, MimeMessage var3) throws IOException, MessagingException;

    public boolean getImapServerEnabled();

    public void extractAttachments(NodeRef var1, MimeMessage var2) throws IOException, MessagingException;

    public String generateUniqueFilename(NodeRef var1, String var2);

    public static class FolderStatus {
        public final int messageCount;
        public final int recentCount;
        public final int firstUnseen;
        public final int unseenCount;
        public final long uidValidity;
        public final String changeToken;
        public final NavigableMap<Long, FileInfo> search;

        public FolderStatus(int messageCount, int recentCount, int firstUnseen, int unseenCount, long uidValidity, String changeToken, NavigableMap<Long, FileInfo> search) {
            this.messageCount = messageCount;
            this.recentCount = recentCount;
            this.firstUnseen = firstUnseen;
            this.unseenCount = unseenCount;
            this.uidValidity = uidValidity;
            this.changeToken = changeToken;
            this.search = search;
        }
    }

    public static enum EmailBodyFormat {
        ALFRESCO_TEXT_PLAIN("/alfresco/templates/imap/emailbody_textplain_alfresco.ftl"),
        SHARE_TEXT_PLAIN("/alfresco/templates/imap/emailbody_textplain_share.ftl"),
        ALFRESCO_TEXT_HTML("/alfresco/templates/imap/emailbody_texthtml_alfresco.ftl"),
        SHARE_TEXT_HTML("/alfresco/templates/imap/emailbody_texthtml_share.ftl");

        private String templatePath;

        private EmailBodyFormat(String templatePath) {
            this.templatePath = templatePath;
        }

        public String getSubtype() {
            return this.name().toLowerCase().substring(this.name().indexOf("_") + 2 + "TEXT".length());
        }

        public String getTypeSubtype() {
            return this.name().toLowerCase().substring(this.name().indexOf("_") + 1).replaceAll("_", "");
        }

        public String getMimeType() {
            return this.name().toLowerCase().substring(this.name().indexOf("_") + 1).replaceAll("_", "/");
        }

        public String getClasspathTemplatePath() {
            return this.templatePath;
        }

        public String getWebApp() {
            return this.name().toLowerCase().substring(0, this.name().indexOf("_"));
        }
    }
}

