/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.importer;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.alfresco.service.cmr.view.ImportPackageHandler;
import org.alfresco.service.cmr.view.ImporterException;

public class FileImportPackageHandler
implements ImportPackageHandler {
    public static final String DEFAULT_ENCODING = "UTF-8";
    protected File sourceDir;
    protected File dataFile;
    protected String dataFileEncoding;

    public FileImportPackageHandler(File sourceDir, File dataFile, String dataFileEncoding) {
        this.sourceDir = sourceDir;
        this.dataFile = new File(sourceDir, dataFile.getPath());
        this.dataFileEncoding = dataFileEncoding;
    }

    @Override
    public void startImport() {
        this.log("Importing from package " + this.dataFile.getAbsolutePath());
    }

    @Override
    public Reader getDataStream() {
        try {
            FileInputStream inputStream = new FileInputStream(this.dataFile);
            InputStreamReader inputReader = this.dataFileEncoding == null ? new InputStreamReader((InputStream)inputStream, DEFAULT_ENCODING) : new InputStreamReader((InputStream)inputStream, this.dataFileEncoding);
            return new BufferedReader(inputReader);
        }
        catch (UnsupportedEncodingException e) {
            throw new ImporterException("Encoding " + this.dataFileEncoding + " is not supported");
        }
        catch (IOException e) {
            throw new ImporterException("Failed to read package " + this.dataFile.getAbsolutePath() + " due to " + e.getMessage());
        }
    }

    @Override
    public InputStream importStream(String content) {
        File fileURL = new File(content);
        if (!fileURL.isAbsolute()) {
            fileURL = new File(this.sourceDir, content);
        }
        try {
            return new FileInputStream(fileURL);
        }
        catch (IOException e) {
            throw new ImporterException("Failed to read content url " + content + " from file " + fileURL.getAbsolutePath());
        }
    }

    @Override
    public void endImport() {
    }

    protected void log(String message) {
    }
}

