/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.mail.internet.MimeMessage;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.executer.MailActionExecuter;
import org.alfresco.repo.invitation.InvitationSearchCriteriaImpl;
import org.alfresco.repo.invitation.InvitationServiceImpl;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.workflow.WorkflowAdminServiceImpl;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.InvitationSearchCriteria;
import org.alfresco.service.cmr.invitation.InvitationService;
import org.alfresco.service.cmr.invitation.ModeratedInvitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.util.BaseAlfrescoSpringTest;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractInvitationServiceImplTest
extends BaseAlfrescoSpringTest {
    private static final Log logger = LogFactory.getLog(AbstractInvitationServiceImplTest.class);
    private SiteService siteService;
    private PersonService personService;
    protected InvitationService invitationService;
    private MailActionExecuter mailService;
    private boolean startSendEmails;
    protected InvitationServiceImpl invitationServiceImpl;
    protected WorkflowAdminServiceImpl workflowAdminService;
    protected static final String SITE_SHORT_NAME_INVITE = "InvitationTest";
    protected static final String SITE_SHORT_NAME_RED = "InvitationTestRed";
    protected static final String SITE_SHORT_NAME_BLUE = "InvitationTestBlue";
    public static final String PERSON_FIRSTNAME = "InvitationFirstName123";
    public static final String PERSON_FIRSTNAME_SPACES = "Invitation First\tName\n1\r2\r\n3";
    public static final String PERSON_LASTNAME = "InvitationLastName123";
    public static final String PERSON_LASTNAME_SPACES = "Invitation Last\tName\n1\r2\r\n3";
    public static final String PERSON_JOBTITLE = "JobTitle123";
    public static final String PERSON_ORG = "Organisation123";
    public static final String USER_MANAGER = "InvitationServiceManagerOne";
    public static final String USER_ONE = "InvitationServiceAlice";
    public static final String USER_TWO = "InvitationServiceBob";
    public static final String USER_EVE = "InvitationServiceEve";
    public static final String USER_NOEMAIL = "InvitationServiceNoEmail";
    public static final String USER_ONE_FIRSTNAME = "One";
    public static final String USER_ONE_LASTNAME = "Test";
    public static final String USER_ONE_EMAIL = "InvitationServiceAlice@alfrescotesting.com";
    public static final String USER_TWO_EMAIL = "InvitationServiceBob@alfrescotesting.com";
    private Collection<String> enabledEngines;
    private Collection<String> visibleEngines;

    @Override
    protected void onSetUpInTransaction() throws Exception {
        SiteInfo siteInfoBlue;
        SiteInfo siteInfoRed;
        super.onSetUpInTransaction();
        this.invitationService = (InvitationService)this.applicationContext.getBean("InvitationService");
        this.siteService = (SiteService)this.applicationContext.getBean("SiteService");
        this.personService = (PersonService)this.applicationContext.getBean("PersonService");
        this.authenticationComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        this.invitationServiceImpl = (InvitationServiceImpl)this.applicationContext.getBean("invitationService");
        this.workflowAdminService = (WorkflowAdminServiceImpl)this.applicationContext.getBean("workflowAdminService");
        this.startSendEmails = this.invitationServiceImpl.isSendEmails();
        this.enabledEngines = this.workflowAdminService.getEnabledEngines();
        this.visibleEngines = this.workflowAdminService.getVisibleEngines();
        this.invitationServiceImpl.setSendEmails(true);
        this.mailService = (MailActionExecuter)((ApplicationContextFactory)this.applicationContext.getBean("OutboundSMTP")).getApplicationContext().getBean("mail");
        this.mailService.setTestMode(true);
        this.createPerson(USER_MANAGER, "InvitationServiceManagerOne@alfrescotesting.com", PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_ONE, USER_ONE_EMAIL, USER_ONE_FIRSTNAME, USER_ONE_LASTNAME);
        this.createPerson(USER_TWO, USER_TWO_EMAIL, PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_EVE, "InvitationServiceEve@alfrescotesting.com", PERSON_FIRSTNAME, PERSON_LASTNAME);
        this.createPerson(USER_NOEMAIL, null, USER_NOEMAIL, USER_NOEMAIL);
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        SiteInfo siteInfo = this.siteService.getSite(SITE_SHORT_NAME_INVITE);
        if (siteInfo == null) {
            siteInfo = this.siteService.createSite("InviteSitePreset", SITE_SHORT_NAME_INVITE, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
            this.siteService.setMembership(SITE_SHORT_NAME_INVITE, USER_NOEMAIL, "SiteManager");
        }
        if ((siteInfoRed = this.siteService.getSite(SITE_SHORT_NAME_RED)) == null) {
            this.siteService.createSite("InviteSiteRed", SITE_SHORT_NAME_RED, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
        }
        if ((siteInfoBlue = this.siteService.getSite(SITE_SHORT_NAME_BLUE)) == null) {
            this.siteService.createSite("InviteSiteBlue", SITE_SHORT_NAME_BLUE, "InviteSiteTitle", "InviteSiteDescription", SiteVisibility.MODERATED);
        }
    }

    @Override
    protected void onTearDownInTransaction() throws Exception {
        this.authenticationComponent.setSystemUserAsCurrentUser();
        this.workflowAdminService.setEnabledEngines(this.enabledEngines);
        this.workflowAdminService.setVisibleEngines(this.visibleEngines);
        super.onTearDownInTransaction();
    }

    public void testConfiguration() {
        AbstractInvitationServiceImplTest.assertNotNull((String)"Invitation service is null", (Object)this.invitationService);
    }

    public void testNominatedInvitationNewUser() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1);
        Date startDate = calendar.getTime();
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        String inviteId = nominatedInvitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
        inviteeUserName = nominatedInvitation.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeUserName);
        Date sentDate = nominatedInvitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too early. Start Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too lateStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.before(new Date(new Date().getTime() + 1L)));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)nominatedInvitation.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)nominatedInvitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)nominatedInvitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)nominatedInvitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)nominatedInvitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)nominatedInvitation.getRejectUrl());
        NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)invitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)invitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)invitation.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)invitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)invitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)invitation.getRejectUrl());
        Date sentDate2 = invitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)"sentDate wrong too early", (boolean)sentDate2.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)"sentDate wrong - too late", (boolean)sentDate2.before(new Date(new Date().getTime() + 1L)));
        MimeMessage msg = this.mailService.retrieveLastTestMessage();
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg.getAllRecipients().length);
        AbstractInvitationServiceImplTest.assertEquals((String)inviteeEmail, (String)msg.getAllRecipients()[0].toString());
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg.getFrom().length);
        AbstractInvitationServiceImplTest.assertEquals((String)"InvitationServiceManagerOne@alfrescotesting.com", (String)msg.getFrom()[0].toString());
        AbstractInvitationServiceImplTest.assertNull((String)"Not been sent yet", (Object)msg.getSentDate());
        AbstractInvitationServiceImplTest.assertNull((String)"Not been sent yet", (Object)msg.getReceivedDate());
        AbstractInvitationServiceImplTest.assertTrue((msg.getSubject().indexOf("You have been invited to join the") != -1 ? 1 : 0) != 0);
        List<Invitation> invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        NominatedInvitation firstInvite = (NominatedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)firstInvite.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)firstInvite.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)firstInvite.getInviteeUserName());
        NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(firstInvite.getInviteId(), firstInvite.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)firstInvite.getInviteId(), (String)acceptedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)acceptedInvitation.getInviteeUserName());
        List<Invitation> it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        NominatedInvitation acceptedInvitation2 = (NominatedInvitation)this.invitationService.getInvitation(firstInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertNotNull((String)"get after accept does not return", (Object)acceptedInvitation2);
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleName, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, inviteeUserName);
        Field faf = this.mailService.getClass().getDeclaredField("fromAddress");
        faf.setAccessible(true);
        String defaultFromAddress = (String)ReflectionUtils.getField((Field)faf, (Object)this.mailService);
        AuthenticationUtil.setFullyAuthenticatedUser((String)USER_NOEMAIL);
        NominatedInvitation nominatedInvitation2 = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, USER_TWO_EMAIL, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation2);
        inviteId = nominatedInvitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation2.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation2.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)USER_TWO_EMAIL, (String)nominatedInvitation2.getInviteeEmail());
        MimeMessage msg2 = this.mailService.retrieveLastTestMessage();
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg2.getAllRecipients().length);
        AbstractInvitationServiceImplTest.assertEquals((String)USER_TWO_EMAIL, (String)msg2.getAllRecipients()[0].toString());
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)msg2.getFrom().length);
        AbstractInvitationServiceImplTest.assertEquals((String)defaultFromAddress, (String)msg2.getFrom()[0].toString());
    }

    public void testNominatedInvitationNewUserReject() throws Exception {
        Calendar calendar = Calendar.getInstance();
        calendar.add(13, -1);
        Date startDate = calendar.getTime();
        String inviteeFirstName = PERSON_FIRSTNAME;
        String inviteeLastName = PERSON_LASTNAME;
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
        inviteeUserName = nominatedInvitation.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeUserName);
        Date sentDate = nominatedInvitation.getSentInviteDate();
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too earlyStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.after(startDate));
        AbstractInvitationServiceImplTest.assertTrue((String)("sentDate wrong - too lateStart Date: " + startDate + "\nSent Date: " + sentDate), (boolean)sentDate.before(new Date(new Date().getTime() + 1L)));
        NominatedInvitation rejectedInvitation = (NominatedInvitation)this.invitationService.reject(nominatedInvitation.getInviteId(), "dont want it");
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)nominatedInvitation.getInviteId(), (String)rejectedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)rejectedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)rejectedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)rejectedInvitation.getInviteeUserName());
        List<Invitation> it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        if (roleName != null) {
            AbstractInvitationServiceImplTest.fail((String)"role has been set for a rejected user");
        }
        if (this.personService.personExists(inviteeUserName)) {
            AbstractInvitationServiceImplTest.fail((String)"generated user has not been cleaned up");
        }
    }

    public void testNominatedInvitationNewUserSameEmails() throws Exception {
        String inviteeAFirstName = "John";
        String inviteeALastName = "Smith";
        String inviteeBFirstName = "Jane";
        String inviteeBLastName = "Smith";
        String inviteeEmail = "123@alfrescotesting.com";
        String inviteeAUserName = null;
        String inviteeBUserName = null;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitationA = this.invitationService.inviteNominated(inviteeAFirstName, inviteeALastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitationA);
        String inviteAId = nominatedInvitationA.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeAFirstName, (String)nominatedInvitationA.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeALastName, (String)nominatedInvitationA.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitationA.getInviteeEmail());
        inviteeAUserName = nominatedInvitationA.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeAUserName);
        NominatedInvitation nominatedInvitationB = this.invitationService.inviteNominated(inviteeBFirstName, inviteeBLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitationB);
        String inviteBId = nominatedInvitationB.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeBFirstName, (String)nominatedInvitationB.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeBLastName, (String)nominatedInvitationB.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitationB.getInviteeEmail());
        inviteeBUserName = nominatedInvitationB.getInviteeUserName();
        AbstractInvitationServiceImplTest.assertNotNull((String)"generated user name is null", (Object)inviteeBUserName);
        AbstractInvitationServiceImplTest.assertFalse((String)"generated user names are the same", (boolean)inviteeAUserName.equals(inviteeBUserName));
        NominatedInvitation acceptedInvitationA = (NominatedInvitation)this.invitationService.accept(inviteAId, nominatedInvitationA.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteAId, (String)acceptedInvitationA.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeAFirstName, (String)acceptedInvitationA.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeALastName, (String)acceptedInvitationA.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeAUserName, (String)acceptedInvitationA.getInviteeUserName());
        NominatedInvitation acceptedInvitationB = (NominatedInvitation)this.invitationService.accept(inviteBId, nominatedInvitationB.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteBId, (String)acceptedInvitationB.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeBFirstName, (String)acceptedInvitationB.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeBLastName, (String)acceptedInvitationB.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeBUserName, (String)acceptedInvitationB.getInviteeUserName());
        String roleNameA = this.siteService.getMembersRole(resourceName, inviteeAUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleNameA, (String)inviteeRole);
        String roleNameB = this.siteService.getMembersRole(resourceName, inviteeBUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleNameB, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, inviteeAUserName);
        this.siteService.removeMembership(resourceName, inviteeBUserName);
    }

    public void testNominatedInvitationNewUserWhitespace() throws Exception {
        String inviteeFirstName = PERSON_FIRSTNAME_SPACES;
        String inviteeLastName = PERSON_LASTNAME_SPACES;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeEmail = "123@alfrescotesting.com";
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        String expectedUserName = (inviteeFirstName + "_" + inviteeLastName).toLowerCase();
        expectedUserName = expectedUserName.replaceAll("\\s+", "_");
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeFirstName, inviteeLastName, inviteeEmail, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"Wrong username!", (String)expectedUserName, (String)nominatedInvitation.getInviteeUserName());
        String inviteId = nominatedInvitation.getInviteId();
        NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)expectedUserName, (String)invitation.getInviteeUserName());
        NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(invitation.getInviteId(), invitation.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)expectedUserName, (String)acceptedInvitation.getInviteeUserName());
        String roleName = this.siteService.getMembersRole(resourceName, expectedUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)roleName, (String)inviteeRole);
        this.siteService.removeMembership(resourceName, expectedUserName);
    }

    public void testNominatedInvitationExistingUser() throws Exception {
        String inviteeUserName = USER_ONE;
        String inviteeEmail = USER_ONE_EMAIL;
        String inviteeFirstName = USER_ONE_FIRSTNAME;
        String inviteeLastName = USER_ONE_LASTNAME;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        NominatedInvitation nominatedInvitation = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        AbstractInvitationServiceImplTest.assertNotNull((String)"nominated invitation is null", (Object)nominatedInvitation);
        String inviteId = nominatedInvitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)nominatedInvitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)nominatedInvitation.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)nominatedInvitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)nominatedInvitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)nominatedInvitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)nominatedInvitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)nominatedInvitation.getRejectUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)nominatedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)nominatedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)nominatedInvitation.getInviteeEmail());
        NominatedInvitation invitation = (NominatedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertNotNull((String)"invitation is null", (Object)invitation);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)invitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)nominatedInvitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)invitation.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"server path wrong", (String)serverPath, (String)invitation.getServerPath());
        AbstractInvitationServiceImplTest.assertEquals((String)"accept URL wrong", (String)acceptUrl, (String)invitation.getAcceptUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"reject URL wrong", (String)rejectUrl, (String)invitation.getRejectUrl());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)invitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)invitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"email name wrong", (String)inviteeEmail, (String)invitation.getInviteeEmail());
        List<Invitation> invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        NominatedInvitation firstInvite = (NominatedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)firstInvite.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)firstInvite.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)firstInvite.getInviteeUserName());
        NominatedInvitation canceledInvitation = (NominatedInvitation)this.invitationService.cancel(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)canceledInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)canceledInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)canceledInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)canceledInvitation.getInviteeUserName());
        List<Invitation> it2 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it2.isEmpty());
        NominatedInvitation secondInvite = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        NominatedInvitation rejectedInvitation = (NominatedInvitation)this.invitationService.cancel(secondInvite.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)secondInvite.getInviteId(), (String)rejectedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)rejectedInvitation.getInviteeUserName());
        List<Invitation> it3 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it3.isEmpty());
        NominatedInvitation thirdInvite = this.invitationService.inviteNominated(inviteeUserName, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        NominatedInvitation acceptedInvitation = (NominatedInvitation)this.invitationService.accept(thirdInvite.getInviteId(), thirdInvite.getTicket());
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)thirdInvite.getInviteId(), (String)acceptedInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"first name wrong", (String)inviteeFirstName, (String)acceptedInvitation.getInviteeFirstName());
        AbstractInvitationServiceImplTest.assertEquals((String)"last name wrong", (String)inviteeLastName, (String)acceptedInvitation.getInviteeLastName());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)acceptedInvitation.getInviteeUserName());
        List<Invitation> it4 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is not empty", (boolean)it4.isEmpty());
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    public void testModeratedInvitation() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        AbstractInvitationServiceImplTest.assertNotNull((String)"moderated invitation is null", (Object)invitation);
        String inviteId = invitation.getInviteId();
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)invitation.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)invitation.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)invitation.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)invitation.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)invitation.getResourceName());
        ModeratedInvitation mi2 = (ModeratedInvitation)this.invitationService.getInvitation(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id", (String)inviteId, (String)mi2.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"user name wrong", (String)inviteeUserName, (String)mi2.getInviteeUserName());
        AbstractInvitationServiceImplTest.assertEquals((String)"role  name wrong", (String)inviteeRole, (String)mi2.getRoleName());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments", (String)comments, (String)mi2.getInviteeComments());
        AbstractInvitationServiceImplTest.assertEquals((String)"resource type name wrong", (Object)((Object)resourceType), (Object)((Object)mi2.getResourceType()));
        AbstractInvitationServiceImplTest.assertEquals((String)"resource name wrong", (String)resourceName, (String)mi2.getResourceName());
        List<Invitation> invitations = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"invitations is empty", (!invitations.isEmpty() ? 1 : 0) != 0);
        ModeratedInvitation firstInvite = (ModeratedInvitation)invitations.get(0);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)firstInvite.getInviteId());
        ModeratedInvitation canceledInvitation = (ModeratedInvitation)this.invitationService.cancel(inviteId);
        AbstractInvitationServiceImplTest.assertEquals((String)"invite id wrong", (String)inviteId, (String)canceledInvitation.getInviteId());
        AbstractInvitationServiceImplTest.assertEquals((String)"comments wrong", (String)comments, (String)canceledInvitation.getInviteeComments());
        List<Invitation> inv2 = this.invitationService.listPendingInvitationsForResource(resourceType, resourceName);
        AbstractInvitationServiceImplTest.assertTrue((String)"After cancel invitations is not empty", (boolean)inv2.isEmpty());
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invite2 = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String secondInvite = invite2.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.reject(secondInvite, "This is a test reject");
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invite3 = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String thirdInvite = invite3.getInviteId();
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.approve(thirdInvite, "Welcome in");
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    public void testModeratedApprove() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String invitationId = invitation.getInviteId();
        try {
            this.invitationService.approve(invitationId, "No Way Hosea!");
            AbstractInvitationServiceImplTest.assertTrue((String)"excetion not thrown", (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.approve(invitationId, "Come on in");
        String roleName = this.siteService.getMembersRole(resourceName, inviteeUserName);
        AbstractInvitationServiceImplTest.assertEquals((String)"role name wrong", (String)inviteeRole, (String)roleName);
        try {
            this.invitationService.approve(invitationId, "Have I not already done this?");
            AbstractInvitationServiceImplTest.assertTrue((String)"duplicate approve excetion not thrown", (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.siteService.removeMembership(resourceName, inviteeUserName);
    }

    public void testModeratedReject() {
        String inviteeUserName = USER_TWO;
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        this.authenticationComponent.setCurrentUser(USER_TWO);
        ModeratedInvitation invitation = this.invitationService.inviteModerated(comments, inviteeUserName, resourceType, resourceName, inviteeRole);
        String invitationId = invitation.getInviteId();
        try {
            this.invitationService.reject(invitationId, "No Way Hosea!");
            AbstractInvitationServiceImplTest.assertTrue((String)"excetion not thrown", (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.reject(invitationId, "Go away!");
        try {
            this.invitationService.approve(invitationId, "Have I not rejected this?");
            AbstractInvitationServiceImplTest.assertTrue((String)"rejected invitation not working", (boolean)false);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println(e.toString());
        }
    }

    public void testSearchInvitation() {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String inviteeRole = "SiteCollaborator";
        String comments = "please sir, let me in!";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        this.invitationService.inviteModerated(comments, USER_ONE, resourceType, SITE_SHORT_NAME_RED, inviteeRole);
        this.invitationService.inviteNominated(USER_ONE, resourceType, SITE_SHORT_NAME_RED, inviteeRole, serverPath, acceptUrl, rejectUrl);
        NominatedInvitation invitationThree = this.invitationService.inviteNominated(USER_ONE, resourceType, SITE_SHORT_NAME_BLUE, inviteeRole, serverPath, acceptUrl, rejectUrl);
        String threeId = invitationThree.getInviteId();
        this.invitationService.inviteModerated(comments, USER_TWO, resourceType, SITE_SHORT_NAME_RED, inviteeRole);
        List<Invitation> resOne = this.invitationService.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_BLUE);
        AbstractInvitationServiceImplTest.assertEquals((String)"blue invites not 1", (int)1, (int)resOne.size());
        AbstractInvitationServiceImplTest.assertEquals((String)"blue id wrong", (String)threeId, (String)resOne.get(0).getInviteId());
        List<Invitation> resTwo = this.invitationService.listPendingInvitationsForResource(Invitation.ResourceType.WEB_SITE, SITE_SHORT_NAME_RED);
        AbstractInvitationServiceImplTest.assertEquals((String)"red invites not 3", (int)3, (int)resTwo.size());
        List<Invitation> resThree = this.invitationService.listPendingInvitationsForInvitee(USER_ONE);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one does not have 3 invitations", (int)3, (int)resThree.size());
        List<Invitation> resFour = this.invitationService.listPendingInvitationsForInvitee(USER_TWO);
        AbstractInvitationServiceImplTest.assertEquals((String)"user two does not have 1 invitations", (int)1, (int)resFour.size());
        InvitationSearchCriteriaImpl crit1 = new InvitationSearchCriteriaImpl();
        crit1.setInvitee(USER_ONE);
        crit1.setInvitationType(InvitationSearchCriteria.InvitationType.NOMINATED);
        List<Invitation> resFive = this.invitationService.searchInvitation(crit1);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one does not have 2 nominated", (int)2, (int)resFive.size());
        InvitationSearchCriteriaImpl crit2 = new InvitationSearchCriteriaImpl();
        this.invitationService.searchInvitation(crit2);
        AbstractInvitationServiceImplTest.assertTrue((String)"search everything returned 0 elements", (resFive.size() > 0 ? 1 : 0) != 0);
        InvitationSearchCriteriaImpl crit3 = new InvitationSearchCriteriaImpl();
        crit3.setInviter(USER_MANAGER);
        crit3.setInvitationType(InvitationSearchCriteria.InvitationType.NOMINATED);
        List<Invitation> res3 = this.invitationService.searchInvitation(crit3);
        AbstractInvitationServiceImplTest.assertEquals((String)"user one does not have 2 nominated", (int)2, (int)res3.size());
    }

    public void disabled_test100Invites() throws Exception {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = SITE_SHORT_NAME_INVITE;
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        this.authenticationComponent.setCurrentUser(USER_MANAGER);
        for (int i = 0; i < 1000; ++i) {
            this.invitationService.inviteNominated(USER_ONE, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        }
        NominatedInvitation invite = this.invitationService.inviteNominated(USER_TWO, resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        InvitationSearchCriteriaImpl query = new InvitationSearchCriteriaImpl();
        query.setInvitee(USER_TWO);
        long start = System.currentTimeMillis();
        List<Invitation> results = this.invitationService.searchInvitation(query);
        long end = System.currentTimeMillis();
        System.out.println("Invitation Search took " + (end - start) + "ms.");
        AbstractInvitationServiceImplTest.assertEquals((int)1, (int)results.size());
        AbstractInvitationServiceImplTest.assertEquals((String)invite.getInviteId(), (String)results.get(0).getInviteId());
        this.setComplete();
        this.endTransaction();
    }

    public void testGetInvitation() {
        try {
            this.invitationService.getInvitation("jbpm$99999999");
            AbstractInvitationServiceImplTest.fail((String)"should have thrown an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void createPerson(String userName, String emailAddress, String firstName, String lastName) {
        if (!this.authenticationService.authenticationExists(userName)) {
            this.authenticationService.createAuthentication(userName, "password".toCharArray());
        }
        if (!this.personService.personExists(userName)) {
            PropertyMap personProps = new PropertyMap();
            personProps.put(ContentModel.PROP_USERNAME, userName);
            personProps.put(ContentModel.PROP_FIRSTNAME, firstName);
            personProps.put(ContentModel.PROP_LASTNAME, lastName);
            personProps.put(ContentModel.PROP_EMAIL, emailAddress);
            personProps.put(ContentModel.PROP_JOBTITLE, PERSON_JOBTITLE);
            personProps.put(ContentModel.PROP_ORGANIZATION, PERSON_ORG);
            this.personService.createPerson(personProps);
        }
    }

    private void deletePersonByUserName(String userName) {
        if (this.personService.personExists(userName)) {
            this.personService.deletePerson(userName);
        }
    }
}

