/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.Serializable;
import java.util.Collection;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Scriptable;

public class CategoryNode
extends ScriptNode {
    private static final long serialVersionUID = 5757485873550742331L;

    public CategoryNode(NodeRef nodeRef, ServiceRegistry services) {
        super(nodeRef, services);
    }

    public CategoryNode(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        super(nodeRef, services, scope);
    }

    public ScriptNode[] getCategoryMembers() {
        return this.buildNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.ANY));
    }

    public CategoryNode[] getSubCategories() {
        return this.buildCategoryNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.ANY));
    }

    public ScriptNode[] getMembersAndSubCategories() {
        return this.buildMixedNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.ALL, CategoryService.Depth.ANY));
    }

    public ScriptNode[] getImmediateCategoryMembers() {
        return this.buildNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.MEMBERS, CategoryService.Depth.IMMEDIATE));
    }

    public CategoryNode[] getImmediateSubCategories() {
        return this.buildCategoryNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE));
    }

    public ScriptNode[] getImmediateMembersAndSubCategories() {
        return this.buildMixedNodes(this.services.getCategoryService().getChildren(this.getNodeRef(), CategoryService.Mode.ALL, CategoryService.Depth.IMMEDIATE));
    }

    public CategoryNode createSubCategory(String name) {
        return new CategoryNode(this.services.getCategoryService().createCategory(this.getNodeRef(), name), this.services, this.scope);
    }

    public void rename(String name) {
        this.services.getNodeService().setProperty(this.getNodeRef(), ContentModel.PROP_NAME, (Serializable)((Object)name));
        ChildAssociationRef assocRef = this.services.getNodeService().getPrimaryParent(this.nodeRef);
        if (assocRef != null) {
            QName qname = QName.createQName((String)assocRef.getQName().getNamespaceURI(), (String)QName.createValidLocalName((String)name));
            this.services.getNodeService().moveNode(assocRef.getChildRef(), assocRef.getParentRef(), assocRef.getTypeQName(), qname);
        }
    }

    public void removeCategory() {
        this.services.getCategoryService().deleteCategory(this.getNodeRef());
    }

    @Override
    public boolean getIsCategory() {
        return true;
    }

    private CategoryNode[] buildCategoryNodes(Collection<ChildAssociationRef> cars) {
        CategoryNode[] categoryNodes = new CategoryNode[cars.size()];
        int i = 0;
        for (ChildAssociationRef car : cars) {
            categoryNodes[i++] = new CategoryNode(car.getChildRef(), this.services, this.scope);
        }
        return categoryNodes;
    }

    private ScriptNode[] buildNodes(Collection<ChildAssociationRef> cars) {
        ScriptNode[] nodes = new ScriptNode[cars.size()];
        int i = 0;
        for (ChildAssociationRef car : cars) {
            nodes[i++] = new ScriptNode(car.getChildRef(), this.services, this.scope);
        }
        return nodes;
    }

    private ScriptNode[] buildMixedNodes(Collection<ChildAssociationRef> cars) {
        ScriptNode[] nodes = new ScriptNode[cars.size()];
        int i = 0;
        for (ChildAssociationRef car : cars) {
            QName type = this.services.getNodeService().getType(car.getChildRef());
            if (this.services.getDictionaryService().isSubClass(type, ContentModel.TYPE_CATEGORY)) {
                nodes[i++] = new CategoryNode(car.getChildRef(), this.services, this.scope);
                continue;
            }
            nodes[i++] = new ScriptNode(car.getChildRef(), this.services, this.scope);
        }
        return nodes;
    }
}

