/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.jscript.AVMNode;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.ParameterCheck;

public final class CrossRepositoryCopy
extends BaseScopableProcessorExtension {
    public static final String BEAN_NAME = "crossCopyScript";
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public ScriptNode copy(ScriptNode src, ScriptNode dest, String name) {
        ParameterCheck.mandatory((String)"Node source", (Object)src);
        ParameterCheck.mandatory((String)"Node destination", (Object)dest);
        ParameterCheck.mandatory((String)"Node destination name", (Object)name);
        ScriptNode result = null;
        this.services.getCrossRepositoryCopyService().copy(src.getNodeRef(), dest.getNodeRef(), name);
        if (dest.getNodeRef().getStoreRef().getProtocol().equals("avm")) {
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(dest.getNodeRef());
            String destPath = AVMNodeConverter.ExtendAVMPath((String)versionPath.getSecond(), name);
            AVMNodeDescriptor node = this.services.getAVMService().lookup(-1, destPath);
            if (node != null) {
                result = ((AVMNode)dest).newInstance(destPath, -1, this.services, this.getScope());
            }
        } else if (dest.getNodeRef().getStoreRef().getProtocol().equals("workspace")) {
            result = dest.childByNamePath(name);
        }
        return result;
    }
}

