/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.action.executer.TransformActionExecuter;
import org.alfresco.repo.content.transform.UnimportantTransformException;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.jscript.Association;
import org.alfresco.repo.jscript.ContentAwareScriptableQNameMap;
import org.alfresco.repo.jscript.CrossRepositoryCopy;
import org.alfresco.repo.jscript.Scopeable;
import org.alfresco.repo.jscript.ScriptPagingNodes;
import org.alfresco.repo.jscript.ScriptVersion;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.repo.jscript.ValueConverter;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.repo.thumbnail.ThumbnailHelper;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.thumbnail.script.ScriptThumbnail;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.workflow.jscript.JscriptWorkflowInstance;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.lock.LockStatus;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.cmr.workflow.WorkflowInstance;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.FileFilterMode;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO8601DateFormat;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.Wrapper;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.I18NUtil;
import org.springframework.extensions.surf.util.ParameterCheck;
import org.springframework.extensions.surf.util.URLEncoder;

public class ScriptNode
implements Scopeable,
NamespacePrefixResolverProvider {
    private static final long serialVersionUID = -3378946227712939601L;
    private static Log logger = LogFactory.getLog(ScriptNode.class);
    private static final String NAMESPACE_BEGIN = "{";
    private static final String CONTENT_DEFAULT_URL = "/d/d/{0}/{1}/{2}/{3}";
    private static final String CONTENT_DOWNLOAD_URL = "/d/a/{0}/{1}/{2}/{3}";
    private static final String CONTENT_PROP_URL = "/d/d/{0}/{1}/{2}/{3}?property={4}";
    private static final String CONTENT_DOWNLOAD_PROP_URL = "/d/a/{0}/{1}/{2}/{3}?property={4}";
    private static final String FOLDER_BROWSE_URL = "/n/browse/{0}/{1}/{2}";
    protected Scriptable scope;
    protected NodeValueConverter converter = null;
    protected NodeRef nodeRef;
    private FileInfo nodeInfo;
    private String name;
    private QName type;
    protected String id;
    protected String siteName;
    protected boolean siteNameResolved = false;
    protected Set<QName> aspects = null;
    private ScriptableQNameMap<String, Object> targetAssocs = null;
    private ScriptableQNameMap<String, Object> sourceAssocs = null;
    private ScriptableQNameMap<String, Object> childAssocs = null;
    private Scriptable children = null;
    private ScriptableQNameMap<String, Serializable> properties = null;
    private Scriptable versions = null;
    private Scriptable activeWorkflows = null;
    protected ServiceRegistry services = null;
    private NodeService nodeService = null;
    private FileFolderService fileFolderService = null;
    private Boolean isDocument = null;
    private Boolean isContainer = null;
    private Boolean isLinkToDocument = null;
    private Boolean isLinkToContainer = null;
    private Boolean hasChildren = null;
    private String displayPath = null;
    protected TemplateImageResolver imageResolver = null;
    protected ScriptNode parent = null;
    private ChildAssociationRef primaryParentAssoc = null;
    private ScriptableQNameMap<String, Object> parentAssocs = null;

    public ScriptNode(NodeRef nodeRef, ServiceRegistry services) {
        this(nodeRef, services, null);
    }

    public ScriptNode(FileInfo nodeInfo, ServiceRegistry services, Scriptable scope) {
        this(nodeInfo.getNodeRef(), services, scope);
        this.nodeInfo = nodeInfo;
    }

    public ScriptNode(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        if (nodeRef == null) {
            throw new IllegalArgumentException("NodeRef must be supplied.");
        }
        if (services == null) {
            throw new IllegalArgumentException("The ServiceRegistry must be supplied.");
        }
        this.nodeRef = nodeRef;
        this.id = nodeRef.getId();
        this.services = services;
        this.nodeService = services.getNodeService();
        this.fileFolderService = services.getFileFolderService();
        this.scope = scope;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.nodeRef == null ? 0 : this.nodeRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        return this.nodeRef.equals((Object)((ScriptNode)obj).nodeRef);
    }

    public ScriptNode newInstance(NodeRef nodeRef, ServiceRegistry services, Scriptable scope) {
        return new ScriptNode(nodeRef, services, scope);
    }

    public ScriptNode newInstance(FileInfo nodeInfo, ServiceRegistry services, Scriptable scope) {
        return new ScriptNode(nodeInfo, services, scope);
    }

    @Override
    public void setScope(Scriptable scope) {
        this.scope = scope;
    }

    public String getId() {
        return this.id;
    }

    public String getStoreType() {
        return this.nodeRef.getStoreRef().getProtocol();
    }

    public String getStoreId() {
        return this.nodeRef.getStoreRef().getIdentifier();
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }

    public QName getQNameType() {
        if (this.type == null) {
            this.type = this.nodeService.getType(this.nodeRef);
        }
        return this.type;
    }

    public String getType() {
        return this.getQNameType().toString();
    }

    public String getTypeShort() {
        return this.getShortQName(this.getQNameType());
    }

    public String getName() {
        if (this.name == null) {
            this.name = (String)this.getProperties().get("cm:name");
            if (this.name == null) {
                ChildAssociationRef parentRef = this.nodeService.getPrimaryParent(this.nodeRef);
                this.name = parentRef != null && parentRef.getQName() != null ? parentRef.getQName().getLocalName() : "";
            }
        }
        return this.name;
    }

    public void setName(String name) {
        if (name != null) {
            QName typeQName = this.getQNameType();
            if (this.services.getDictionaryService().isSubClass(typeQName, ContentModel.TYPE_FOLDER) && !this.services.getDictionaryService().isSubClass(typeQName, ContentModel.TYPE_SYSTEM_FOLDER) || this.services.getDictionaryService().isSubClass(typeQName, ContentModel.TYPE_CONTENT)) {
                try {
                    this.services.getFileFolderService().rename(this.nodeRef, name);
                }
                catch (FileNotFoundException e) {
                    throw new AlfrescoRuntimeException("Failed to rename node " + this.nodeRef + " to " + name, (Throwable)e);
                }
            }
            this.getProperties().put(ContentModel.PROP_NAME.toString(), name.toString());
        }
    }

    public Scriptable getChildren() {
        if (this.children == null) {
            List childRefs = this.nodeService.getChildAssocs(this.nodeRef);
            Object[] children = new Object[childRefs.size()];
            for (int i = 0; i < childRefs.size(); ++i) {
                children[i] = this.newInstance(((ChildAssociationRef)childRefs.get(i)).getChildRef(), this.services, this.scope);
            }
            ScriptNode.sort(children);
            this.children = Context.getCurrentContext().newArray(this.scope, children);
            this.hasChildren = children.length != 0;
        }
        return this.children;
    }

    private static void sort(Object[] nodes) {
        final Collator col = Collator.getInstance(I18NUtil.getLocale());
        Arrays.sort(nodes, new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                return col.compare(((ScriptNode)o1).getName(), ((ScriptNode)o2).getName());
            }
        });
    }

    public boolean getHasChildren() {
        if (this.hasChildren == null) {
            this.hasChildren = !this.services.getNodeService().getChildAssocs(this.getNodeRef(), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL, false).isEmpty();
        }
        return this.hasChildren;
    }

    public ScriptNode childByNamePath(String path) {
        ScriptNode child = null;
        if (this.services.getDictionaryService().isSubClass(this.getQNameType(), ContentModel.TYPE_FOLDER)) {
            NodeRef result = null;
            final StringTokenizer t = new StringTokenizer(path, "/");
            if (t.hasMoreTokens()) {
                result = this.nodeRef;
                while (t.hasMoreTokens() && result != null) {
                    final String name = t.nextToken();
                    final NodeRef lastName = result;
                    result = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                        public NodeRef doWork() throws Exception {
                            NodeRef child = null;
                            if (t.hasMoreTokens()) {
                                child = ScriptNode.this.nodeService.getChildByName(lastName, ContentModel.ASSOC_CONTAINS, name);
                            } else {
                                child = ScriptNode.this.nodeService.getChildByName(lastName, ContentModel.ASSOC_CONTAINS, name);
                                if (child != null && AccessStatus.ALLOWED != ScriptNode.this.services.getPermissionService().hasPermission(child, "ReadProperties")) {
                                    child = null;
                                }
                            }
                            return child;
                        }
                    });
                }
            }
            child = result != null ? this.newInstance(result, this.services, this.scope) : null;
        } else {
            StringBuilder xpath = new StringBuilder(path.length() << 1);
            StringTokenizer t = new StringTokenizer(path, "/");
            int count = 0;
            QueryParameterDefinition[] params = new QueryParameterDefinition[t.countTokens()];
            DataTypeDefinition ddText = this.services.getDictionaryService().getDataType(DataTypeDefinition.TEXT);
            NamespaceService ns = this.services.getNamespaceService();
            while (t.hasMoreTokens()) {
                if (xpath.length() != 0) {
                    xpath.append('/');
                }
                String strCount = Integer.toString(count);
                xpath.append("*[@cm:name=$cm:name").append(strCount).append(']');
                params[count++] = new QueryParameterDefImpl(QName.createQName((String)"cm", (String)("name" + strCount), (NamespacePrefixResolver)ns), ddText, true, t.nextToken());
            }
            Object[] nodes = this.getChildrenByXPath(xpath.toString(), params, true);
            child = nodes.length != 0 ? (ScriptNode)nodes[0] : null;
        }
        return child;
    }

    public Scriptable childrenByXPath(String xpath) {
        return Context.getCurrentContext().newArray(this.scope, this.getChildrenByXPath(xpath, null, false));
    }

    public Scriptable childFileFolders() {
        return this.childFileFolders(true, true, null);
    }

    public Scriptable childFileFolders(boolean files, boolean folders) {
        return this.childFileFolders(files, folders, null);
    }

    public Scriptable childFileFolders(boolean files, boolean folders, Object ignoreTypes) {
        return this.childFileFolders(files, folders, ignoreTypes, -1, -1, 0, null, null, null).getPage();
    }

    public ScriptPagingNodes childFileFolders(boolean files, boolean folders, Object ignoreTypes, int maxItems) {
        return this.childFileFolders(files, folders, ignoreTypes, 0, maxItems, 0, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptPagingNodes childFileFolders(boolean files, boolean folders, Object ignoreTypes, int skipOffset, int maxItems, int requestTotalCountMax, String sortProp, Boolean sortAsc, String queryExecutionId) {
        HashSet<QName> ignoreTypeQNames = new HashSet<QName>(5);
        if (ignoreTypes instanceof ScriptableObject) {
            Serializable types = this.getValueConverter().convertValueForRepo((Serializable)((ScriptableObject)ignoreTypes));
            if (types instanceof List) {
                for (Serializable typeObj : (List)((Object)types)) {
                    ignoreTypeQNames.add(this.createQName(typeObj.toString()));
                }
            } else if (types instanceof String) {
                ignoreTypeQNames.add(this.createQName(types.toString()));
            }
        } else if (ignoreTypes instanceof String) {
            ignoreTypeQNames.add(this.createQName(ignoreTypes.toString()));
        }
        ArrayList<Pair<QName, Boolean>> sortProps = new ArrayList<Pair<QName, Boolean>>(2);
        if (sortProp == null || !sortProp.equals(GetChildrenCannedQuery.SORT_QNAME_NODE_TYPE.getLocalName())) {
            sortProps.add(new Pair((Object)GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER, (Object)false));
        }
        if (sortProp != null) {
            sortProps.add(new Pair((Object)this.createQName(sortProp), (Object)sortAsc));
        }
        PagingRequest pageRequest = new PagingRequest(skipOffset, maxItems, queryExecutionId);
        pageRequest.setRequestTotalCountMax(requestTotalCountMax);
        PagingResults<FileInfo> pageOfNodeInfos = null;
        FileFilterMode.setClient((FileFilterMode.Client)FileFilterMode.Client.script);
        try {
            pageOfNodeInfos = this.fileFolderService.list(this.nodeRef, files, folders, null, ignoreTypeQNames, sortProps, pageRequest);
        }
        finally {
            FileFilterMode.clearClient();
        }
        List nodeInfos = pageOfNodeInfos.getPage();
        int size = nodeInfos.size();
        Object[] results = new Object[size];
        for (int i = 0; i < size; ++i) {
            FileInfo nodeInfo = (FileInfo)nodeInfos.get(i);
            results[i] = this.newInstance(nodeInfo, this.services, this.scope);
        }
        int totalResultCountLower = -1;
        int totalResultCountUpper = -1;
        Pair totalResultCount = pageOfNodeInfos.getTotalResultCount();
        if (totalResultCount != null) {
            totalResultCountLower = totalResultCount.getFirst() != null ? (Integer)totalResultCount.getFirst() : -1;
            totalResultCountUpper = totalResultCount.getSecond() != null ? (Integer)totalResultCount.getSecond() : -1;
        }
        return new ScriptPagingNodes(Context.getCurrentContext().newArray(this.scope, results), pageOfNodeInfos.hasMoreItems(), totalResultCountLower, totalResultCountUpper);
    }

    public Map<String, Object> getAssocs() {
        if (this.targetAssocs == null) {
            this.targetAssocs = new ScriptableQNameMap(this);
            List refs = this.nodeService.getTargetAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                ArrayList<ScriptNode> nodes = (ArrayList<ScriptNode>)this.targetAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<ScriptNode>(4);
                }
                this.targetAssocs.put(ref.getTypeQName().toString(), nodes);
                nodes.add(this.newInstance(ref.getTargetRef(), this.services, this.scope));
            }
            for (String qname : this.targetAssocs.keySet()) {
                List nodes = (List)this.targetAssocs.get(qname);
                Object[] objs = nodes.toArray(new Object[nodes.size()]);
                this.targetAssocs.put(qname, Context.getCurrentContext().newArray(this.scope, objs));
            }
        }
        return this.targetAssocs;
    }

    public Map<String, Object> getAssociations() {
        return this.getAssocs();
    }

    public Map<String, Object> getSourceAssocs() {
        if (this.sourceAssocs == null) {
            this.sourceAssocs = new ScriptableQNameMap(this);
            List refs = this.nodeService.getSourceAssocs(this.nodeRef, RegexQNamePattern.MATCH_ALL);
            for (AssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                ArrayList<ScriptNode> nodes = (ArrayList<ScriptNode>)this.sourceAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<ScriptNode>(4);
                    this.sourceAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(this.newInstance(ref.getSourceRef(), this.services, this.scope));
            }
            for (String qname : this.sourceAssocs.keySet()) {
                List nodes = (List)this.sourceAssocs.get(qname);
                Object[] objs = nodes.toArray(new Object[nodes.size()]);
                this.sourceAssocs.put(qname, Context.getCurrentContext().newArray(this.scope, objs));
            }
        }
        return this.sourceAssocs;
    }

    public Map<String, Object> getSourceAssociations() {
        return this.getSourceAssocs();
    }

    public Map<String, Object> getChildAssocs() {
        if (this.childAssocs == null) {
            this.childAssocs = new ScriptableQNameMap(this);
            List refs = this.nodeService.getChildAssocs(this.nodeRef);
            for (ChildAssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                ArrayList<ScriptNode> nodes = (ArrayList<ScriptNode>)this.childAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<ScriptNode>(4);
                    this.childAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(this.newInstance(ref.getChildRef(), this.services, this.scope));
            }
            for (String qname : this.childAssocs.keySet()) {
                List nodes = (List)this.childAssocs.get(qname);
                Object[] objs = nodes.toArray(new Object[nodes.size()]);
                this.childAssocs.put(qname, Context.getCurrentContext().newArray(this.scope, objs));
            }
        }
        return this.childAssocs;
    }

    public Map<String, Object> getChildAssociations() {
        return this.getChildAssocs();
    }

    public Scriptable getChildAssocsByType(String type) {
        HashSet<QName> types = new HashSet<QName>(1, 1.0f);
        types.add(this.createQName(type));
        List refs = this.nodeService.getChildAssocs(this.nodeRef, types);
        Object[] nodes = new Object[refs.size()];
        for (int i = 0; i < nodes.length; ++i) {
            ChildAssociationRef ref = (ChildAssociationRef)refs.get(i);
            nodes[i] = this.newInstance(ref.getChildRef(), this.services, this.scope);
        }
        return Context.getCurrentContext().newArray(this.scope, nodes);
    }

    public Map<String, Object> getParentAssocs() {
        if (this.parentAssocs == null) {
            this.parentAssocs = new ScriptableQNameMap(this);
            List refs = this.nodeService.getParentAssocs(this.nodeRef);
            for (ChildAssociationRef ref : refs) {
                String qname = ref.getTypeQName().toString();
                ArrayList<ScriptNode> nodes = (ArrayList<ScriptNode>)this.parentAssocs.get(qname);
                if (nodes == null) {
                    nodes = new ArrayList<ScriptNode>(4);
                    this.parentAssocs.put(ref.getTypeQName().toString(), nodes);
                }
                nodes.add(this.newInstance(ref.getParentRef(), this.services, this.scope));
            }
            for (String qname : this.parentAssocs.keySet()) {
                List nodes = (List)this.parentAssocs.get(qname);
                Object[] objs = nodes.toArray(new Object[nodes.size()]);
                this.parentAssocs.put(qname, Context.getCurrentContext().newArray(this.scope, objs));
            }
        }
        return this.parentAssocs;
    }

    public Map<String, Object> getParentAssociations() {
        return this.getParentAssocs();
    }

    public boolean exists() {
        return this.nodeService.exists(this.nodeRef);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new ContentAwareScriptableQNameMap<String, Serializable>(this, this.services);
            Map props = null;
            props = this.nodeInfo != null ? this.nodeInfo.getProperties() : this.nodeService.getProperties(this.nodeRef);
            for (QName qname : props.keySet()) {
                Serializable propValue = (Serializable)props.get(qname);
                this.properties.put(qname.toString(), this.getValueConverter().convertValueForScript(qname, propValue));
            }
        }
        return this.properties;
    }

    public Scriptable getTypePropertyNames() {
        return this.getTypePropertyNames(true);
    }

    public Scriptable getTypePropertyNames(boolean useShortQNames) {
        Set props = this.services.getDictionaryService().getClass(this.getQNameType()).getProperties().keySet();
        Object[] result = new Object[props.size()];
        int count = 0;
        for (QName qname : props) {
            result[count++] = useShortQNames ? this.getShortQName(qname).toString() : qname.toString();
        }
        return Context.getCurrentContext().newArray(this.scope, result);
    }

    public Scriptable getPropertyNames(boolean useShortQNames) {
        Set props = this.nodeService.getProperties(this.nodeRef).keySet();
        Object[] result = new Object[props.size()];
        int count = 0;
        for (QName qname : props) {
            result[count++] = useShortQNames ? this.getShortQName(qname).toString() : qname.toString();
        }
        return Context.getCurrentContext().newArray(this.scope, result);
    }

    public boolean getIsContainer() {
        if (this.isContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isContainer = dd.isSubClass(this.getQNameType(), ContentModel.TYPE_FOLDER) && !dd.isSubClass(this.getQNameType(), ContentModel.TYPE_SYSTEM_FOLDER);
        }
        return this.isContainer;
    }

    public boolean getIsDocument() {
        if (this.isDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isDocument = dd.isSubClass(this.getQNameType(), ContentModel.TYPE_CONTENT);
        }
        return this.isDocument;
    }

    public boolean getIsLinkToContainer() {
        if (this.isLinkToContainer == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isLinkToContainer = dd.isSubClass(this.getQNameType(), ApplicationModel.TYPE_FOLDERLINK);
        }
        return this.isLinkToContainer;
    }

    public boolean getIsLinkToDocument() {
        if (this.isLinkToDocument == null) {
            DictionaryService dd = this.services.getDictionaryService();
            this.isLinkToDocument = dd.isSubClass(this.getQNameType(), ApplicationModel.TYPE_FILELINK);
        }
        return this.isLinkToDocument;
    }

    public boolean getIsCategory() {
        return false;
    }

    public Set<QName> getAspectsSet() {
        if (this.aspects == null) {
            this.aspects = this.nodeService.getAspects(this.nodeRef);
        }
        return this.aspects;
    }

    public Scriptable getAspects() {
        Set<QName> aspects = this.getAspectsSet();
        Object[] result = new Object[aspects.size()];
        int count = 0;
        for (QName qname : aspects) {
            result[count++] = qname.toString();
        }
        return Context.getCurrentContext().newArray(this.scope, result);
    }

    public boolean hasAspect(String aspect) {
        return this.getAspectsSet().contains(this.createQName(aspect));
    }

    public boolean isSubType(String type) {
        ParameterCheck.mandatoryString((String)"Type", (String)type);
        QName qnameType = this.createQName(type);
        return this.services.getDictionaryService().isSubClass(this.getQNameType(), qnameType);
    }

    public String getQnamePath() {
        return this.services.getNodeService().getPath(this.getNodeRef()).toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    public String getDisplayPath() {
        if (this.displayPath == null) {
            this.displayPath = this.nodeService.getPath(this.nodeRef).toDisplayPath(this.nodeService, this.services.getPermissionService());
        }
        return this.displayPath;
    }

    public String getIcon16() {
        return "/images/filetypes/_default.gif";
    }

    public String getIcon32() {
        return "/images/filetypes32/_default.gif";
    }

    public boolean getIsLocked() {
        LockStatus lockStatus;
        boolean locked = false;
        if (this.getAspectsSet().contains(ContentModel.ASPECT_LOCKABLE) && ((lockStatus = this.services.getLockService().getLockStatus(this.nodeRef)) == LockStatus.LOCKED || lockStatus == LockStatus.LOCK_OWNER)) {
            locked = true;
        }
        return locked;
    }

    public ScriptNode getParent() {
        NodeRef parentRef;
        if (this.parent == null && (parentRef = this.getPrimaryParentAssoc().getParentRef()) != null) {
            this.parent = this.newInstance(parentRef, this.services, this.scope);
        }
        return this.parent;
    }

    public Scriptable getParents() {
        List parentRefs = this.nodeService.getParentAssocs(this.nodeRef);
        Object[] parents = new Object[parentRefs.size()];
        for (int i = 0; i < parentRefs.size(); ++i) {
            NodeRef ref = ((ChildAssociationRef)parentRefs.get(i)).getParentRef();
            parents[i] = this.newInstance(ref, this.services, this.scope);
        }
        return Context.getCurrentContext().newArray(this.scope, parents);
    }

    public ChildAssociationRef getPrimaryParentAssoc() {
        if (this.primaryParentAssoc == null) {
            this.primaryParentAssoc = this.nodeService.getPrimaryParent(this.nodeRef);
        }
        return this.primaryParentAssoc;
    }

    public String getContent() {
        String content = "";
        ScriptContentData contentData = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (contentData != null) {
            content = contentData.getContent();
        }
        return content;
    }

    public void setContent(String content) {
        ScriptContentData contentData = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (contentData != null) {
            contentData.setContent(content);
        }
    }

    public String getUrl() {
        if (this.getIsDocument()) {
            return MessageFormat.format(CONTENT_DEFAULT_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId(), URLEncoder.encode((String)this.getName()));
        }
        return MessageFormat.format(FOLDER_BROWSE_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId());
    }

    public String getDownloadUrl() {
        if (this.getIsDocument()) {
            return MessageFormat.format(CONTENT_DOWNLOAD_URL, this.nodeRef.getStoreRef().getProtocol(), this.nodeRef.getStoreRef().getIdentifier(), this.nodeRef.getId(), URLEncoder.encode((String)this.getName()));
        }
        return "";
    }

    public String jsGet_downloadUrl() {
        return this.getDownloadUrl();
    }

    public String getWebdavUrl() {
        String url = "";
        try {
            if (this.getIsContainer() || this.getIsDocument()) {
                List<FileInfo> paths = this.services.getFileFolderService().getNamePath(null, this.getNodeRef());
                StringBuilder path = new StringBuilder(128);
                path.append("/webdav");
                for (int i = 1; i < paths.size(); ++i) {
                    path.append("/").append(URLEncoder.encode((String)paths.get(i).getName()));
                }
                url = path.toString();
            }
        }
        catch (FileFolderServiceImpl.InvalidTypeException typeErr) {
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return url;
    }

    public String getMimetype() {
        String mimetype = null;
        ScriptContentData content = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (content != null) {
            mimetype = content.getMimetype();
        }
        return mimetype;
    }

    public void setMimetype(String mimetype) {
        ScriptContentData content = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (content != null) {
            content.setMimetype(mimetype);
        }
    }

    public long getSize() {
        long size = 0L;
        ScriptContentData content = (ScriptContentData)this.getProperties().get(ContentModel.PROP_CONTENT);
        if (content != null) {
            size = content.getSize();
        }
        return size;
    }

    public boolean hasPermission(String permission) {
        ParameterCheck.mandatory((String)"Permission Name", (Object)permission);
        boolean allowed = false;
        if (permission != null && permission.length() != 0) {
            AccessStatus status = this.services.getPermissionService().hasPermission(this.nodeRef, permission);
            allowed = AccessStatus.ALLOWED == status;
        }
        return allowed;
    }

    public Scriptable getPermissions() {
        return Context.getCurrentContext().newArray(this.scope, this.retrieveAllSetPermissions(false, false));
    }

    public Scriptable getDirectPermissions() {
        return Context.getCurrentContext().newArray(this.scope, this.retrieveAllSetPermissions(true, false));
    }

    public Scriptable getFullPermissions() {
        return Context.getCurrentContext().newArray(this.scope, this.retrieveAllSetPermissions(false, true));
    }

    protected Object[] retrieveAllSetPermissions(boolean direct, boolean full) {
        Set acls = this.services.getPermissionService().getAllSetPermissions(this.getNodeRef());
        ArrayList<String> permissions = new ArrayList<String>(acls.size());
        for (AccessPermission permission : acls) {
            if (direct && !permission.isSetDirectly()) continue;
            StringBuilder buf = new StringBuilder(64);
            buf.append(permission.getAccessStatus()).append(';').append(permission.getAuthority()).append(';').append(permission.getPermission());
            if (full) {
                buf.append(';').append(permission.isSetDirectly() ? "DIRECT" : "INHERITED");
            }
            permissions.add(buf.toString());
        }
        return permissions.toArray(new Object[permissions.size()]);
    }

    public Scriptable getSettablePermissions() {
        Set permissions = this.services.getPermissionService().getSettablePermissions(this.getNodeRef());
        Object[] result = permissions.toArray(new Object[0]);
        return Context.getCurrentContext().newArray(this.scope, result);
    }

    public boolean inheritsPermissions() {
        return this.services.getPermissionService().getInheritParentPermissions(this.nodeRef);
    }

    public void setInheritsPermissions(boolean inherit) {
        this.services.getPermissionService().setInheritParentPermissions(this.nodeRef, inherit);
    }

    public void setPermission(String permission) {
        ParameterCheck.mandatoryString((String)"Permission Name", (String)permission);
        this.services.getPermissionService().setPermission(this.nodeRef, "GROUP_EVERYONE", permission, true);
    }

    public void setPermission(String permission, String authority) {
        ParameterCheck.mandatoryString((String)"Permission Name", (String)permission);
        ParameterCheck.mandatoryString((String)"Authority", (String)authority);
        this.services.getPermissionService().setPermission(this.nodeRef, authority, permission, true);
    }

    public void removePermission(String permission) {
        ParameterCheck.mandatoryString((String)"Permission Name", (String)permission);
        this.services.getPermissionService().deletePermission(this.nodeRef, "GROUP_EVERYONE", permission);
    }

    public void removePermission(String permission, String authority) {
        ParameterCheck.mandatoryString((String)"Permission Name", (String)permission);
        ParameterCheck.mandatoryString((String)"Authority", (String)authority);
        this.services.getPermissionService().deletePermission(this.nodeRef, authority, permission);
    }

    public void setOwner(String userId) {
        this.services.getOwnableService().setOwner(this.nodeRef, userId);
    }

    public void takeOwnership() {
        this.services.getOwnableService().takeOwnership(this.nodeRef);
    }

    public String getOwner() {
        return this.services.getOwnableService().getOwner(this.nodeRef);
    }

    public void save() {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(this.getProperties().size());
        for (String key : this.properties.keySet()) {
            Serializable value = (Serializable)this.properties.get(key);
            value = this.getValueConverter().convertValueForRepo(value);
            props.put(this.createQName(key), value);
        }
        this.nodeService.setProperties(this.nodeRef, props);
    }

    public boolean specializeType(String type) {
        ParameterCheck.mandatoryString((String)"Type", (String)type);
        QName qnameType = this.createQName(type);
        if (!this.getQNameType().equals((Object)qnameType) && this.services.getDictionaryService().isSubClass(qnameType, this.getQNameType())) {
            this.nodeService.setType(this.nodeRef, qnameType);
            this.type = qnameType;
            return true;
        }
        return false;
    }

    public ScriptNode createFile(String name) {
        return this.createFile(name, null);
    }

    public ScriptNode createFile(String name, String type) {
        ParameterCheck.mandatoryString((String)"Node Name", (String)name);
        FileInfo fileInfo = this.services.getFileFolderService().create(this.nodeRef, name, type == null ? ContentModel.TYPE_CONTENT : this.createQName(type));
        this.reset();
        ScriptNode file = this.newInstance(fileInfo.getNodeRef(), this.services, this.scope);
        file.setMimetype(this.services.getMimetypeService().guessMimetype(name));
        return file;
    }

    public ScriptNode createFolder(String name) {
        return this.createFolder(name, null);
    }

    public ScriptNode createFolder(String name, String type) {
        ParameterCheck.mandatoryString((String)"Node Name", (String)name);
        FileInfo fileInfo = this.services.getFileFolderService().create(this.nodeRef, name, type == null ? ContentModel.TYPE_FOLDER : this.createQName(type));
        this.reset();
        return this.newInstance(fileInfo.getNodeRef(), this.services, this.scope);
    }

    public ScriptNode createNode(String name, String type) {
        return this.createNode(name, type, null, ContentModel.ASSOC_CONTAINS.toString());
    }

    public ScriptNode createNode(String name, String type, String assocType) {
        return this.createNode(name, type, null, assocType);
    }

    public ScriptNode createNode(String name, String type, Object properties) {
        return this.createNode(name, type, properties, ContentModel.ASSOC_CONTAINS.toString());
    }

    public ScriptNode createNode(String name, String type, Object properties, String assocType) {
        return this.createNode(name, type, properties, assocType, null);
    }

    public ScriptNode createNode(String name, String type, Object properties, String assocType, String assocName) {
        ParameterCheck.mandatoryString((String)"Node Type", (String)type);
        ParameterCheck.mandatoryString((String)"Association Type", (String)assocType);
        HashMap<QName, Serializable> props = null;
        if (properties instanceof ScriptableObject) {
            props = new HashMap<QName, Serializable>(4, 1.0f);
            this.extractScriptableProperties((ScriptableObject)properties, props);
        }
        if (name != null) {
            if (props == null) {
                props = new HashMap(1, 1.0f);
            }
            props.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        } else {
            name = GUID.generate();
        }
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.nodeRef, this.createQName(assocType), assocName == null ? QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)name)) : this.createQName(assocName), this.createQName(type), props);
        this.reset();
        return this.newInstance(childAssocRef.getChildRef(), this.services, this.scope);
    }

    public void addNode(ScriptNode node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(node.nodeRef);
        this.nodeService.addChild(this.nodeRef, node.nodeRef, ContentModel.ASSOC_CONTAINS, childAssocRef.getQName());
        this.reset();
    }

    public void removeNode(ScriptNode node) {
        ParameterCheck.mandatory((String)"node", (Object)node);
        this.nodeService.removeChild(this.nodeRef, node.nodeRef);
        this.reset();
    }

    public Association createAssociation(ScriptNode target, String assocType) {
        ParameterCheck.mandatory((String)"Target", (Object)target);
        ParameterCheck.mandatoryString((String)"Association Type Name", (String)assocType);
        AssociationRef assocRef = this.nodeService.createAssociation(this.nodeRef, target.nodeRef, this.createQName(assocType));
        this.reset();
        return new Association(this.services, assocRef);
    }

    public void removeAssociation(ScriptNode target, String assocType) {
        ParameterCheck.mandatory((String)"Target", (Object)target);
        ParameterCheck.mandatoryString((String)"Association Type Name", (String)assocType);
        this.nodeService.removeAssociation(this.nodeRef, target.nodeRef, this.createQName(assocType));
        this.reset();
    }

    public boolean remove() {
        boolean success = false;
        if (this.nodeService.exists(this.nodeRef)) {
            this.nodeService.deleteNode(this.nodeRef);
            success = true;
        }
        this.reset();
        return success;
    }

    public ScriptNode copy(ScriptNode destination) {
        ScriptNode copy = this.copy(destination, false);
        if (copy != null && copy.hasAspect(ContentModel.ASPECT_VERSIONABLE.toString())) {
            copy.ensureVersioningEnabled(true, true);
        }
        return copy;
    }

    public ScriptNode copy(ScriptNode destination, boolean deepCopy) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        ScriptNode copy = null;
        if (destination.getNodeRef().getStoreRef().getProtocol().equals("workspace")) {
            NodeRef copyRef = this.services.getCopyService().copyAndRename(this.nodeRef, destination.getNodeRef(), ContentModel.ASSOC_CONTAINS, null, deepCopy);
            copy = this.newInstance(copyRef, this.services, this.scope);
        } else {
            copy = this.getCrossRepositoryCopyHelper().copy(this, destination, this.getName());
        }
        return copy;
    }

    public ScriptNode revert(String history, boolean majorVersion, String versionLabel) {
        return this.revert(history, majorVersion, versionLabel, false);
    }

    public ScriptNode revert(String history, boolean majorVersion, String versionLabel, boolean deep) {
        if (!this.getIsVersioned()) {
            return null;
        }
        Version version = this.services.getVersionService().getVersionHistory(this.nodeRef).getVersion(versionLabel);
        if (version == null) {
            return null;
        }
        ScriptNode originalNode = this;
        if (this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_WORKING_COPY)) {
            originalNode = this.cancelCheckout();
        }
        this.services.getVersionService().revert(originalNode.getNodeRef(), version, deep);
        ScriptNode workingCopy = originalNode.checkout();
        originalNode = workingCopy.checkin(history, majorVersion);
        return originalNode;
    }

    public boolean move(ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        this.primaryParentAssoc = this.nodeService.moveNode(this.nodeRef, destination.getNodeRef(), ContentModel.ASSOC_CONTAINS, this.getPrimaryParentAssoc().getQName());
        this.reset();
        return true;
    }

    public boolean move(ScriptNode source, ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        if (source == null) {
            return this.move(destination);
        }
        try {
            this.services.getFileFolderService().moveFrom(this.nodeRef, source.getNodeRef(), destination.getNodeRef(), null);
        }
        catch (Exception e) {
            throw new ScriptException("Can't move node", (Throwable)e);
        }
        this.reset();
        return true;
    }

    public boolean addAspect(String type) {
        return this.addAspect(type, null);
    }

    public boolean addAspect(String type, Object props) {
        QName aspectQName;
        ParameterCheck.mandatoryString((String)"Aspect Type", (String)type);
        HashMap<QName, Serializable> aspectProps = null;
        if (props instanceof ScriptableObject) {
            aspectProps = new HashMap<QName, Serializable>(4, 1.0f);
            this.extractScriptableProperties((ScriptableObject)props, aspectProps);
        }
        if ((aspectQName = this.createQName(type)).equals((Object)ContentModel.ASPECT_VERSIONABLE)) {
            if (aspectProps != null) {
                Serializable autoVersionObj = (Serializable)aspectProps.get(ContentModel.PROP_AUTO_VERSION);
                Serializable autoVersionPropsObj = (Serializable)aspectProps.get(ContentModel.PROP_AUTO_VERSION_PROPS);
                this.ensureVersioningEnabled(autoVersionObj instanceof Boolean ? (Boolean)autoVersionObj : true, autoVersionPropsObj instanceof Boolean ? (Boolean)autoVersionPropsObj : true);
            } else {
                this.ensureVersioningEnabled(true, true);
            }
        } else {
            this.nodeService.addAspect(this.nodeRef, aspectQName, aspectProps);
        }
        this.reset();
        return true;
    }

    private void extractScriptableProperties(ScriptableObject scriptable, Map<QName, Serializable> map) {
        Object[] propIds = scriptable.getIds();
        for (int i = 0; i < propIds.length; ++i) {
            String key;
            Object value;
            Object propId = propIds[i];
            if (!(propId instanceof String) || !((value = scriptable.get(key = (String)propId, (Scriptable)scriptable)) instanceof Serializable)) continue;
            value = this.getValueConverter().convertValueForRepo((Serializable)value);
            map.put(this.createQName(key), (Serializable)value);
        }
    }

    public boolean removeAspect(String type) {
        ParameterCheck.mandatoryString((String)"Aspect Type", (String)type);
        QName aspectQName = this.createQName(type);
        this.nodeService.removeAspect(this.nodeRef, aspectQName);
        this.reset();
        return true;
    }

    public void ensureVersioningEnabled(boolean autoVersion, boolean autoVersionProps) {
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(1, 1.0f);
        props.put(ContentModel.PROP_AUTO_VERSION, Boolean.valueOf(autoVersion));
        props.put(ContentModel.PROP_AUTO_VERSION_PROPS, Boolean.valueOf(autoVersionProps));
        this.services.getVersionService().ensureVersioningEnabled(this.nodeRef, props);
    }

    public ScriptVersion createVersion(String history, boolean majorVersion) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(2, 1.0f);
        props.put("description", (Serializable)((Object)history));
        props.put("versionType", (Serializable)((Object)(majorVersion ? VersionType.MAJOR : VersionType.MINOR)));
        ScriptVersion version = new ScriptVersion(this.services.getVersionService().createVersion(this.nodeRef, props), this.services, this.scope);
        this.versions = null;
        return version;
    }

    public boolean getIsVersioned() {
        return this.nodeService.hasAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
    }

    public Scriptable getVersionHistory() {
        VersionHistory history;
        if (this.versions == null && this.getIsVersioned() && (history = this.services.getVersionService().getVersionHistory(this.nodeRef)) != null) {
            Collection<Version> allVersions = history.getAllVersions();
            Object[] versions = new Object[allVersions.size()];
            int i = 0;
            for (Version version : allVersions) {
                versions[i++] = new ScriptVersion(version, this.services, this.scope);
            }
            this.versions = Context.getCurrentContext().newArray(this.scope, versions);
        }
        return this.versions;
    }

    public ScriptVersion getVersion(String versionLabel) {
        if (!this.getIsVersioned()) {
            return null;
        }
        VersionHistory history = this.services.getVersionService().getVersionHistory(this.nodeRef);
        Version version = history.getVersion(versionLabel);
        if (version == null) {
            return null;
        }
        return new ScriptVersion(version, this.services, this.scope);
    }

    public ScriptNode checkout() {
        NodeRef workingCopyRef = this.services.getCheckOutCheckInService().checkout(this.nodeRef);
        ScriptNode workingCopy = this.newInstance(workingCopyRef, this.services, this.scope);
        this.properties = null;
        this.aspects = null;
        return workingCopy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptNode checkoutForUpload() {
        AlfrescoTransactionSupport.bindResource("checkoutforupload", Boolean.TRUE.toString());
        this.services.getRuleService().disableRules();
        try {
            ScriptNode scriptNode = this.checkout();
            return scriptNode;
        }
        finally {
            this.services.getRuleService().enableRules();
        }
    }

    public ScriptNode checkout(ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        ChildAssociationRef childAssocRef = this.nodeService.getPrimaryParent(destination.getNodeRef());
        NodeRef workingCopyRef = this.services.getCheckOutCheckInService().checkout(this.nodeRef, destination.getNodeRef(), ContentModel.ASSOC_CONTAINS, childAssocRef.getQName());
        ScriptNode workingCopy = this.newInstance(workingCopyRef, this.services, this.scope);
        this.properties = null;
        this.aspects = null;
        return workingCopy;
    }

    public ScriptNode checkin() {
        return this.checkin("", false);
    }

    public ScriptNode checkin(String history) {
        return this.checkin(history, false);
    }

    public ScriptNode checkin(String history, boolean majorVersion) {
        HashMap<String, Serializable> props = new HashMap<String, Serializable>(2, 1.0f);
        props.put("description", (Serializable)((Object)history));
        props.put("versionType", (Serializable)((Object)(majorVersion ? VersionType.MAJOR : VersionType.MINOR)));
        NodeRef original = this.services.getCheckOutCheckInService().checkin(this.nodeRef, props);
        this.versions = null;
        return this.newInstance(original, this.services, this.scope);
    }

    public void unlock() {
        this.services.getLockService().unlock(this.nodeRef);
    }

    public ScriptNode cancelCheckout() {
        NodeRef original = this.services.getCheckOutCheckInService().cancelCheckout(this.nodeRef);
        return this.newInstance(original, this.services, this.scope);
    }

    public ScriptNode transformDocument(String mimetype) {
        return this.transformDocument(mimetype, this.getPrimaryParentAssoc().getParentRef());
    }

    public ScriptNode transformDocument(String mimetype, ScriptNode destination) {
        return this.transformDocument(mimetype, destination.getNodeRef());
    }

    private ScriptNode transformDocument(String mimetype, NodeRef destination) {
        ParameterCheck.mandatoryString((String)"Mimetype", (String)mimetype);
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        final NodeRef sourceNodeRef = this.nodeRef;
        Transformer transformer = new Transformer(){

            @Override
            public ScriptNode transform(ContentService contentService, NodeRef nodeRef, ContentReader reader, ContentWriter writer) {
                ScriptNode transformedNode = null;
                TransformationOptions options = new TransformationOptions();
                options.setSourceNodeRef(sourceNodeRef);
                try {
                    contentService.transform(reader, writer, options);
                    transformedNode = ScriptNode.this.newInstance(nodeRef, ScriptNode.this.services, ScriptNode.this.scope);
                }
                catch (NoTransformerException e) {
                    // empty catch block
                }
                return transformedNode;
            }
        };
        return this.transformNode(transformer, mimetype, destination);
    }

    private ScriptNode transformNode(Transformer transformer, String mimetype, NodeRef destination) {
        ScriptNode transformedNode = null;
        ContentService contentService = this.services.getContentService();
        ContentReader reader = contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        if (reader != null) {
            String copyName = TransformActionExecuter.transformName(this.services.getMimetypeService(), this.getName(), mimetype, true);
            NodeRef copyNodeRef = this.services.getCopyService().copy(this.nodeRef, destination, ContentModel.ASSOC_CONTAINS, QName.createQName((String)ContentModel.PROP_CONTENT.getNamespaceURI(), (String)QName.createValidLocalName((String)copyName)), false);
            this.nodeService.setProperty(copyNodeRef, ContentModel.PROP_NAME, (Serializable)((Object)copyName));
            ContentWriter writer = contentService.getWriter(copyNodeRef, ContentModel.PROP_CONTENT, true);
            writer.setMimetype(mimetype);
            writer.setEncoding(reader.getEncoding());
            transformedNode = transformer.transform(contentService, copyNodeRef, reader, writer);
        }
        return transformedNode;
    }

    public ScriptNode transformImage(String mimetype) {
        return this.transformImage(mimetype, null, this.getPrimaryParentAssoc().getParentRef());
    }

    public ScriptNode transformImage(String mimetype, String options) {
        return this.transformImage(mimetype, options, this.getPrimaryParentAssoc().getParentRef());
    }

    public ScriptNode transformImage(String mimetype, ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        return this.transformImage(mimetype, null, destination.getNodeRef());
    }

    public ScriptNode transformImage(String mimetype, String options, ScriptNode destination) {
        ParameterCheck.mandatory((String)"Destination Node", (Object)destination);
        return this.transformImage(mimetype, options, destination.getNodeRef());
    }

    private ScriptNode transformImage(String mimetype, final String options, NodeRef destination) {
        ParameterCheck.mandatoryString((String)"Mimetype", (String)mimetype);
        final NodeRef sourceNodeRef = this.nodeRef;
        Transformer transformer = new Transformer(){

            @Override
            public ScriptNode transform(ContentService contentService, NodeRef nodeRef, ContentReader reader, ContentWriter writer) {
                ImageTransformationOptions imageOptions = new ImageTransformationOptions();
                imageOptions.setSourceNodeRef(sourceNodeRef);
                if (options != null) {
                    imageOptions.setCommandOptions(options);
                }
                contentService.getImageTransformer().transform(reader, writer, imageOptions);
                return ScriptNode.this.newInstance(nodeRef, ScriptNode.this.services, ScriptNode.this.scope);
            }
        };
        return this.transformNode(transformer, mimetype, destination);
    }

    public String processTemplate(ScriptNode template) {
        ParameterCheck.mandatory((String)"Template Node", (Object)template);
        return this.processTemplate(template.getContent(), null, null);
    }

    public String processTemplate(ScriptNode template, Object args) {
        ParameterCheck.mandatory((String)"Template Node", (Object)template);
        return this.processTemplate(template.getContent(), null, (ScriptableObject)args);
    }

    public String processTemplate(String template) {
        ParameterCheck.mandatoryString((String)"Template", (String)template);
        return this.processTemplate(template, null, null);
    }

    public String processTemplate(String template, Object args) {
        ParameterCheck.mandatoryString((String)"Template", (String)template);
        return this.processTemplate(template, null, (ScriptableObject)args);
    }

    private String processTemplate(String template, NodeRef templateRef, ScriptableObject args) {
        Object person = this.scope.get("person", this.scope);
        Object companyhome = this.scope.get("companyhome", this.scope);
        Object userhome = this.scope.get("userhome", this.scope);
        Map<String, Object> model = this.services.getTemplateService().buildDefaultModel(person.equals(UniqueTag.NOT_FOUND) ? null : ((ScriptNode)((Wrapper)person).unwrap()).getNodeRef(), companyhome.equals(UniqueTag.NOT_FOUND) ? null : ((ScriptNode)((Wrapper)companyhome).unwrap()).getNodeRef(), userhome.equals(UniqueTag.NOT_FOUND) ? null : ((ScriptNode)((Wrapper)userhome).unwrap()).getNodeRef(), templateRef, null);
        if (this.getIsDocument()) {
            model.put("document", this.nodeRef);
            model.put("space", this.getPrimaryParentAssoc().getParentRef());
        } else {
            model.put("space", this.nodeRef);
        }
        if (args != null) {
            Object[] propIds = args.getIds();
            HashMap<String, String> templateArgs = new HashMap<String, String>(propIds.length);
            for (int i = 0; i < propIds.length; ++i) {
                Object propId = propIds[i];
                if (!(propId instanceof String)) continue;
                Object value = args.get((String)propId, (Scriptable)args);
                value = this.getValueConverter().convertValueForRepo((Serializable)value);
                if (value == null) continue;
                templateArgs.put((String)propId, value.toString());
            }
            model.put("args", templateArgs);
        }
        return this.services.getTemplateService().processTemplateString(null, template, model);
    }

    public ScriptThumbnail createThumbnail(String thumbnailName) {
        return this.createThumbnail(thumbnailName, false);
    }

    public ScriptThumbnail createThumbnail(String thumbnailName, boolean async) {
        ScriptThumbnail result = null;
        ThumbnailRegistry registry = this.services.getThumbnailService().getThumbnailRegistry();
        ThumbnailDefinition details = registry.getThumbnailDefinition(thumbnailName);
        if (details == null) {
            throw new ScriptException("The thumbnail name '" + thumbnailName + "' is not registered");
        }
        String nodeMimeType = this.getMimetype();
        Serializable value = this.nodeService.getProperty(this.nodeRef, ContentModel.PROP_CONTENT);
        ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)value);
        if (contentData == null) {
            logger.info((Object)("Unable to create thumbnail '" + details.getName() + "' as there is no content"));
            return null;
        }
        if (!registry.isThumbnailDefinitionAvailable(contentData.getContentUrl(), nodeMimeType, this.getSize(), this.nodeRef, details)) {
            logger.info((Object)("Unable to create thumbnail '" + details.getName() + "' for " + nodeMimeType + " as no transformer is currently available"));
            return null;
        }
        if (!async) {
            try {
                NodeRef thumbnailNodeRef = this.services.getThumbnailService().createThumbnail(this.nodeRef, ContentModel.PROP_CONTENT, details.getMimetype(), details.getTransformationOptions(), details.getName());
                result = new ScriptThumbnail(thumbnailNodeRef, this.services, this.scope);
            }
            catch (AlfrescoRuntimeException e) {
                Throwable rootCause = e.getRootCause();
                if (rootCause instanceof UnimportantTransformException) {
                    logger.debug((Object)("Unable to create thumbnail '" + details.getName() + "' as " + rootCause.getMessage()));
                    return null;
                }
                throw e;
            }
        } else {
            Action action = ThumbnailHelper.createCreateThumbnailAction(details, this.services);
            this.services.getActionService().executeAction(action, this.nodeRef, true, true);
        }
        return result;
    }

    public ScriptThumbnail getThumbnail(String thumbnailName) {
        ScriptThumbnail result = null;
        NodeRef thumbnailNodeRef = this.services.getThumbnailService().getThumbnailByName(this.nodeRef, ContentModel.PROP_CONTENT, thumbnailName);
        if (thumbnailNodeRef != null) {
            result = new ScriptThumbnail(thumbnailNodeRef, this.services, this.scope);
        }
        return result;
    }

    public ScriptThumbnail[] getThumbnails() {
        List<NodeRef> thumbnails = this.services.getThumbnailService().getThumbnails(this.nodeRef, ContentModel.PROP_CONTENT, null, null);
        ArrayList<ScriptThumbnail> result = new ArrayList<ScriptThumbnail>(thumbnails.size());
        for (NodeRef thumbnail : thumbnails) {
            ScriptThumbnail scriptThumbnail = new ScriptThumbnail(thumbnail, this.services, this.scope);
            result.add(scriptThumbnail);
        }
        return result.toArray(new ScriptThumbnail[result.size()]);
    }

    public String[] getThumbnailDefinitions() {
        ContentService contentService = this.services.getContentService();
        ThumbnailService thumbnailService = this.services.getThumbnailService();
        ArrayList<String> result = new ArrayList<String>(7);
        ContentReader contentReader = contentService.getReader(this.nodeRef, ContentModel.PROP_CONTENT);
        if (contentReader != null) {
            String mimetype = contentReader.getMimetype();
            List<ThumbnailDefinition> thumbnailDefinitions = thumbnailService.getThumbnailRegistry().getThumbnailDefinitions(mimetype, contentReader.getSize());
            for (ThumbnailDefinition thumbnailDefinition : thumbnailDefinitions) {
                result.add(thumbnailDefinition.getName());
            }
        }
        return result.toArray(new String[result.size()]);
    }

    @Deprecated
    public String[] getThumbnailDefintions() {
        return this.getThumbnailDefinitions();
    }

    public void clearTags() {
        this.services.getTaggingService().clearTags(this.nodeRef);
        this.updateTagProperty();
    }

    public void addTag(String tag) {
        this.services.getTaggingService().addTag(this.nodeRef, tag);
        this.updateTagProperty();
    }

    public void addTags(String[] tags) {
        this.services.getTaggingService().addTags(this.nodeRef, Arrays.asList(tags));
        this.updateTagProperty();
    }

    public void removeTag(String tag) {
        this.services.getTaggingService().removeTag(this.nodeRef, tag);
        this.updateTagProperty();
    }

    public void removeTags(String[] tags) {
        this.services.getTaggingService().removeTags(this.nodeRef, Arrays.asList(tags));
        this.updateTagProperty();
    }

    public String[] getTags() {
        String[] result = null;
        List<String> tags = this.services.getTaggingService().getTags(this.nodeRef);
        result = tags.isEmpty() ? new String[]{} : tags.toArray(new String[tags.size()]);
        return result;
    }

    public void setTags(String[] tags) {
        this.services.getTaggingService().setTags(this.nodeRef, Arrays.asList(tags));
        this.updateTagProperty();
    }

    private void updateTagProperty() {
        Serializable tags = this.services.getNodeService().getProperty(this.nodeRef, ContentModel.PROP_TAGS);
        if (this.properties != null) {
            this.properties.put(ContentModel.PROP_TAGS.toString(), this.getValueConverter().convertValueForScript(ContentModel.PROP_TAGS, tags));
        }
    }

    public void setIsTagScope(boolean value) {
        boolean currentValue = this.services.getTaggingService().isTagScope(this.nodeRef);
        if (currentValue != value) {
            if (value) {
                this.services.getTaggingService().addTagScope(this.nodeRef);
            } else {
                this.services.getTaggingService().removeTagScope(this.nodeRef);
            }
        }
    }

    public boolean getIsTagScope() {
        return this.services.getTaggingService().isTagScope(this.nodeRef);
    }

    public org.alfresco.repo.tagging.script.TagScope getTagScope() {
        org.alfresco.repo.tagging.script.TagScope tagScope = null;
        TagScope tagScopeImpl = this.services.getTaggingService().findTagScope(this.nodeRef);
        if (tagScopeImpl != null) {
            tagScope = new org.alfresco.repo.tagging.script.TagScope(this.services.getTaggingService(), tagScopeImpl);
        }
        return tagScope;
    }

    public ScriptNode[] childrenByTags(String tag) {
        List<NodeRef> nodeRefs = this.services.getTaggingService().findTaggedNodes(this.nodeRef.getStoreRef(), tag, this.nodeRef);
        ScriptNode[] nodes = new ScriptNode[nodeRefs.size()];
        int index = 0;
        for (NodeRef node : nodeRefs) {
            nodes[index] = new ScriptNode(node, this.services, this.scope);
            ++index;
        }
        return nodes;
    }

    public Scriptable getActiveWorkflows() {
        if (this.activeWorkflows == null) {
            WorkflowService workflowService = this.services.getWorkflowService();
            List<WorkflowInstance> workflowInstances = workflowService.getWorkflowsForContent(this.nodeRef, true);
            Object[] jsWorkflowInstances = new Object[workflowInstances.size()];
            int index = 0;
            for (WorkflowInstance workflowInstance : workflowInstances) {
                jsWorkflowInstances[index++] = new JscriptWorkflowInstance(workflowInstance, this.services, this.scope);
            }
            this.activeWorkflows = Context.getCurrentContext().newArray(this.scope, jsWorkflowInstances);
        }
        return this.activeWorkflows;
    }

    public String getSiteShortName() {
        if (!this.siteNameResolved) {
            this.siteNameResolved = true;
            Path path = this.services.getNodeService().getPath(this.getNodeRef());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Determing if node is within a site using path: " + path));
            }
            for (int i = 0; i < path.size(); ++i) {
                if (!"st:sites".equals(path.get(i).getPrefixedString((NamespacePrefixResolver)this.services.getNamespaceService()))) continue;
                if (i + 1 >= path.size()) break;
                Path.Element siteName = path.get(i + 1);
                this.siteName = ISO9075.decode((String)siteName.getPrefixedString((NamespacePrefixResolver)this.services.getNamespaceService()).substring(3));
                break;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)(this.siteName != null ? "Node is in the site named \"" + this.siteName + "\"" : "Node is not in a site"));
        }
        return this.siteName;
    }

    public String toString() {
        if (this.nodeService.exists(this.nodeRef)) {
            if (this.services.getPermissionService().hasPermission(this.nodeRef, "ReadProperties") == AccessStatus.ALLOWED) {
                return "Node Type: " + this.getType() + ", Node Aspects: " + this.getAspectsSet().toString();
            }
            return "Access denied to node " + this.nodeRef;
        }
        return "Node no longer exists: " + this.nodeRef;
    }

    public String toJSON(boolean useShortQNames) {
        String jsonStr = "{}";
        if (this.nodeService.exists(this.nodeRef) && this.services.getPublicServiceAccessService().hasAccess(ServiceRegistry.NODE_SERVICE.getLocalName(), "getProperties", this.nodeRef) == AccessStatus.ALLOWED) {
            JSONObject json = new JSONObject();
            try {
                json.put("nodeRef", (Object)this.getNodeRef().toString());
                String typeString = useShortQNames ? this.getShortQName(this.getQNameType()) : this.getType();
                json.put("type", (Object)typeString);
                json.put("mimetype", (Object)this.getMimetype());
                Map nodeProperties = this.nodeService.getProperties(this.nodeRef);
                for (QName longQName : nodeProperties.keySet()) {
                    Object value = (Serializable)nodeProperties.get(longQName);
                    if (value instanceof Date) {
                        value = ISO8601DateFormat.format((Date)((Date)value));
                        nodeProperties.put(longQName, value);
                    }
                    if (!(value instanceof NodeRef)) continue;
                    value = ((NodeRef)value).toString();
                    nodeProperties.put(longQName, value);
                }
                if (useShortQNames) {
                    LinkedHashMap nodePropertiesShortQNames = new LinkedHashMap(nodeProperties.size());
                    for (QName nextLongQName : nodeProperties.keySet()) {
                        try {
                            String nextShortQName = this.getShortQName(nextLongQName);
                            nodePropertiesShortQNames.put(nextShortQName, nodeProperties.get(nextLongQName));
                        }
                        catch (NamespaceException ne) {
                            if (!logger.isDebugEnabled()) continue;
                            logger.debug((Object)("Ignoring property '" + nextLongQName + "' as it's namespace is not registered"));
                        }
                    }
                    json.put("properties", nodePropertiesShortQNames);
                } else {
                    json.put("properties", nodeProperties);
                }
                Set nodeAspects = this.nodeService.getAspects(this.nodeRef);
                if (useShortQNames) {
                    LinkedHashSet<String> nodeAspectsShortQNames = new LinkedHashSet<String>(nodeAspects.size());
                    for (QName nextLongQName : nodeAspects) {
                        String nextShortQName = this.getShortQName(nextLongQName);
                        nodeAspectsShortQNames.add(nextShortQName);
                    }
                    json.put("aspects", nodeAspectsShortQNames);
                } else {
                    json.put("aspects", (Collection)nodeAspects);
                }
            }
            catch (JSONException error) {
                error.printStackTrace();
            }
            jsonStr = json.toString();
        }
        return jsonStr;
    }

    public String toJSON() {
        return this.toJSON(false);
    }

    protected String getShortQName(QName longQName) {
        return longQName.toPrefixString((NamespacePrefixResolver)this.services.getNamespaceService());
    }

    protected QName createQName(String s) {
        QName qname = s.indexOf(NAMESPACE_BEGIN) != -1 ? QName.createQName((String)s) : QName.createQName((String)s, (NamespacePrefixResolver)this.services.getNamespaceService());
        return qname;
    }

    public void reset() {
        this.name = null;
        this.type = null;
        this.properties = null;
        this.aspects = null;
        this.targetAssocs = null;
        this.sourceAssocs = null;
        this.childAssocs = null;
        this.children = null;
        this.hasChildren = null;
        this.parentAssocs = null;
        this.displayPath = null;
        this.isDocument = null;
        this.isContainer = null;
        this.parent = null;
        this.primaryParentAssoc = null;
        this.activeWorkflows = null;
        this.siteName = null;
        this.siteNameResolved = false;
    }

    protected CrossRepositoryCopy getCrossRepositoryCopyHelper() {
        return (CrossRepositoryCopy)this.services.getService(QName.createQName((String)"", (String)"crossCopyScript"));
    }

    private Object[] getChildrenByXPath(String xpath, QueryParameterDefinition[] params, boolean firstOnly) {
        Object[] result = null;
        if (xpath.length() != 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Executing xpath: " + xpath));
                if (params != null) {
                    for (int i = 0; i < params.length; ++i) {
                        logger.debug((Object)(" [" + params[i].getQName() + "]=" + params[i].getDefault()));
                    }
                }
            }
            List nodes = this.services.getSearchService().selectNodes(this.nodeRef, xpath, params, (NamespacePrefixResolver)this.services.getNamespaceService(), false);
            if (firstOnly) {
                if (nodes.size() != 0) {
                    result = new Object[]{this.newInstance((NodeRef)nodes.get(0), this.services, this.scope)};
                }
            } else {
                result = new Object[nodes.size()];
                for (int i = 0; i < nodes.size(); ++i) {
                    NodeRef ref = (NodeRef)nodes.get(i);
                    result[i] = this.newInstance(ref, this.services, this.scope);
                }
            }
        }
        return result != null ? result : new Object[]{};
    }

    public boolean isScriptContent(Object o) {
        return o instanceof ScriptContentData;
    }

    protected NodeValueConverter getValueConverter() {
        if (this.converter == null) {
            this.converter = this.createValueConverter();
        }
        return this.converter;
    }

    protected NodeValueConverter createValueConverter() {
        return new NodeValueConverter();
    }

    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.services.getNamespaceService();
    }

    private static interface Transformer {
        public ScriptNode transform(ContentService var1, NodeRef var2, ContentReader var3, ContentWriter var4);
    }

    public class ScriptContentData
    implements Content,
    Serializable {
        private static final long serialVersionUID = -7819328543933312278L;
        private ContentData contentData;
        private QName property;

        public ScriptContentData(ContentData contentData, QName property) {
            this.contentData = contentData;
            this.property = property;
        }

        public String getContent() {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(ScriptNode.this.nodeRef, this.property);
            return reader != null && reader.exists() ? reader.getContentString() : "";
        }

        public InputStream getInputStream() {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(ScriptNode.this.nodeRef, this.property);
            return reader != null && reader.exists() ? reader.getContentInputStream() : null;
        }

        public Reader getReader() {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(ScriptNode.this.nodeRef, this.property);
            if (reader != null && reader.exists()) {
                try {
                    return this.contentData.getEncoding() == null ? new InputStreamReader(reader.getContentInputStream()) : new InputStreamReader(reader.getContentInputStream(), this.contentData.getEncoding());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }

        public void setContent(String content) {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(ScriptNode.this.nodeRef, this.property, true);
            writer.setMimetype(this.getMimetype());
            writer.putContent(content);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void write(Content content) {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(ScriptNode.this.nodeRef, this.property, true);
            writer.setMimetype(content.getMimetype());
            writer.setEncoding(content.getEncoding());
            writer.putContent(content.getInputStream());
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void write(Content content, boolean applyMimetype, boolean guessEncoding) {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(ScriptNode.this.nodeRef, this.property, true);
            InputStream is = null;
            if (applyMimetype) {
                writer.setMimetype(content.getMimetype());
            }
            if (guessEncoding) {
                is = new BufferedInputStream(content.getInputStream());
                is.mark(1024);
                writer.setEncoding(this.guessEncoding(is, false));
                try {
                    is.reset();
                }
                catch (IOException e) {}
            } else {
                writer.setEncoding(content.getEncoding());
                is = content.getInputStream();
            }
            writer.putContent(is);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void write(InputStream inputStream) {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(ScriptNode.this.nodeRef, this.property, true);
            writer.putContent(inputStream);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void delete() {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentWriter writer = contentService.getWriter(ScriptNode.this.nodeRef, this.property, true);
            OutputStream output = writer.getContentOutputStream();
            try {
                output.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            writer.setMimetype(null);
            writer.setEncoding(null);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public String getUrl() {
            return MessageFormat.format(ScriptNode.CONTENT_PROP_URL, ScriptNode.this.nodeRef.getStoreRef().getProtocol(), ScriptNode.this.nodeRef.getStoreRef().getIdentifier(), ScriptNode.this.nodeRef.getId(), URLEncoder.encode((String)ScriptNode.this.getName()), URLEncoder.encode((String)this.property.toString()));
        }

        public String getDownloadUrl() {
            if (ScriptNode.this.getIsDocument()) {
                return MessageFormat.format(ScriptNode.CONTENT_DOWNLOAD_PROP_URL, ScriptNode.this.nodeRef.getStoreRef().getProtocol(), ScriptNode.this.nodeRef.getStoreRef().getIdentifier(), ScriptNode.this.nodeRef.getId(), URLEncoder.encode((String)ScriptNode.this.getName()), URLEncoder.encode((String)this.property.toString()));
            }
            return "";
        }

        public long getSize() {
            return this.contentData.getSize();
        }

        public String getMimetype() {
            return this.contentData.getMimetype();
        }

        public String getEncoding() {
            return this.contentData.getEncoding();
        }

        public void setEncoding(String encoding) {
            this.contentData = ContentData.setEncoding((ContentData)this.contentData, (String)encoding);
            ScriptNode.this.services.getNodeService().setProperty(ScriptNode.this.nodeRef, this.property, (Serializable)this.contentData);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void setMimetype(String mimetype) {
            this.contentData = ContentData.setMimetype((ContentData)this.contentData, (String)mimetype);
            ScriptNode.this.services.getNodeService().setProperty(ScriptNode.this.nodeRef, this.property, (Serializable)this.contentData);
            this.contentData = (ContentData)ScriptNode.this.services.getNodeService().getProperty(ScriptNode.this.nodeRef, this.property);
        }

        public void guessMimetype(String filename) {
            ContentService contentService = ScriptNode.this.services.getContentService();
            ContentReader reader = contentService.getReader(ScriptNode.this.nodeRef, this.property);
            this.setMimetype(ScriptNode.this.services.getMimetypeService().guessMimetype(filename, reader));
        }

        public void guessEncoding() {
            this.setEncoding(this.guessEncoding(this.getInputStream(), true));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String guessEncoding(InputStream in, boolean close) {
            String encoding = "UTF-8";
            try {
                if (in != null) {
                    Charset charset = ScriptNode.this.services.getMimetypeService().getContentCharsetFinder().getCharset(in, this.getMimetype());
                    encoding = charset.name();
                }
            }
            finally {
                try {
                    if (close && in != null) {
                        in.close();
                    }
                }
                catch (IOException ioErr) {}
            }
            return encoding;
        }
    }

    public class NodeValueConverter
    extends ValueConverter {
        public Serializable convertValueForScript(QName qname, Serializable value) {
            return this.convertValueForScript(ScriptNode.this.services, ScriptNode.this.scope, qname, value);
        }

        @Override
        public Serializable convertValueForScript(ServiceRegistry services, Scriptable scope, QName qname, Serializable value) {
            value = value instanceof ContentData ? new ScriptContentData((ContentData)value, qname) : super.convertValueForScript(services, scope, qname, value);
            return value;
        }

        @Override
        public Serializable convertValueForRepo(Serializable value) {
            value = value instanceof ScriptContentData ? ((ScriptContentData)value).contentData : super.convertValueForRepo(value);
            return value;
        }
    }
}

