/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ScriptableHashMap<K, V>
extends LinkedHashMap<K, V>
implements Scriptable {
    private static final long serialVersionUID = 3664761893203964569L;
    private Scriptable parentScope;
    private Scriptable prototype;

    public String getClassName() {
        return "ScriptableHashMap";
    }

    public Object get(String name, Scriptable start) {
        if ("length".equals(name)) {
            return this.size();
        }
        if ("hasOwnProperty".equals(name)) {
            return new Callable(){

                public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
                    return args.length > 0 ? Boolean.valueOf(ScriptableHashMap.this.hasOwnProperty(args[0])) : null;
                }
            };
        }
        return this.get(name);
    }

    public Object get(int index, Scriptable start) {
        Object value = null;
        int i = 0;
        Iterator itrValues = this.values().iterator();
        while (i++ <= index && itrValues.hasNext()) {
            value = itrValues.next();
        }
        return value;
    }

    public boolean hasOwnProperty(Object key) {
        return this.containsKey(key);
    }

    public boolean has(String name, Scriptable start) {
        return this.containsKey(name);
    }

    public boolean has(int index, Scriptable start) {
        return index >= 0 && this.values().size() > index;
    }

    public void put(String name, Scriptable start, Object value) {
        this.put(name, value);
    }

    public void put(int index, Scriptable start, Object value) {
    }

    public void delete(String name) {
        this.remove(name);
    }

    public void delete(int index) {
        int i = 0;
        Iterator itrKeys = this.keySet().iterator();
        while (i <= index && itrKeys.hasNext()) {
            Object key = itrKeys.next();
            if (i != index) continue;
            this.remove(key);
            break;
        }
    }

    public Scriptable getPrototype() {
        return this.prototype;
    }

    public void setPrototype(Scriptable prototype) {
        this.prototype = prototype;
    }

    public Scriptable getParentScope() {
        return this.parentScope;
    }

    public void setParentScope(Scriptable parent) {
        this.parentScope = parent;
    }

    public Object[] getIds() {
        return this.keySet().toArray();
    }

    public Object getDefaultValue(Class hint) {
        return null;
    }

    public boolean hasInstance(Scriptable instance) {
        return instance instanceof ScriptableHashMap;
    }
}

