/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript.app;

import java.io.Serializable;
import java.util.LinkedHashMap;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.jscript.ScriptUtils;
import org.alfresco.repo.jscript.app.CustomResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;

public class VtiServerCustomResponse
implements CustomResponse {
    private static Log logger = LogFactory.getLog(VtiServerCustomResponse.class);
    private static final String VTI_MODULE = "org.alfresco.module.vti";
    private int vtiServerPort = 0;
    private String vtiServerHost;
    private String vtiServerProtocol;
    private String contextPath;
    private SysAdminParams sysAdminParams;
    private ScriptUtils scriptUtils;

    public void setScriptUtils(ScriptUtils scriptUtils) throws BeansException {
        this.scriptUtils = scriptUtils;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    public void setPort(int vtiServerPort) {
        this.vtiServerPort = vtiServerPort;
    }

    public void setHost(String vtiServerHost) {
        this.vtiServerHost = vtiServerHost;
    }

    public void setProtocol(String vtiServerProtocol) {
        this.vtiServerProtocol = vtiServerProtocol;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    @Override
    public Serializable populate() {
        try {
            if (!this.scriptUtils.moduleInstalled(VTI_MODULE)) {
                return null;
            }
            LinkedHashMap<String, Object> jsonObj = new LinkedHashMap<String, Object>(4);
            if (this.vtiServerPort != 0) {
                jsonObj.put("port", this.vtiServerPort);
            }
            if (this.vtiServerHost != null) {
                jsonObj.put("host", this.sysAdminParams.subsituteHost(this.vtiServerHost));
            }
            if (this.vtiServerProtocol != null) {
                jsonObj.put("protocol", this.vtiServerProtocol);
            }
            if (this.contextPath != null) {
                jsonObj.put("contextPath", this.contextPath);
            }
            return jsonObj;
        }
        catch (Exception e) {
            logger.warn((Object)"Could not add custom Vti Server response to DocLib webscript");
            return null;
        }
    }
}

