/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.lock;

import java.io.Serializable;
import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.lock.NodeLockedException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.TestWithUserUtils;

public class LockBehaviourImplTest
extends BaseSpringTest {
    private LockService lockService;
    private VersionService versionService;
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;
    private NodeRef nodeRef;
    private NodeRef noAspectNode;
    private StoreRef storeRef;
    private static final String PWD = "password";
    private static final String GOOD_USER_NAME = "goodUser";
    private static final String BAD_USER_NAME = "badUser";
    NodeRef rootNodeRef;

    protected void onSetUpInTransaction() throws Exception {
        this.nodeService = (NodeService)this.applicationContext.getBean("dbNodeService");
        this.lockService = (LockService)this.applicationContext.getBean("lockService");
        this.versionService = (VersionService)this.applicationContext.getBean("versionService");
        this.authenticationService = (MutableAuthenticationService)this.applicationContext.getBean("authenticationService");
        this.permissionService = (PermissionService)this.applicationContext.getBean("permissionService");
        AuthenticationComponent authComponent = (AuthenticationComponent)this.applicationContext.getBean("authenticationComponent");
        authComponent.setSystemUserAsCurrentUser();
        HashMap<QName, String> nodeProperties = new HashMap<QName, String>();
        nodeProperties.put(QName.createQName((String)"{test}property1"), "value1");
        this.storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(this.storeRef);
        this.nodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}ParentNode"), ContentModel.TYPE_FOLDER, nodeProperties).getChildRef();
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_LOCKABLE, new HashMap());
        LockBehaviourImplTest.assertNotNull((Object)this.nodeRef);
        this.noAspectNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{}noAspectNode"), ContentModel.TYPE_CONTAINER, nodeProperties).getChildRef();
        LockBehaviourImplTest.assertNotNull((Object)this.noAspectNode);
        TestWithUserUtils.createUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.createUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.nodeService, this.authenticationService);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.permissionService.setPermission(this.rootNodeRef, GOOD_USER_NAME, "All", true);
        this.permissionService.setPermission(this.rootNodeRef, BAD_USER_NAME, "Read", true);
    }

    public void testCheckForLockNoUser() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.checkForLock(this.nodeRef);
        this.lockService.checkForLock(this.noAspectNode);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        this.lockService.checkForLock(this.nodeRef);
        this.lockService.unlock(this.nodeRef);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException exception) {
            // empty catch block
        }
        this.lockService.unlock(this.nodeRef);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        try {
            TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException exception) {
            // empty catch block
        }
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.unlock(this.nodeRef);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        try {
            TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"The node locked exception should have been raised");
        }
        catch (NodeLockedException nodeLockedException) {
            // empty catch block
        }
    }

    public void testCheckForLockWhenExpired() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK, 1);
        try {
            this.lockService.checkForLock(this.nodeRef);
            LockBehaviourImplTest.fail((String)"Should be locked.");
        }
        catch (NodeLockedException e) {
            // empty catch block
        }
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lockService.checkForLock(this.nodeRef);
    }

    public void testVersionServiceLockBehaviour01() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap<String, Serializable>());
        }
        catch (NodeLockedException exception) {
            LockBehaviourImplTest.fail((String)"There is no lock so this should have worked.");
        }
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap<String, Serializable>());
        }
        catch (NodeLockedException exception) {
            LockBehaviourImplTest.fail((String)"Tried to version as the lock owner so should work.");
        }
        this.lockService.unlock(this.nodeRef);
        this.lockService.lock(this.nodeRef, LockType.READ_ONLY_LOCK);
        try {
            this.versionService.createVersion(this.nodeRef, new HashMap<String, Serializable>());
        }
        catch (NodeLockedException exception) {
            LockBehaviourImplTest.fail((String)"Should have passed, as we should be able to create a version. See ALF-16540");
        }
        this.lockService.unlock(this.nodeRef);
    }

    public void testVersionServiceLockBehaviour02() {
        this.nodeService.addAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE, null);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        try {
            TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
            this.versionService.createVersion(this.nodeRef, new HashMap<String, Serializable>());
            LockBehaviourImplTest.fail((String)"Should have failed since this node has been locked by another user with a write lock.");
        }
        catch (AccessDeniedException accessDeniedException) {
            // empty catch block
        }
    }

    public void testNodeServiceLockBehaviour() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        ChildAssociationRef childAssocRef = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        ChildAssociationRef childAssocRef2 = this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
        NodeRef nodeRef2 = childAssocRef.getChildRef();
        this.nodeService.setProperty(this.nodeRef, QName.createQName((String)"{test}prop1"), (Serializable)((Object)"value1"));
        HashMap<QName, String> propMap = new HashMap<QName, String>();
        propMap.put(QName.createQName((String)"{test}prop2"), "value2");
        this.nodeService.setProperties(this.nodeRef, propMap);
        this.nodeService.removeAspect(this.nodeRef, ContentModel.ASPECT_VERSIONABLE);
        this.lockService.unlock(this.nodeRef);
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        this.lockService.lock(this.nodeRef, LockType.WRITE_LOCK);
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        try {
            this.nodeService.createNode(this.nodeRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER);
            LockBehaviourImplTest.fail((String)"The parent is locked so a new child should not have been created.");
        }
        catch (NodeLockedException exception) {
            // empty catch block
        }
    }

    public void testCannotMoveNodeWhenLocked() {
        TestWithUserUtils.authenticateUser(GOOD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        NodeRef parentNode = this.nodeRef;
        ChildAssociationRef childAssocRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTENT);
        NodeRef nodeRef = childAssocRef.getChildRef();
        this.lockService.lock(nodeRef, LockType.WRITE_LOCK);
        NodeRef newParentRef = this.nodeService.createNode(parentNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"), ContentModel.TYPE_CONTAINER).getChildRef();
        TestWithUserUtils.authenticateUser(BAD_USER_NAME, PWD, this.rootNodeRef, this.authenticationService);
        try {
            this.nodeService.moveNode(nodeRef, newParentRef, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"{test}nodeServiceLockTest"));
            LockBehaviourImplTest.fail((String)"Shouldn't have been able to move locked node.");
        }
        catch (NodeLockedException e) {
            // empty catch block
        }
    }
}

