/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management;

import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.alfresco.repo.management.DynamicMBeanExportOperations;
import org.springframework.jmx.export.MBeanExporter;

public class DynamicMBeanExporter
extends MBeanExporter
implements DynamicMBeanExportOperations {
    private static ThreadLocal<MBeanServer> threadServer = new ThreadLocal();

    public DynamicMBeanExporter() {
        MBeanServer server = threadServer.get();
        if (server != null) {
            this.setServer(server);
        }
        this.setRegistrationBehavior(2);
        this.setAutodetectMode(0);
    }

    public void setServer(MBeanServer server) {
        threadServer.set(server);
        super.setServer(server);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) {
        if (this.registeredBeans.remove(objectName)) {
            try {
                this.server.unregisterMBean(objectName);
                this.onUnregister(objectName);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public ObjectName registerMBean(Object managedResource, ObjectName objectName) {
        Object mbean = this.isMBean(managedResource.getClass()) ? managedResource : this.createAndConfigureMBean(managedResource, managedResource.getClass().getName());
        ObjectName actualObjectName = objectName;
        try {
            try {
                actualObjectName = this.server.registerMBean(mbean, objectName).getObjectName();
            }
            catch (InstanceAlreadyExistsException ex) {
                this.server.unregisterMBean(objectName);
                actualObjectName = this.server.registerMBean(mbean, objectName).getObjectName();
            }
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        this.registeredBeans.add(actualObjectName);
        this.onRegister(actualObjectName);
        return actualObjectName;
    }
}

