/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.repo.domain.schema.SchemaAvailableEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBean;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegisteredEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStartedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanStoppedEvent;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanUnregisteredEvent;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;

public class DefaultPropertyBackedBeanRegistry
implements PropertyBackedBeanRegistry,
ApplicationListener {
    private boolean isSchemaAvailable;
    private List<PropertyBackedBeanEvent> deferredEvents = new LinkedList<PropertyBackedBeanEvent>();
    private List<ApplicationListener> listeners = new LinkedList<ApplicationListener>();

    @Override
    public void addListener(ApplicationListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void register(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanRegisteredEvent(bean));
    }

    @Override
    public void deregister(PropertyBackedBean bean, boolean isPermanent) {
        this.broadcastEvent(new PropertyBackedBeanUnregisteredEvent(bean, isPermanent));
    }

    @Override
    public void broadcastStart(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanStartedEvent(bean));
    }

    @Override
    public void broadcastStop(PropertyBackedBean bean) {
        this.broadcastEvent(new PropertyBackedBeanStoppedEvent(bean));
    }

    private void broadcastEvent(PropertyBackedBeanEvent event) {
        if (this.isSchemaAvailable) {
            for (ApplicationListener listener : this.listeners) {
                listener.onApplicationEvent((ApplicationEvent)event);
            }
        } else {
            this.deferredEvents.add(event);
        }
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof SchemaAvailableEvent) {
            this.isSchemaAvailable = true;
            for (PropertyBackedBeanEvent event1 : this.deferredEvents) {
                this.broadcastEvent(event1);
            }
            this.deferredEvents.clear();
        }
    }
}

