/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml.tools;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.ml.tools.AbstractMultilingualTestCases;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionType;

public class EditionServiceImplTest
extends AbstractMultilingualTestCases {
    private static String FRENCH_CONTENT = "FRENCH_CONTENT";
    private static String CHINESE_CONTENT = "CHINESE_CONTENT";
    private static String JAPANESE_CONTENT = "JAPANESE_CONTENT";
    private ContentService contentService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.contentService = this.serviceRegistry.getContentService();
    }

    public void testAutoEdition() throws Exception {
        this.checkFirstVersion(this.createMLContainerWithContent());
    }

    public void testEditionLabels() {
        NodeRef mlContainerNodeRef = this.createMLContainerWithContent();
        HashMap<String, Serializable> versionProperties = null;
        ArrayList<Version> editions = null;
        NodeRef pivot = this.multilingualContentService.getPivotTranslation(mlContainerNodeRef);
        this.checkFirstVersion(mlContainerNodeRef);
        Version rootEdition = this.editionService.getEditions(mlContainerNodeRef).getAllVersions().iterator().next();
        EditionServiceImplTest.assertTrue((String)("The edition label would be 1.0 and not " + rootEdition.getVersionLabel()), (boolean)rootEdition.getVersionLabel().equals("1.0"));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version firstEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 1.1 and not " + firstEdition.getVersionLabel()), (boolean)firstEdition.getVersionLabel().equals("1.1"));
        versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version secondEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 2.0 and not " + secondEdition.getVersionLabel()), (boolean)secondEdition.getVersionLabel().equals("2.0"));
        versionProperties = new HashMap();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
        pivot = this.editionService.createEdition(pivot, versionProperties);
        editions = new ArrayList<Version>(this.editionService.getEditions(mlContainerNodeRef).getAllVersions());
        Version thirdEdition = (Version)editions.get(0);
        EditionServiceImplTest.assertTrue((String)("The edition label would be 2.1 and not " + thirdEdition.getVersionLabel()), (boolean)thirdEdition.getVersionLabel().equals("2.1"));
    }

    public void testCreateEdition() throws Exception {
        NodeRef mlContainerNodeRef = this.createMLContainerWithContent();
        NodeRef frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.checkFirstVersion(mlContainerNodeRef);
        NodeRef newStartingPoint = this.editionService.createEdition(frenchContentNodeRef, null);
        VersionHistory editionHistory = this.editionService.getEditions(mlContainerNodeRef);
        EditionServiceImplTest.assertTrue((String)"The edition history must contain two versions", (editionHistory.getAllVersions().size() == 2 ? 1 : 0) != 0);
        EditionServiceImplTest.assertTrue((String)"The locale of the conatiner should be changed", (boolean)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE).equals(Locale.FRENCH));
        Version rootEdition = editionHistory.getVersion("1.0");
        Version actualEdition = editionHistory.getVersion("1.1");
        List<VersionHistory> rootVersionTranslations = this.editionService.getVersionedTranslations(rootEdition);
        EditionServiceImplTest.assertNotNull((String)"The root edition can't be null", (Object)rootEdition);
        EditionServiceImplTest.assertNotNull((String)"The actual edition can't be null", (Object)actualEdition);
        EditionServiceImplTest.assertNotNull((String)"The translations list of the root edition can't be null", rootVersionTranslations);
        EditionServiceImplTest.assertFalse((String)"The created starting document must be different that the starting document of the edition", (boolean)frenchContentNodeRef.equals((Object)newStartingPoint));
        EditionServiceImplTest.assertTrue((String)"The new pivot must be equal to the created starting document", (boolean)newStartingPoint.equals((Object)this.multilingualContentService.getPivotTranslation(mlContainerNodeRef)));
        int numberOfTranslations = this.multilingualContentService.getTranslations(mlContainerNodeRef).size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 1 and not " + numberOfTranslations), (int)1, (int)numberOfTranslations);
        numberOfTranslations = this.editionService.getVersionedTranslations(actualEdition).size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 0 and not " + numberOfTranslations), (int)0, (int)numberOfTranslations);
        numberOfTranslations = rootVersionTranslations.size();
        EditionServiceImplTest.assertEquals((String)("The number of translations must be 3 and not " + numberOfTranslations), (int)3, (int)numberOfTranslations);
    }

    public void testReadVersionedContent() throws Exception {
    }

    public void testReadVersionedProperties() throws Exception {
    }

    public void testEditionServiceWithContent() {
        NodeRef mlContainerNodeRef = this.createMLContainerWithContent("1.0");
        NodeRef frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        NodeRef newStartingPoint = this.editionService.createEdition(frenchContentNodeRef, null);
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.1" + "-" + "0.2");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.1" + "-" + "0.3");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.1" + "-" + "0.4");
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        newStartingPoint = this.editionService.createEdition(frenchContentNodeRef, null);
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.2" + "-" + "0.2");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.2" + "-" + "0.3");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        NodeRef chineseContentNodeRef = this.createContent(CHINESE_CONTENT + "-" + Locale.CHINESE + "-" + "1.2" + "-1.0");
        this.multilingualContentService.addTranslation(chineseContentNodeRef, mlContainerNodeRef, Locale.CHINESE);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        NodeRef japaneseContentNodeRef = this.createContent(JAPANESE_CONTENT + "-" + Locale.JAPANESE + "-" + "1.2" + "-1.0");
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, mlContainerNodeRef, Locale.JAPANESE);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        japaneseContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.JAPANESE);
        japaneseContentNodeRef = this.editionService.createEdition(japaneseContentNodeRef, null);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        japaneseContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.JAPANESE);
        this.modifyContent(japaneseContentNodeRef, JAPANESE_CONTENT + "-" + Locale.JAPANESE + "-" + "1.3" + "-0.2");
        chineseContentNodeRef = this.createContent(CHINESE_CONTENT + "-" + Locale.CHINESE + "-" + "1.3" + "-1.0");
        this.multilingualContentService.addTranslation(chineseContentNodeRef, mlContainerNodeRef, Locale.CHINESE);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        frenchContentNodeRef = this.createContent(FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.3" + "-1.0");
        this.multilingualContentService.addTranslation(frenchContentNodeRef, mlContainerNodeRef, Locale.FRENCH);
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        newStartingPoint = this.editionService.createEdition(frenchContentNodeRef, null);
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.4" + "-" + "0.2");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        japaneseContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.JAPANESE);
        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        japaneseContentNodeRef = this.editionService.createEdition(japaneseContentNodeRef, versionProperties);
        Collection<Version> editions = this.editionService.getEditions(mlContainerNodeRef).getAllVersions();
        Version secondEdition = editions.iterator().next();
        EditionServiceImplTest.assertTrue((String)("The edition label would be 2.0 and not " + secondEdition.getVersionLabel()), (boolean)secondEdition.getVersionLabel().equals("2.0"));
        frenchContentNodeRef = this.createContent(FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.0" + "-1.0");
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "1.0" + "-" + "1.1");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
        frenchContentNodeRef = this.multilingualContentService.getTranslationForLocale(mlContainerNodeRef, Locale.FRENCH);
        versionProperties = new HashMap();
        versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
        frenchContentNodeRef = this.editionService.createEdition(frenchContentNodeRef, versionProperties);
        editions = this.editionService.getEditions(mlContainerNodeRef).getAllVersions();
        secondEdition = editions.iterator().next();
        EditionServiceImplTest.assertTrue((String)("The edition label would be 3.0 and not " + secondEdition.getVersionLabel()), (boolean)secondEdition.getVersionLabel().equals("3.0"));
        this.modifyContent(frenchContentNodeRef, FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + "3.0" + "-" + "0.2");
        this.checkContentVersionValuesForEditions(mlContainerNodeRef);
    }

    private void checkFirstVersion(NodeRef mlContainerNodeRef) {
        VersionHistory editionHistory = this.editionService.getEditions(mlContainerNodeRef);
        EditionServiceImplTest.assertNotNull((String)"The edition history can't be null", (Object)editionHistory);
        EditionServiceImplTest.assertTrue((String)"The edition history must contain only one edition", (editionHistory.getAllVersions().size() == 1 ? 1 : 0) != 0);
        Version currentEdition = editionHistory.getAllVersions().iterator().next();
        EditionServiceImplTest.assertTrue((String)"The versioned mlContainer noderef of the editon must be the noderef of the created mlContainer", (boolean)currentEdition.getVersionedNodeRef().equals((Object)mlContainerNodeRef));
        List<VersionHistory> translations = this.editionService.getVersionedTranslations(currentEdition);
        EditionServiceImplTest.assertNotNull((String)"The translations list of the current edition can't be null", translations);
        EditionServiceImplTest.assertTrue((String)"The translations list of the current edition would be empty", (translations.size() == 0 ? 1 : 0) != 0);
    }

    private NodeRef createMLContainerWithContent() {
        NodeRef chineseContentNodeRef = this.createContent(CHINESE_CONTENT + "_1.0");
        NodeRef frenchContentNodeRef = this.createContent(FRENCH_CONTENT + "_1.0");
        NodeRef japaneseContentNodeRef = this.createContent(JAPANESE_CONTENT + "_1.0");
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        return this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
    }

    private void checkContentVersionValuesForEditions(NodeRef mlContainerNodeRef) {
        VersionHistory editionHistory = this.editionService.getEditions(mlContainerNodeRef);
        EditionServiceImplTest.assertNotNull((String)"The edition history can't be null", (Object)editionHistory);
        EditionServiceImplTest.assertTrue((String)"The edition history must contain only one edition", (editionHistory.getAllVersions().size() >= 1 ? 1 : 0) != 0);
        for (Version editionVersion : editionHistory.getAllVersions()) {
            Triplet testTriplet;
            String editionLabel = editionVersion.getVersionLabel();
            if (editionHistory.getHeadVersion() == editionVersion) {
                System.out.println("Head version edition:" + editionLabel);
                Map<Locale, NodeRef> translations = this.multilingualContentService.getTranslations(mlContainerNodeRef);
                Locale pivotLocale = (Locale)this.nodeService.getProperty(mlContainerNodeRef, ContentModel.PROP_LOCALE);
                Set<Locale> keySet = translations.keySet();
                for (Locale locale : keySet) {
                    NodeRef translatedNode = translations.get(locale);
                    ContentReader reader = this.contentService.getReader(translatedNode, ContentModel.PROP_CONTENT);
                    String liveContent = reader.getContentString();
                    Triplet parsedTriplet = new Triplet(liveContent);
                    System.out.println("Content:" + liveContent);
                    VersionHistory versionHistory = this.versionService.getVersionHistory(translatedNode);
                    for (Version version : versionHistory.getAllVersions()) {
                        NodeRef frozenNodeRef = version.getFrozenStateNodeRef();
                        String versionLabel = version.getVersionLabel();
                        Locale versionLocale = (Locale)this.nodeService.getProperty(frozenNodeRef, ContentModel.PROP_LOCALE);
                        reader = this.contentService.getReader(frozenNodeRef, ContentModel.PROP_CONTENT);
                        String versionnedContent = reader.getContentString();
                        System.out.println("Individual version " + versionLabel + ":" + versionnedContent);
                        if (this.versionService.getCurrentVersion(translatedNode).getFrozenStateNodeRef().equals((Object)version.getFrozenStateNodeRef())) {
                            EditionServiceImplTest.assertTrue((String)"The content in head version should be equal to the content of the translation:", (boolean)versionnedContent.equals(liveContent));
                        }
                        if (versionHistory.getRootVersion().getFrozenStateNodeRef().equals((Object)version.getFrozenStateNodeRef()) && pivotLocale.equals(versionLocale)) {
                            System.out.println("Some special on live version has to be done:" + versionnedContent);
                            Version previousEditionVersion = editionHistory.getPredecessor(editionVersion);
                            if (previousEditionVersion == null) continue;
                            String previousEditionLabel = previousEditionVersion.getVersionLabel();
                            System.out.println("Current edition Label:" + editionLabel + " Previous edition label:" + previousEditionLabel);
                            List<VersionHistory> versionTranslations = this.editionService.getVersionedTranslations(previousEditionVersion);
                            for (VersionHistory versionTranslation : versionTranslations) {
                                Version newestVersion = versionTranslation.getHeadVersion();
                                NodeRef newestVersionFrozenNodeRef = newestVersion.getFrozenStateNodeRef();
                                String newestVersionVersionLabel = newestVersion.getVersionLabel();
                                ContentReader readerContentWeStartedWith = this.contentService.getReader(newestVersionFrozenNodeRef, ContentModel.PROP_CONTENT);
                                Locale oldestVersionLocale = (Locale)this.nodeService.getProperty(newestVersionFrozenNodeRef, ContentModel.PROP_LOCALE);
                                String contentWeStartedWith = readerContentWeStartedWith.getContentString();
                                System.out.println("CONTENT:" + contentWeStartedWith);
                                if (!versionLocale.equals(oldestVersionLocale)) continue;
                                EditionServiceImplTest.assertTrue((String)"The content in head version should be equal to the content we started with:", (boolean)contentWeStartedWith.equals(versionnedContent));
                            }
                            continue;
                        }
                        testTriplet = new Triplet(versionnedContent);
                        EditionServiceImplTest.assertEquals((String)testTriplet.locale, (String)versionLocale.toString());
                        EditionServiceImplTest.assertEquals((String)testTriplet.edition, (String)editionLabel);
                        EditionServiceImplTest.assertEquals((String)testTriplet.version, (String)versionLabel);
                    }
                }
                continue;
            }
            Version nextEditionVersion = editionHistory.getSuccessors(editionVersion).iterator().next();
            String nextEditionLabel = nextEditionVersion.getVersionLabel();
            System.out.println("Edition:" + editionLabel + " Next edition label:" + nextEditionLabel);
            List<VersionHistory> versionTranslations = this.editionService.getVersionedTranslations(editionVersion);
            this.dumpFrozenMetaData(editionVersion);
            Locale editionPivotlanguage = (Locale)this.editionService.getVersionedMetadatas(editionVersion).get(ContentModel.PROP_LOCALE);
            System.out.println("Edition:" + editionLabel + " Previous pivot language:" + editionPivotlanguage + " Current pivot language:" + editionPivotlanguage);
            for (VersionHistory versionTranslation : versionTranslations) {
                Collection<Version> versions = versionTranslation.getAllVersions();
                for (Version version : versions) {
                    NodeRef frozenNodeRef = version.getFrozenStateNodeRef();
                    String versionLabel = version.getVersionLabel();
                    Locale currentVersionLocale = (Locale)this.nodeService.getProperty(frozenNodeRef, ContentModel.PROP_LOCALE);
                    System.out.println("Current version locale:" + currentVersionLocale + " Previous edition locale:" + editionPivotlanguage);
                    ContentReader reader = this.contentService.getReader(frozenNodeRef, ContentModel.PROP_CONTENT);
                    String content = reader.getContentString();
                    System.out.println("Content:" + content);
                    Version initialVersion = versionTranslation.getRootVersion();
                    if (!initialVersion.equals(version) || !currentVersionLocale.equals(editionPivotlanguage)) continue;
                    System.out.println("Some special test has to be done:" + content);
                    Version previousEditionVersion = editionHistory.getPredecessor(editionVersion);
                    if (previousEditionVersion != null) {
                        String previousEditionLabel = previousEditionVersion.getVersionLabel();
                        System.out.println("Current edition Label:" + editionLabel + " Previous edition label:" + previousEditionLabel);
                        List<VersionHistory> versionTranslations2 = this.editionService.getVersionedTranslations(previousEditionVersion);
                        for (VersionHistory versionTranslation2 : versionTranslations2) {
                            Version newestVersion = versionTranslation2.getHeadVersion();
                            NodeRef newestVersionFrozenNodeRef = newestVersion.getFrozenStateNodeRef();
                            String newestVersionVersionLabel = newestVersion.getVersionLabel();
                            ContentReader readerContentWeStartedWith = this.contentService.getReader(newestVersionFrozenNodeRef, ContentModel.PROP_CONTENT);
                            Locale oldestVersionLocale = (Locale)this.nodeService.getProperty(newestVersionFrozenNodeRef, ContentModel.PROP_LOCALE);
                            String contentWeStartedWith = readerContentWeStartedWith.getContentString();
                            System.out.println("CONTENT:" + contentWeStartedWith);
                            if (!currentVersionLocale.equals(oldestVersionLocale)) continue;
                            EditionServiceImplTest.assertTrue((String)"The content in head version should be equal to the content we started with:", (boolean)contentWeStartedWith.equals(content));
                        }
                        continue;
                    }
                    testTriplet = new Triplet(content);
                    EditionServiceImplTest.assertTrue((boolean)testTriplet.locale.equals(currentVersionLocale.toString()));
                    EditionServiceImplTest.assertTrue((boolean)testTriplet.edition.equals(editionLabel));
                    EditionServiceImplTest.assertTrue((boolean)testTriplet.version.equals(versionLabel));
                }
            }
        }
    }

    private NodeRef createMLContainerWithContent(String editionSuffix) {
        NodeRef chineseContentNodeRef = this.createContent(CHINESE_CONTENT + "-" + Locale.CHINESE + "-" + editionSuffix + "-1.0");
        NodeRef frenchContentNodeRef = this.createContent(FRENCH_CONTENT + "-" + Locale.FRENCH + "-" + editionSuffix + "-1.0");
        NodeRef japaneseContentNodeRef = this.createContent(JAPANESE_CONTENT + "-" + Locale.JAPANESE + "-" + editionSuffix + "-1.0");
        this.multilingualContentService.makeTranslation(chineseContentNodeRef, Locale.CHINESE);
        this.multilingualContentService.addTranslation(frenchContentNodeRef, chineseContentNodeRef, Locale.FRENCH);
        this.multilingualContentService.addTranslation(japaneseContentNodeRef, chineseContentNodeRef, Locale.JAPANESE);
        return this.multilingualContentService.getTranslationContainer(chineseContentNodeRef);
    }

    private void modifyContent(NodeRef nodeRef, String value) {
        ContentWriter contentWriter = this.contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        contentWriter.putContent(value);
    }

    private void dumpFrozenMetaData(Version editionVersion) {
        System.out.println("---------------------------------------------------");
        System.out.println("Version Label: " + editionVersion.getVersionLabel());
        System.out.println("---------------------------------------------------");
        Map<String, Serializable> mapOfFrozenProps = editionVersion.getVersionProperties();
        if (mapOfFrozenProps == null) {
            System.out.println("Nul... ");
            return;
        }
        for (String q : mapOfFrozenProps.keySet()) {
            String val = mapOfFrozenProps.get(q) == null ? "null" : mapOfFrozenProps.get(q).toString();
            System.out.println("QName:" + q + ":" + val);
        }
    }

    @Override
    protected NodeRef createContent(String name) {
        NodeRef contentNodeRef = this.fileFolderService.create(this.folderNodeRef, name + ".txt", ContentModel.TYPE_CONTENT).getNodeRef();
        ContentWriter contentWriter = this.fileFolderService.getWriter(contentNodeRef);
        contentWriter.putContent(name);
        return contentNodeRef;
    }

    private class Triplet {
        public String locale;
        public String edition;
        public String version;

        public Triplet(String content) {
            String[] tokens = content.split("-");
            this.locale = tokens[1];
            this.edition = tokens[2];
            this.version = tokens[3];
        }
    }
}

