/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.module.tool;

import de.schlichtherle.truezip.file.TArchiveDetector;
import de.schlichtherle.truezip.file.TConfig;
import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.fs.FsDriver;
import de.schlichtherle.truezip.fs.archive.zip.ZipDriver;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.sl.IOPoolLocator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.alfresco.repo.module.ModuleDetailsImpl;
import org.alfresco.repo.module.tool.LogOutput;
import org.alfresco.repo.module.tool.ModuleDetailsHelper;
import org.alfresco.repo.module.tool.ModuleManagementToolException;
import org.alfresco.repo.module.tool.WarHelperImpl;
import org.alfresco.service.cmr.module.ModuleDetails;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.VersionNumber;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.util.FileCopyUtils;

public class WarHelperImplTest
extends WarHelperImpl {
    public WarHelperImplTest() {
        super(new LogOutput(){

            @Override
            public void info(Object message) {
                System.out.println(message);
            }
        });
        TConfig config = TConfig.get();
        config.setArchiveDetector(new TArchiveDetector("war|amp", (FsDriver)new ZipDriver((IOPoolProvider)IOPoolLocator.SINGLETON)));
    }

    @Test
    public void testRegEx() {
        String x = "1";
        Assert.assertTrue((boolean)x.matches("[0-9\\.]*"));
        x = "king";
        Assert.assertFalse((boolean)x.matches("[0-9\\.]*"));
        x = "2.5.a";
        Assert.assertFalse((boolean)x.matches("[0-9\\.]*"));
        x = "1.2.5";
        Assert.assertTrue((boolean)x.matches("[0-9\\.]*"));
        x = "123";
        Assert.assertTrue((boolean)x.matches("[0-9\\.]*"));
        x = "3.4.11";
        Assert.assertTrue((boolean)x.matches("[0-9\\.]*"));
        x = "4.1.1";
        Assert.assertTrue((boolean)x.matches("[0-9\\.]*"));
        x = "4.2.b";
        Assert.assertFalse((boolean)x.matches("[0-9\\.]*"));
    }

    @Test
    public void testCheckCompatibleVersion() {
        TFile theWar = this.getFile(".war", "module/test.war");
        ModuleDetailsImpl installingModuleDetails = new ModuleDetailsImpl("test_it", new VersionNumber("9999"), "Test Mod", "Testing module");
        installingModuleDetails.setRepoVersionMin(new VersionNumber("10.1"));
        try {
            this.checkCompatibleVersion(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("must be installed on a war version greater than 10.1"));
        }
        installingModuleDetails.setRepoVersionMin(new VersionNumber("1.1"));
        this.checkCompatibleVersion(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMax(new VersionNumber("3.0"));
        try {
            this.checkCompatibleVersion(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("cannot be installed on a war version greater than 3.0"));
        }
        installingModuleDetails.setRepoVersionMax(new VersionNumber("99"));
        this.checkCompatibleVersion(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMin(new VersionNumber("4.1.0"));
        installingModuleDetails.setRepoVersionMax(new VersionNumber("4.1.0"));
        this.checkCompatibleVersion(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMin(new VersionNumber("3.4.0"));
        installingModuleDetails.setRepoVersionMax(new VersionNumber("4.1.0"));
        this.checkCompatibleVersion(theWar, installingModuleDetails);
        try {
            installingModuleDetails.setRepoVersionMin(new VersionNumber("3.4.0"));
            installingModuleDetails.setRepoVersionMax(new VersionNumber("4.0.999"));
            this.checkCompatibleVersion(theWar, installingModuleDetails);
            Assert.fail((String)"Should not pass as current version is 4.1.0 and the max value is 4.0.999");
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("cannot be installed on a war version greater than 4.0.999"));
        }
    }

    @Test
    public void testCheckCompatibleVersionUsingManifest() throws IOException {
        TFile theWar = this.getFile(".war", "module/share-3.4.11.war");
        ModuleDetailsImpl installingModuleDetails = new ModuleDetailsImpl("test_it", new VersionNumber("9999"), "Test Mod", "Testing module");
        installingModuleDetails.setRepoVersionMin(new VersionNumber("10.1"));
        try {
            this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("must be installed on a war version greater than 10.1"));
        }
        installingModuleDetails.setRepoVersionMin(new VersionNumber("1.1"));
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMax(new VersionNumber("3.0"));
        try {
            this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("cannot be installed on a war version greater than 3.0"));
        }
        installingModuleDetails.setRepoVersionMax(new VersionNumber("99"));
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMin(new VersionNumber("3.4.11"));
        installingModuleDetails.setRepoVersionMax(new VersionNumber("3.4.11"));
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
        installingModuleDetails.setRepoVersionMin(new VersionNumber("3.4.7"));
        installingModuleDetails.setRepoVersionMax(new VersionNumber("3.4.11"));
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
        try {
            installingModuleDetails.setRepoVersionMin(new VersionNumber("3.4.0"));
            installingModuleDetails.setRepoVersionMax(new VersionNumber("3.4.10"));
            this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
            Assert.fail((String)"Should not pass as current version is 3.4.11 and the max value is 3.4.10");
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("cannot be installed on a war version greater than 3.4.10"));
        }
        theWar = this.getFile(".war", "module/share-4.2.a.war");
        installingModuleDetails = new ModuleDetailsImpl("test_it", new VersionNumber("9999"), "Test Mod", "Testing module");
        installingModuleDetails.setRepoVersionMin(new VersionNumber("101.1"));
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
        theWar = this.getFile(".war", "module/alfresco-4.2.a.war");
        this.checkCompatibleVersionUsingManifest(theWar, installingModuleDetails);
    }

    @Test
    public void testCheckCompatibleEdition() {
        Properties props = this.dummyModuleProperties();
        ModuleDetailsImpl installingModuleDetails = new ModuleDetailsImpl(props);
        TFile theWar = this.getFile(".war", "module/test.war");
        this.checkCompatibleEdition(theWar, installingModuleDetails);
        props.setProperty("module.editions", "CommuniT");
        installingModuleDetails = new ModuleDetailsImpl(props);
        try {
            this.checkCompatibleEdition(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("can only be installed in one of the following editions[CommuniT]"));
        }
        props.setProperty("module.editions", "CoMMunity");
        installingModuleDetails = new ModuleDetailsImpl(props);
        this.checkCompatibleEdition(theWar, installingModuleDetails);
        props.setProperty("module.editions", "enterprise,community,bob");
        installingModuleDetails = new ModuleDetailsImpl(props);
        this.checkCompatibleEdition(theWar, installingModuleDetails);
        props.setProperty("module.editions", "enterprise,Community");
        installingModuleDetails = new ModuleDetailsImpl(props);
        this.checkCompatibleVersion(theWar, installingModuleDetails);
    }

    @Test
    public void testCheckCompatibleEditionUsingManifest() throws IOException {
        Properties props = this.dummyModuleProperties();
        ModuleDetails installingModuleDetails = new ModuleDetailsImpl(props);
        TFile theWar = this.getFile(".war", "module/share-3.4.11.war");
        this.checkCompatibleEditionUsingManifest(theWar, installingModuleDetails);
        props.setProperty("module.editions", "CommuniT");
        installingModuleDetails = new ModuleDetailsImpl(props);
        try {
            this.checkCompatibleEditionUsingManifest(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("can only be installed in one of the following editions[CommuniT]"));
        }
        props.setProperty("module.editions", "Enterprise");
        installingModuleDetails = new ModuleDetailsImpl(props);
        this.checkCompatibleEditionUsingManifest(theWar, installingModuleDetails);
        props.setProperty("module.editions", "Community");
        installingModuleDetails = new ModuleDetailsImpl(props);
        try {
            this.checkCompatibleEditionUsingManifest(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("can only be installed in one of the following editions[Community]"));
        }
        theWar = this.getFile(".war", "module/share-4.2.a.war");
        this.checkCompatibleEditionUsingManifest(theWar, installingModuleDetails);
        String propertiesLocation = this.getFile(".amp", "module/test_v5.amp") + "/module.properties";
        installingModuleDetails = ModuleDetailsHelper.createModuleDetailsFromPropertyLocation(propertiesLocation);
        try {
            this.checkCompatibleEdition(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("can only be installed in one of the following editions[Enterprise]"));
        }
        theWar = this.getFile(".war", "module/share-3.4.11.war");
        this.checkCompatibleEdition(theWar, installingModuleDetails);
        try {
            theWar = this.getFile(".war", "module/share-4.2.a.war");
            this.checkCompatibleEdition(theWar, installingModuleDetails);
            Assert.fail();
        }
        catch (ModuleManagementToolException exception) {
            Assert.assertTrue((boolean)exception.getMessage().endsWith("can only be installed in one of the following editions[Enterprise]"));
        }
    }

    private Properties dummyModuleProperties() {
        Properties props = new Properties();
        props.setProperty("module.id", "TestComp");
        props.setProperty("module.version", "9999");
        props.setProperty("module.title", "Test for Compatiblity");
        props.setProperty("module.description", "Test for Compatible Editions");
        return props;
    }

    @Test
    public void testNoVersionProperties() {
        TFile theWar = this.getFile(".war", "module/empty.war");
        ModuleDetailsImpl installingModuleDetails = new ModuleDetailsImpl("test_it", new VersionNumber("9999"), "Test Mod", "Testing module");
        installingModuleDetails.setRepoVersionMin(new VersionNumber("10.1"));
        this.checkCompatibleVersion(theWar, installingModuleDetails);
        this.checkCompatibleEdition(theWar, installingModuleDetails);
    }

    @Test
    public void testIsShareWar() {
        TFile theWar = this.getFile(".war", "module/test.war");
        Assert.assertFalse((boolean)this.isShareWar(theWar));
        theWar = this.getFile(".war", "module/empty.war");
        Assert.assertFalse((boolean)this.isShareWar(theWar));
        theWar = this.getFile(".war", "module/alfresco-4.2.a.war");
        Assert.assertFalse((boolean)this.isShareWar(theWar));
        theWar = this.getFile(".war", "module/share-4.2.a.war");
        Assert.assertTrue((boolean)this.isShareWar(theWar));
    }

    private TFile getFile(String extension, String location) {
        File file = TempFileProvider.createTempFile((String)"moduleManagementToolTest-", (String)extension);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(location);
        Assert.assertNotNull((Object)is);
        try {
            FileOutputStream os = new FileOutputStream(file);
            FileCopyUtils.copy((InputStream)is, (OutputStream)os);
        }
        catch (IOException error) {
            error.printStackTrace();
        }
        return new TFile(file);
    }
}

