/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class ConcurrentNodeServiceSearchTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST_CONTENT = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"content");
    public static final QName ASPECT_QNAME_TEST_TITLED = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"titled");
    public static final QName PROP_QNAME_TEST_TITLE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"title");
    public static final QName PROP_QNAME_TEST_MIMETYPE = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"mimetype");
    static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private TransactionService transactionService;
    private NodeRef rootNodeRef;
    private FullTextSearchIndexer luceneFTS;
    private AuthenticationComponent authenticationComponent;

    protected void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/systemModel.xml");
        ConcurrentNodeServiceSearchTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        ConcurrentNodeServiceSearchTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        this.nodeService = (NodeService)ctx.getBean("dbNodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.luceneFTS = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        tx.commit();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        super.tearDown();
    }

    protected Map<QName, ChildAssociationRef> buildNodeGraph() throws Exception {
        return BaseNodeServiceTest.buildNodeGraph(this.nodeService, this.rootNodeRef);
    }

    protected Map<QName, ChildAssociationRef> commitNodeGraph() throws Exception {
        UserTransaction tx = this.transactionService.getUserTransaction();
        tx.begin();
        Map<QName, ChildAssociationRef> answer = this.buildNodeGraph();
        tx.commit();
        return null;
    }

    public void testConcurrent() throws Exception {
        this.luceneFTS.pause();
        int count = 10;
        int repeats = 10;
        SearchService searcher = (SearchService)ctx.getBean(ServiceRegistry.SEARCH_SERVICE.getLocalName());
        Map<QName, ChildAssociationRef> assocRefs = this.commitNodeGraph();
        Thread runner = null;
        for (int i = 0; i < count; ++i) {
            runner = new Nester("Concurrent-" + i, runner, repeats, searcher);
        }
        if (runner != null) {
            runner.start();
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        ConcurrentNodeServiceSearchTest.assertEquals((int)2, (int)searcher.selectNodes(this.rootNodeRef, "/*", null, this.getNamespacePrefixReolsver(""), false).size());
        ResultSet results = searcher.query(this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"");
        ConcurrentNodeServiceSearchTest.assertEquals((int)3, (int)results.length());
        results.close();
    }

    private NamespacePrefixResolver getNamespacePrefixReolsver(String defaultURI) {
        DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver(null);
        nspr.registerNamespace("sys", "http://www.alfresco.org/model/system/1.0");
        nspr.registerNamespace("cm", "http://www.alfresco.org/model/content/1.0");
        nspr.registerNamespace("app", "http://www.alfresco.org/model/application/1.0");
        nspr.registerNamespace("namespace", "namespace");
        nspr.registerNamespace("", defaultURI);
        return nspr;
    }

    class Nester
    extends Thread {
        Thread waiter;
        int repeats;
        SearchService searcher;

        Nester(String name, Thread waiter, int repeats, SearchService searcher) {
            super(name);
            this.setDaemon(true);
            this.waiter = waiter;
            this.repeats = repeats;
            this.searcher = searcher;
        }

        @Override
        public void run() {
            ConcurrentNodeServiceSearchTest.this.authenticationComponent.setSystemUserAsCurrentUser();
            if (this.waiter != null) {
                this.waiter.start();
            }
            try {
                System.out.println("Start " + this.getName());
                for (int i = 0; i < this.repeats; ++i) {
                    if (i % 50 == 0) {
                        System.out.println(" " + this.getName() + " " + i);
                    }
                    ResultSet results = this.searcher.query(ConcurrentNodeServiceSearchTest.this.rootNodeRef.getStoreRef(), "lucene", "PATH:\"/*\"");
                    results.close();
                }
                System.out.println("End " + this.getName());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(12);
            }
            if (this.waiter != null) {
                try {
                    this.waiter.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

