/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.util.Set;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.node.GetNodesWithAspectCannedQuery;
import org.alfresco.repo.node.GetNodesWithAspectCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;

public class GetNodesWithAspectCannedQueryFactory
extends AbstractCannedQueryFactory<NodeRef> {
    private NodeDAO nodeDAO;
    private TenantService tenantService;
    private MethodSecurityBean<NodeRef> methodSecurity;

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMethodSecurity(MethodSecurityBean<NodeRef> methodSecurity) {
        this.methodSecurity = methodSecurity;
    }

    public CannedQuery<NodeRef> getCannedQuery(CannedQueryParameters parameters) {
        return new GetNodesWithAspectCannedQuery(this.nodeDAO, this.tenantService, this.methodSecurity, parameters);
    }

    public CannedQuery<NodeRef> getCannedQuery(StoreRef storeRef, Set<QName> aspectQNames, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"aspectQNames", aspectQNames);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        int requestTotalCountMax = pagingRequest.getRequestTotalCountMax();
        GetNodesWithAspectCannedQueryParams paramBean = new GetNodesWithAspectCannedQueryParams(storeRef, aspectQNames);
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(pagingRequest.getSkipCount(), pagingRequest.getMaxItems(), 1, 1);
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, null, requestTotalCountMax, pagingRequest.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"methodSecurityInterceptor", this.methodSecurity);
    }
}

