/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryBootstrap;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.extensions.surf.util.I18NUtil;

public class MetadataEncryptorTests
extends TestCase {
    private static final String TEST_MODEL = "org/alfresco/repo/node/encrypted_prop_model.xml";
    private static QName ENCRYPTED_TYPE_QNAME = QName.createQName((String)"http://www.alfresco.org/test/encryptedPropModel/1.0", (String)"encrypted");
    private static QName ENCRYPTED_PROP_QNAME = QName.createQName((String)"http://www.alfresco.org/test/encryptedPropModel/1.0", (String)"prop1");
    private static final Log logger = LogFactory.getLog(MetadataEncryptorTests.class);
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private TransactionService transactionService;
    private NodeService nodeService;
    private TenantService tenantService;
    private DictionaryDAO dictionaryDAO;
    private MetadataEncryptor metadataEncryptor;
    private StoreRef storeRef;
    private NodeRef rootNodeRef;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.ctx.getBean("ServiceRegistry");
        this.transactionService = serviceRegistry.getTransactionService();
        this.metadataEncryptor = (MetadataEncryptor)this.ctx.getBean("metadataEncryptor");
        this.nodeService = serviceRegistry.getNodeService();
        this.tenantService = (TenantService)this.ctx.getBean("tenantService");
        this.dictionaryDAO = (DictionaryDAO)this.ctx.getBean("dictionaryDAO");
        AuthenticationUtil.setRunAsUserSystem();
        DictionaryBootstrap bootstrap = new DictionaryBootstrap();
        ArrayList<String> bootstrapModels = new ArrayList<String>();
        bootstrapModels.add("alfresco/model/dictionaryModel.xml");
        bootstrapModels.add(TEST_MODEL);
        bootstrap.setModels(bootstrapModels);
        bootstrap.setDictionaryDAO(this.dictionaryDAO);
        bootstrap.setTenantService(this.tenantService);
        bootstrap.bootstrap();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createStoreWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() {
                StoreRef storeRef = MetadataEncryptorTests.this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
                return MetadataEncryptorTests.this.nodeService.getRootNode(storeRef);
            }
        };
        this.rootNodeRef = this.transactionService.getRetryingTransactionHelper().doInTransaction(createStoreWork);
    }

    public void testWithoutEncryption() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> encryptionWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() {
                NodeRef nodeRef1 = MetadataEncryptorTests.this.nodeService.createNode(MetadataEncryptorTests.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)MetadataEncryptorTests.this.getName()), ContentModel.TYPE_FOLDER, null).getChildRef();
                try {
                    NodeRef nodeRef2 = MetadataEncryptorTests.this.nodeService.createNode(nodeRef1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)MetadataEncryptorTests.this.getName()), ENCRYPTED_TYPE_QNAME, Collections.singletonMap(ENCRYPTED_PROP_QNAME, "hello world")).getChildRef();
                    Assert.fail((String)"Should have generated an IllegalArgumentException");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(encryptionWork);
    }

    public void testWithEncryption() {
        RetryingTransactionHelper.RetryingTransactionCallback<Void> encryptionWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() {
                NodeRef nodeRef1 = MetadataEncryptorTests.this.nodeService.createNode(MetadataEncryptorTests.this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)MetadataEncryptorTests.this.getName()), ContentModel.TYPE_FOLDER, null).getChildRef();
                Map<QName, Serializable> allProperties = new PropertyMap();
                allProperties.put(ENCRYPTED_PROP_QNAME, (Serializable)((Object)"ABC"));
                allProperties = MetadataEncryptorTests.this.metadataEncryptor.encrypt(allProperties);
                try {
                    NodeRef nodeRef2 = MetadataEncryptorTests.this.nodeService.createNode(nodeRef1, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)MetadataEncryptorTests.this.getName()), ENCRYPTED_TYPE_QNAME, (Map)allProperties).getChildRef();
                    Assert.assertNotNull((Object)nodeRef2);
                    Serializable encryptedPropertyValue = MetadataEncryptorTests.this.nodeService.getProperty(nodeRef2, ENCRYPTED_PROP_QNAME);
                    Serializable decryptedPropertyValue = MetadataEncryptorTests.this.metadataEncryptor.decrypt(ENCRYPTED_PROP_QNAME, encryptedPropertyValue);
                    Assert.assertEquals((Object)"ABC", (Object)decryptedPropertyValue);
                }
                catch (Throwable e) {
                    Assert.fail();
                }
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(encryptionWork);
    }

    protected void tearDown() {
        AuthenticationUtil.clearCurrentSecurityContext();
        I18NUtil.setLocale(null);
    }
}

