/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryComponent;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.integrity.IntegrityChecker;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class PerformanceNodeServiceTest
extends TestCase {
    public static final String NAMESPACE = "http://www.alfresco.org/test/BaseNodeServiceTest";
    public static final String TEST_PREFIX = "test";
    public static final QName TYPE_QNAME_TEST = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"multiprop");
    public static final QName PROP_QNAME_NAME = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"name");
    public static final QName ASSOC_QNAME_CHILDREN = QName.createQName((String)"http://www.alfresco.org/test/BaseNodeServiceTest", (String)"child");
    private int flushCount = Integer.MAX_VALUE;
    private int testDepth = 3;
    private int testChildCount = 5;
    private int testStringPropertyCount = 10;
    private int testContentPropertyCount = 10;
    private static ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    protected DictionaryService dictionaryService;
    protected NodeService nodeService;
    private ContentService contentService;
    private TransactionService txnService;
    private int nodeCount = 0;
    private long startTime;
    protected NodeRef rootNodeRef;

    protected void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = PerformanceNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        PerformanceNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        PerformanceNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        this.dictionaryService = PerformanceNodeServiceTest.loadModel(applicationContext);
        this.nodeService = (NodeService)applicationContext.getBean("nodeService");
        this.txnService = (TransactionService)applicationContext.getBean("transactionComponent");
        this.contentService = (ContentService)applicationContext.getBean("contentService");
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> createStoreWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() {
                StoreRef storeRef = PerformanceNodeServiceTest.this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
                return PerformanceNodeServiceTest.this.nodeService.getRootNode(storeRef);
            }
        };
        this.rootNodeRef = this.txnService.getRetryingTransactionHelper().doInTransaction(createStoreWork);
    }

    protected void tearDown() {
    }

    public static DictionaryService loadModel(ApplicationContext applicationContext) {
        DictionaryDAO dictionaryDao = (DictionaryDAO)applicationContext.getBean("dictionaryDAO");
        ClassLoader cl = PerformanceNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("alfresco/model/contentModel.xml");
        PerformanceNodeServiceTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        modelStream = cl.getResourceAsStream("org/alfresco/repo/node/BaseNodeServiceTest_model.xml");
        PerformanceNodeServiceTest.assertNotNull((Object)modelStream);
        model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        DictionaryComponent dictionary = new DictionaryComponent();
        dictionary.setDictionaryDAO(dictionaryDao);
        return dictionary;
    }

    public void testSetUp() throws Exception {
        PerformanceNodeServiceTest.assertNotNull((String)"StoreService not set", (Object)this.nodeService);
        PerformanceNodeServiceTest.assertNotNull((String)"NodeService not set", (Object)this.nodeService);
        PerformanceNodeServiceTest.assertNotNull((String)"rootNodeRef not created", (Object)this.rootNodeRef);
    }

    public void testPerformanceNodeService() throws Exception {
        this.startTime = System.currentTimeMillis();
        RetryingTransactionHelper.RetryingTransactionCallback<Object> buildChildrenWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() {
                IntegrityChecker.setWarnInTransaction();
                PerformanceNodeServiceTest.this.buildNodeChildren(PerformanceNodeServiceTest.this.rootNodeRef, 1, PerformanceNodeServiceTest.this.testDepth, PerformanceNodeServiceTest.this.testChildCount);
                return null;
            }
        };
        this.txnService.getRetryingTransactionHelper().doInTransaction(buildChildrenWork);
        long endTime = System.currentTimeMillis();
        System.out.println("Test completed: \n   Built " + this.nodeCount + " nodes in " + (endTime - this.startTime) + "ms \n" + "   Depth: " + this.testDepth + "\n" + "   Child count: " + this.testChildCount);
    }

    public void buildNodeChildren(NodeRef parent, int level, int maxLevel, int childCount) {
        for (int i = 0; i < childCount; ++i) {
            int j;
            ChildAssociationRef assocRef = this.nodeService.createNode(parent, ASSOC_QNAME_CHILDREN, QName.createQName((String)NAMESPACE, (String)("child" + i)), TYPE_QNAME_TEST);
            ++this.nodeCount;
            NodeRef childRef = assocRef.getChildRef();
            this.nodeService.setProperty(childRef, ContentModel.PROP_NAME, (Serializable)((Object)("node" + level + "_" + i)));
            HashMap<QName, String> properties = new HashMap<QName, String>(17);
            for (j = 0; j < this.testStringPropertyCount; ++j) {
                properties.put(QName.createQName((String)NAMESPACE, (String)("string" + j)), level + "_" + i + "_" + j);
            }
            this.nodeService.setProperties(childRef, properties);
            for (j = 0; j < this.testContentPropertyCount; ++j) {
                ContentWriter writer = this.contentService.getWriter(childRef, QName.createQName((String)NAMESPACE, (String)("content" + j)), true);
                writer.setMimetype("text/plain");
                writer.putContent(level + "_" + i + "_" + j);
            }
            long currentTime = System.currentTimeMillis();
            long diffTime = currentTime - this.startTime;
            if (this.nodeCount % this.flushCount == 0) {
                System.out.println("Flushing transaction cache at nodecount: " + this.nodeCount);
                System.out.println("At time index " + diffTime + "ms");
                AlfrescoTransactionSupport.flush();
            }
            if (this.nodeCount % 100 == 0) {
                System.out.println("Interim summary: \n   nodes: " + this.nodeCount + "\n" + "   time: " + (double)diffTime / 1000.0 / 60.0 + " minutes \n" + "   average: " + (double)this.nodeCount / (double)diffTime * 1000.0 + " nodes/s");
            }
            if (level >= maxLevel) continue;
            this.buildNodeChildren(childRef, level + 1, maxLevel, childCount);
        }
    }

    public static void main(String[] args) {
        try {
            PerformanceNodeServiceTest test = new PerformanceNodeServiceTest();
            test.setUp();
            test.testChildCount = 5;
            test.testDepth = 6;
            test.flushCount = 1000;
            test.testPerformanceNodeService();
            test.tearDown();
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

