/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node;

import java.io.Serializable;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class SystemNodeUtils {
    private static Log logger = LogFactory.getLog(SystemNodeUtils.class);
    private static QName SYSTEM_FOLDER_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"system");

    public static NodeRef getSystemContainer(NodeService nodeService, Repository repositoryHelper) {
        NodeRef root = repositoryHelper.getRootHome();
        List sysRefs = nodeService.getChildAssocs(root, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)SYSTEM_FOLDER_QNAME);
        if (sysRefs.size() != 1) {
            throw new IllegalStateException("System folder missing / duplicated! Found " + sysRefs);
        }
        NodeRef system = ((ChildAssociationRef)sysRefs.get(0)).getChildRef();
        return system;
    }

    public static NodeRef getSystemChildContainer(QName childName, NodeService nodeService, Repository repositoryHelper) {
        NodeRef system = SystemNodeUtils.getSystemContainer(nodeService, repositoryHelper);
        List containerRefs = nodeService.getChildAssocs(system, (QNamePattern)ContentModel.ASSOC_CHILDREN, (QNamePattern)childName);
        NodeRef container = null;
        if (containerRefs.size() > 0) {
            container = ((ChildAssociationRef)containerRefs.get(0)).getChildRef();
            if (containerRefs.size() > 1) {
                logger.warn((Object)("Duplicate Shared Credentials Containers found: " + containerRefs));
            }
        }
        return container;
    }

    public static Pair<NodeRef, Boolean> getOrCreateSystemChildContainer(final QName childName, final NodeService nodeService, final Repository repositoryHelper) {
        NodeRef container = SystemNodeUtils.getSystemChildContainer(childName, nodeService, repositoryHelper);
        if (container != null) {
            return new Pair((Object)container, (Object)Boolean.FALSE);
        }
        container = (NodeRef)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

            public NodeRef doWork() throws Exception {
                NodeRef system = SystemNodeUtils.getSystemContainer(nodeService, repositoryHelper);
                NodeRef container = nodeService.createNode(system, ContentModel.ASSOC_CHILDREN, childName, ContentModel.TYPE_CONTAINER).getChildRef();
                nodeService.setProperty(container, ContentModel.PROP_NAME, (Serializable)((Object)childName.getLocalName()));
                return container;
            }
        });
        return new Pair((Object)container, (Object)Boolean.TRUE);
    }
}

