/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.getchildren;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.alfresco.query.AbstractCannedQueryFactory;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.domain.locale.LocaleDAO;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodePropertyHelper;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.node.getchildren.FilterProp;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQueryParams;
import org.alfresco.repo.security.permissions.impl.acegi.MethodSecurityBean;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyCheck;

public class GetChildrenCannedQueryFactory
extends AbstractCannedQueryFactory<NodeRef> {
    protected DictionaryService dictionaryService;
    protected NodeDAO nodeDAO;
    protected QNameDAO qnameDAO;
    protected LocaleDAO localeDAO;
    protected ContentDataDAO contentDataDAO;
    protected CannedQueryDAO cannedQueryDAO;
    protected TenantService tenantService;
    protected MethodSecurityBean<NodeRef> methodSecurity;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setLocaleDAO(LocaleDAO localeDAO) {
        this.localeDAO = localeDAO;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public void setCannedQueryDAO(CannedQueryDAO cannedQueryDAO) {
        this.cannedQueryDAO = cannedQueryDAO;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setMethodSecurity(MethodSecurityBean<NodeRef> methodSecurity) {
        this.methodSecurity = methodSecurity;
    }

    public CannedQuery<NodeRef> getCannedQuery(CannedQueryParameters parameters) {
        NodePropertyHelper nodePropertyHelper = new NodePropertyHelper(this.dictionaryService, this.qnameDAO, this.localeDAO, this.contentDataDAO);
        return new GetChildrenCannedQuery(this.nodeDAO, this.qnameDAO, this.cannedQueryDAO, nodePropertyHelper, this.tenantService, this.methodSecurity, parameters);
    }

    public CannedQuery<NodeRef> getCannedQuery(NodeRef parentRef, String pattern, Set<QName> assocTypeQNames, Set<QName> childTypeQNames, List<FilterProp> filterProps, List<Pair<QName, Boolean>> sortProps, PagingRequest pagingRequest) {
        ParameterCheck.mandatory((String)"parentRef", (Object)parentRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        int requestTotalCountMax = pagingRequest.getRequestTotalCountMax();
        GetChildrenCannedQueryParams paramBean = new GetChildrenCannedQueryParams(this.tenantService.getName(parentRef), assocTypeQNames, childTypeQNames, filterProps, pattern);
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(pagingRequest.getSkipCount(), pagingRequest.getMaxItems(), 1, 1);
        CannedQuerySortDetails cqsd = null;
        if (sortProps != null) {
            ArrayList<Pair> sortPairs = new ArrayList<Pair>(sortProps.size());
            for (Pair<QName, Boolean> sortProp : sortProps) {
                sortPairs.add(new Pair(sortProp.getFirst(), (Object)((Boolean)sortProp.getSecond() != false ? CannedQuerySortDetails.SortOrder.ASCENDING : CannedQuerySortDetails.SortOrder.DESCENDING)));
            }
            cqsd = new CannedQuerySortDetails(sortPairs);
        }
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, cqsd, requestTotalCountMax, pagingRequest.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    public CannedQuery<NodeRef> getCannedQuery(NodeRef parentRef, String pattern, Set<QName> assocTypeQNames, Set<QName> childTypeQNames, PagingRequest pagingRequest) {
        return this.getCannedQuery(parentRef, pattern, assocTypeQNames, childTypeQNames, null, null, pagingRequest);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        PropertyCheck.mandatory((Object)((Object)this), (String)"dictionaryService", (Object)this.dictionaryService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"tenantService", (Object)this.tenantService);
        PropertyCheck.mandatory((Object)((Object)this), (String)"nodeDAO", (Object)this.nodeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"qnameDAO", (Object)this.qnameDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"localeDAO", (Object)this.localeDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"contentDataDAO", (Object)this.contentDataDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"cannedQueryDAO", (Object)this.cannedQueryDAO);
        PropertyCheck.mandatory((Object)((Object)this), (String)"methodSecurityInterceptor", this.methodSecurity);
    }
}

