/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.List;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.search.AVMSnapShotTriggeredIndexingMethodInterceptor;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AVMRemoteSnapshotTracker
extends AbstractReindexComponent {
    private static Log logger = LogFactory.getLog(AVMRemoteSnapshotTracker.class);
    private AVMService avmService;
    private AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSnapShotTriggeredIndexingMethodInterceptor(AVMSnapShotTriggeredIndexingMethodInterceptor avmSnapShotTriggeredIndexingMethodInterceptor) {
        this.avmSnapShotTriggeredIndexingMethodInterceptor = avmSnapShotTriggeredIndexingMethodInterceptor;
    }

    @Override
    protected void reindexImpl() {
        this.processStores();
    }

    private void processStores() {
        boolean upToDate;
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        if (stores.size() == 0) {
            return;
        }
        do {
            upToDate = true;
            for (AVMStoreDescriptor store : stores) {
                if (this.isShuttingDown()) break;
                if (this.avmSnapShotTriggeredIndexingMethodInterceptor.getIndexMode(store.getName()) == IndexMode.UNINDEXED) continue;
                int current = this.avmService.getLatestSnapshotID(store.getName());
                int lastIndexed = this.avmSnapShotTriggeredIndexingMethodInterceptor.getLastIndexedSnapshot(store.getName());
                if (lastIndexed >= current) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Reindexing snapshots for AVM store " + store.getName() + " from " + lastIndexed + " to " + current));
                }
                this.recoverSnapShot(store.getName(), lastIndexed, current);
                upToDate = false;
            }
            if (!upToDate || !logger.isDebugEnabled()) continue;
            logger.debug((Object)"Reindex check complete for AVM stores");
        } while (!upToDate);
    }

    private void recoverSnapShot(final String store, final int lastIndexed, final int current) {
        RetryingTransactionHelper.RetryingTransactionCallback<Object> reindexWork = new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

            @Override
            public Object execute() throws Exception {
                if (lastIndexed == -1) {
                    AVMRemoteSnapshotTracker.this.avmSnapShotTriggeredIndexingMethodInterceptor.createIndex(store);
                }
                AVMRemoteSnapshotTracker.this.avmSnapShotTriggeredIndexingMethodInterceptor.indexSnapshot(store, lastIndexed, current);
                return null;
            }
        };
        this.transactionService.getRetryingTransactionHelper().doInTransaction(reindexWork, true);
    }
}

