/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.List;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.Transaction;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.index.AVMFullIndexRecoveryComponent;
import org.alfresco.repo.node.index.AbstractReindexComponent;
import org.alfresco.repo.node.index.FullIndexRecoveryComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class FullIndexRecoveryComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private FullIndexRecoveryComponent indexRecoverer;
    private AVMFullIndexRecoveryComponent avmIndexRecoveryComponent;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private UserTransaction testTX;
    private NodeDAO nodeDAO;

    public void setUp() throws Exception {
        ChildApplicationContextFactory luceneSubSystem = (ChildApplicationContextFactory)ctx.getBean("lucene");
        this.indexRecoverer = (FullIndexRecoveryComponent)luceneSubSystem.getApplicationContext().getBean("search.indexRecoveryComponent");
        this.avmIndexRecoveryComponent = (AVMFullIndexRecoveryComponent)luceneSubSystem.getApplicationContext().getBean("search.avmIndexRecoveryComponent");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    public void testSetup() throws Exception {
    }

    public void XtestDeletionReporting() throws Exception {
        int i;
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        NodeRef folder = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"{namespace}folder"), ContentModel.TYPE_FOLDER).getChildRef();
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        NodeRef[] refs = new NodeRef[20];
        for (i = 0; i < refs.length; ++i) {
            refs[i] = this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)("{namespace}file" + i)), ContentModel.TYPE_CONTENT).getChildRef();
        }
        this.testTX.commit();
        this.testTX = this.transactionService.getUserTransaction();
        this.testTX.begin();
        this.authenticationComponent.setSystemUserAsCurrentUser();
        for (i = 0; i < refs.length; ++i) {
            this.nodeService.deleteNode(refs[i]);
            this.testTX.commit();
            this.testTX = this.transactionService.getUserTransaction();
            this.testTX.begin();
        }
        List<Transaction> endTxns = this.nodeDAO.getTxnsByCommitTimeDescending(Long.MIN_VALUE, Long.MAX_VALUE, 20, null, false);
        AbstractReindexComponent.InIndex endAllPresent = this.indexRecoverer.areAllTxnsInEndSample(endTxns);
        FullIndexRecoveryComponentTest.assertEquals((Object)((Object)AbstractReindexComponent.InIndex.INDETERMINATE), (Object)((Object)endAllPresent));
        endTxns = this.nodeDAO.getTxnsByCommitTimeDescending(Long.MIN_VALUE, Long.MAX_VALUE, 21, null, false);
        endAllPresent = this.indexRecoverer.areAllTxnsInEndSample(endTxns);
        FullIndexRecoveryComponentTest.assertEquals((Object)((Object)AbstractReindexComponent.InIndex.INDETERMINATE), (Object)((Object)endAllPresent));
        endTxns = this.nodeDAO.getTxnsByCommitTimeDescending(Long.MIN_VALUE, Long.MAX_VALUE, 22, null, false);
        endAllPresent = this.indexRecoverer.areAllTxnsInEndSample(endTxns);
        FullIndexRecoveryComponentTest.assertEquals((Object)((Object)AbstractReindexComponent.InIndex.YES), (Object)((Object)endAllPresent));
    }

    public synchronized void testReindexing() throws Exception {
        this.indexRecoverer.setRecoveryMode(FullIndexRecoveryComponent.RecoveryMode.FULL.name());
        this.avmIndexRecoveryComponent.setRecoveryMode(FullIndexRecoveryComponent.RecoveryMode.FULL.name());
        Thread reindexThread = new Thread(){

            @Override
            public void run() {
                FullIndexRecoveryComponentTest.this.indexRecoverer.reindex();
            }
        };
        Thread avmReindexThread = new Thread(){

            @Override
            public void run() {
                FullIndexRecoveryComponentTest.this.avmIndexRecoveryComponent.reindex();
            }
        };
        reindexThread.start();
        avmReindexThread.start();
        reindexThread.join();
        avmReindexThread.join();
        ((Object)((Object)this)).wait(20000L);
        this.indexRecoverer.setShutdown(true);
        this.avmIndexRecoveryComponent.setShutdown(true);
        ((Object)((Object)this)).wait(20000L);
    }
}

