/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.index.IndexTransactionTracker;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class IndexTransactionTrackerTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private SearchService searchService;
    private NodeService nodeService;
    private ThreadPoolExecutor threadPoolExecutor;
    private FileFolderService fileFolderService;
    private ContentStore contentStore;
    private FullTextSearchIndexer ftsIndexer;
    private Indexer indexer;
    private NodeRef rootNodeRef;
    private IndexTransactionTracker indexTracker;

    public void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.searchService = (SearchService)ctx.getBean("searchService");
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        ChildApplicationContextFactory luceneSubSystem = (ChildApplicationContextFactory)ctx.getBean("lucene");
        this.threadPoolExecutor = (ThreadPoolExecutor)luceneSubSystem.getApplicationContext().getBean("search.indexTrackerThreadPoolExecutor");
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.contentStore = (ContentStore)ctx.getBean("fileContentStore");
        this.ftsIndexer = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        this.indexer = (Indexer)ctx.getBean("indexerComponent");
        NodeDAO nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        this.indexTracker = new IndexTransactionTracker();
        this.indexTracker.setAuthenticationComponent(this.authenticationComponent);
        this.indexTracker.setFtsIndexer(this.ftsIndexer);
        this.indexTracker.setIndexer(this.indexer);
        this.indexTracker.setNodeDAO(nodeDAO);
        this.indexTracker.setNodeService(this.nodeService);
        this.indexTracker.setThreadPoolExecutor(this.threadPoolExecutor);
        this.indexTracker.setSearcher(this.searchService);
        this.indexTracker.setTransactionService((TransactionServiceImpl)transactionService);
        this.indexTracker.setTenantService((TenantService)ctx.getBean("tenantService"));
        this.authenticationComponent.setSystemUserAsCurrentUser();
        RetryingTransactionHelper.RetryingTransactionCallback<ChildAssociationRef> createNodeWork = new RetryingTransactionHelper.RetryingTransactionCallback<ChildAssociationRef>(){

            @Override
            public ChildAssociationRef execute() throws Exception {
                StoreRef storeRef = new StoreRef("test", IndexTransactionTrackerTest.this.getName() + "-" + System.currentTimeMillis());
                NodeRef rootNodeRef = null;
                if (!IndexTransactionTrackerTest.this.nodeService.exists(storeRef)) {
                    IndexTransactionTrackerTest.this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
                }
                rootNodeRef = IndexTransactionTrackerTest.this.nodeService.getRootNode(storeRef);
                ChildAssociationRef childAssocRef = IndexTransactionTrackerTest.this.nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org", (String)"xyz"), ContentModel.TYPE_FOLDER);
                IndexTransactionTrackerTest.this.indexer.deleteNode(childAssocRef);
                return childAssocRef;
            }
        };
        ChildAssociationRef childAssocRef = transactionService.getRetryingTransactionHelper().doInTransaction(createNodeWork, false);
    }

    public void testSetup() throws Exception {
    }

    public synchronized void testStartup() throws Exception {
        Thread reindexThread = new Thread(){

            @Override
            public void run() {
                IndexTransactionTrackerTest.this.indexTracker.reindex();
                IndexTransactionTrackerTest.this.indexTracker.reindex();
            }
        };
        reindexThread.setDaemon(true);
        reindexThread.start();
        ((Object)((Object)this)).wait(20000L);
        this.indexTracker.setShutdown(true);
        ((Object)((Object)this)).wait(20000L);
    }
}

