/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.index;

import java.io.Serializable;
import java.util.concurrent.ThreadPoolExecutor;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.node.index.MissingContentReindexComponent;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.transaction.TransactionServiceImpl;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.springframework.context.ApplicationContext;

public class MissingContentReindexComponentTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private SearchService searchService;
    private NodeService nodeService;
    private ThreadPoolExecutor threadPoolExecutor;
    private FileFolderService fileFolderService;
    private ContentStore contentStore;
    private FullTextSearchIndexer ftsIndexer;
    private NodeRef rootNodeRef;
    private MissingContentReindexComponent reindexer;

    protected void setUp() throws Exception {
        ServiceRegistry serviceRegistry = (ServiceRegistry)ctx.getBean("ServiceRegistry");
        this.searchService = serviceRegistry.getSearchService();
        this.nodeService = serviceRegistry.getNodeService();
        ChildApplicationContextFactory luceneSubSystem = (ChildApplicationContextFactory)ctx.getBean("lucene");
        this.threadPoolExecutor = (ThreadPoolExecutor)luceneSubSystem.getApplicationContext().getBean("search.indexTrackerThreadPoolExecutor");
        this.fileFolderService = serviceRegistry.getFileFolderService();
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.contentStore = (ContentStore)ctx.getBean("fileContentStore");
        this.ftsIndexer = (FullTextSearchIndexer)ctx.getBean("LuceneFullTextSearchIndexer");
        Indexer indexer = (Indexer)ctx.getBean("indexerComponent");
        NodeDAO nodeDAO = (NodeDAO)ctx.getBean("nodeDAO");
        TransactionService transactionService = serviceRegistry.getTransactionService();
        this.reindexer = new MissingContentReindexComponent();
        this.reindexer.setAuthenticationComponent(this.authenticationComponent);
        this.reindexer.setFtsIndexer(this.ftsIndexer);
        this.reindexer.setIndexer(indexer);
        this.reindexer.setNodeDAO(nodeDAO);
        this.reindexer.setNodeService(this.nodeService);
        this.reindexer.setThreadPoolExecutor(this.threadPoolExecutor);
        this.reindexer.setSearcher(this.searchService);
        this.reindexer.setTransactionService((TransactionServiceImpl)transactionService);
        this.authenticationComponent.setSystemUserAsCurrentUser();
        StoreRef storeRef = this.nodeService.createStore("test", this.getName() + "-" + System.nanoTime());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.rootNodeRef = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"cm:x"), ContentModel.TYPE_FOLDER).getChildRef();
    }

    protected void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void testReindex() throws Exception {
        String contentUrl = "store://x/y/" + GUID.generate() + ".bin";
        ContentData contentData = new ContentData(contentUrl, "text/plain", 0L, "UTF8");
        NodeRef nodeRef = this.fileFolderService.create(this.rootNodeRef, "myfile", ContentModel.TYPE_CONTENT).getNodeRef();
        this.nodeService.setProperty(nodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
        this.ftsIndexer.index();
        ((Object)((Object)this)).wait(1000L);
        SearchParameters sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:nicm");
        sp.addSort(SearchParameters.SORT_IN_DOCUMENT_ORDER_DESCENDING);
        ResultSet results = null;
        try {
            results = this.searchService.query(sp);
            MissingContentReindexComponentTest.assertTrue((String)"Content missing NICM not found", (results.length() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
        ContentContext ctx = new ContentContext(null, contentUrl);
        ContentWriter writer = this.contentStore.getWriter(ctx);
        writer.setMimetype("text/plain");
        writer.setEncoding("UTF8");
        writer.putContent("123abc456def");
        this.reindexer.reindex();
        this.ftsIndexer.index();
        ((Object)((Object)this)).wait(1000L);
        sp = new SearchParameters();
        sp.addStore(this.rootNodeRef.getStoreRef());
        sp.setLanguage("lucene");
        sp.setQuery("TEXT:123abc456def");
        sp.addSort("@" + ContentModel.PROP_CREATED, false);
        results = null;
        try {
            results = this.searchService.query(sp);
            MissingContentReindexComponentTest.assertTrue((String)"Indexed content node found", (results.length() == 1 ? 1 : 0) != 0);
        }
        finally {
            if (results != null) {
                results.close();
            }
        }
    }
}

