/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.integrity;

import java.io.InputStream;
import java.util.Map;
import javax.transaction.UserTransaction;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.M2Model;
import org.alfresco.repo.node.BaseNodeServiceTest;
import org.alfresco.repo.node.integrity.IncompleteNodeTagger;
import org.alfresco.repo.node.integrity.IntegrityTest;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.lock.LockType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncompleteNodeTaggerTest
extends TestCase {
    private static Log logger = LogFactory.getLog(IncompleteNodeTaggerTest.class);
    private IncompleteNodeTagger tagger;
    private ServiceRegistry serviceRegistry;
    private NodeService nodeService;
    private NodeRef rootNodeRef;
    private PropertyMap properties;
    private UserTransaction txn;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private PermissionService permissionService;

    public void setUp() throws Exception {
        DictionaryDAO dictionaryDao = (DictionaryDAO)IntegrityTest.ctx.getBean("dictionaryDAO");
        ClassLoader cl = BaseNodeServiceTest.class.getClassLoader();
        InputStream modelStream = cl.getResourceAsStream("org/alfresco/repo/node/integrity/IntegrityTest_model.xml");
        IncompleteNodeTaggerTest.assertNotNull((Object)modelStream);
        M2Model model = M2Model.createModel((InputStream)modelStream);
        dictionaryDao.putModel(model);
        this.tagger = (IncompleteNodeTagger)IntegrityTest.ctx.getBean("incompleteNodeTagger");
        this.serviceRegistry = (ServiceRegistry)IntegrityTest.ctx.getBean("ServiceRegistry");
        this.nodeService = this.serviceRegistry.getNodeService();
        this.authenticationService = this.serviceRegistry.getAuthenticationService();
        this.permissionService = this.serviceRegistry.getPermissionService();
        this.authenticationComponent = (AuthenticationComponent)IntegrityTest.ctx.getBean("authenticationComponent");
        this.authenticationComponent.setSystemUserAsCurrentUser();
        String user = this.getName();
        if (!this.authenticationService.authenticationExists(user)) {
            this.authenticationService.createAuthentication(user, user.toCharArray());
        }
        TransactionService transactionService = this.serviceRegistry.getTransactionService();
        this.txn = transactionService.getUserTransaction();
        this.txn.begin();
        StoreRef storeRef = new StoreRef("workspace", this.getName());
        if (!this.nodeService.exists(storeRef)) {
            this.nodeService.createStore(storeRef.getProtocol(), storeRef.getIdentifier());
            this.rootNodeRef = this.nodeService.getRootNode(storeRef);
            this.permissionService.setPermission(this.rootNodeRef, user, "All", true);
        } else {
            this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        }
        this.properties = new PropertyMap();
        this.properties.put(IntegrityTest.TEST_PROP_TEXT_C, "abc");
        this.authenticationComponent.setCurrentUser(user);
    }

    public void tearDown() throws Exception {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.txn.rollback();
    }

    private NodeRef createNode(String name, QName type, PropertyMap properties) {
        return this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/test/IntegrityTest", (String)name), type, (Map)properties).getChildRef();
    }

    public void testSetUp() throws Exception {
        IncompleteNodeTaggerTest.assertNotNull((String)"IncompleteNodeTagger not created", (Object)this.tagger);
    }

    private void checkTagging(final NodeRef nodeRef, final boolean mustBeTagged) {
        this.tagger.beforeCommit(false);
        AuthenticationUtil.RunAsWork<Void> checkWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertEquals((boolean)IncompleteNodeTaggerTest.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE), (boolean)mustBeTagged);
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)checkWork, (String)AuthenticationUtil.getSystemUserName());
    }

    public void testCreateWithoutProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_PROPERTIES, null);
        this.checkTagging(nodeRef, true);
    }

    public void testCreateWithProperties() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_PROPERTIES, this.properties);
        this.checkTagging(nodeRef, false);
    }

    public void testCreateWithoutAssoc() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_NON_ENFORCED_CHILD_ASSOCS, this.properties);
        this.checkTagging(nodeRef, true);
    }

    public void testCreateWithAssoc() throws Exception {
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_NON_ENFORCED_CHILD_ASSOCS, this.properties);
        this.nodeService.createNode(nodeRef, IntegrityTest.TEST_ASSOC_CHILD_NON_ENFORCED, QName.createQName((String)"http://www.alfresco.org/test/IntegrityTest", (String)"easyas"), IntegrityTest.TEST_TYPE_WITHOUT_ANYTHING, null);
        this.checkTagging(nodeRef, false);
    }

    public void testIncompleteLockedNode() throws Exception {
        LockService lockService = this.serviceRegistry.getLockService();
        NodeRef nodeRef = this.createNode("abc", IntegrityTest.TEST_TYPE_WITH_PROPERTIES, null);
        this.checkTagging(nodeRef, true);
        this.nodeService.removeAspect(nodeRef, ContentModel.ASPECT_INCOMPLETE);
        lockService.lock(nodeRef, LockType.READ_ONLY_LOCK);
        String user = "someuser";
        AuthenticationUtil.RunAsWork<Void> createUserWork = new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!IncompleteNodeTaggerTest.this.authenticationService.authenticationExists("someuser")) {
                    IncompleteNodeTaggerTest.this.authenticationService.createAuthentication("someuser", "someuser".toCharArray());
                }
                return null;
            }
        };
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)createUserWork, (String)AuthenticationUtil.getSystemUserName());
        this.authenticationComponent.setCurrentUser("someuser");
        this.checkTagging(nodeRef, true);
    }
}

