/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.notification;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.admin.RepoAdminService;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.notification.NotificationContext;
import org.alfresco.service.cmr.notification.NotificationProvider;
import org.alfresco.service.cmr.notification.NotificationService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.util.ModelUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class EMailNotificationProvider
implements NotificationProvider {
    private static final String MSG_DEFAULT_SENDER_USED = "default-sender-used";
    private static final String MSG_NO_RECIPIENTS = "no-recipients";
    private static final String MSG_NO_BODY_OR_TEMPLATE = "no-body-or-template";
    private static Log logger = LogFactory.getLog(EMailNotificationProvider.class);
    public static final String NAME = "email";
    private NotificationService notificationService;
    private NodeService nodeService;
    private ActionService actionService;
    private PersonService personService;
    private Repository repository;
    private FileFolderService fileFolderService;
    private RepoAdminService repoAdminService;

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setRepoAdminService(RepoAdminService repoAdminService) {
        this.repoAdminService = repoAdminService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }

    public void init() {
        this.notificationService.register(this);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void sendNotification(NotificationContext notificationContext) {
        String body;
        List<String> to;
        Action mail = this.actionService.createAction("mail");
        String from = notificationContext.getFrom();
        if (from != null && from.length() != 0) {
            String fromEMail = this.getEMailFromUser(from);
            if (fromEMail != null) {
                mail.setParameterValue("from", (Serializable)((Object)fromEMail));
            } else if (logger.isWarnEnabled()) {
                logger.warn((Object)I18NUtil.getMessage((String)MSG_DEFAULT_SENDER_USED, (Object[])new Object[]{from}));
            }
        }
        if ((to = notificationContext.getTo()) == null || to.size() == 0) {
            this.errorEncountered(notificationContext, I18NUtil.getMessage((String)MSG_NO_RECIPIENTS, (Object[])new Object[]{notificationContext.getDocument()}));
            return;
        }
        mail.setParameterValue("to_many", (Serializable)((Object)to));
        String subject = notificationContext.getSubject();
        if (subject != null) {
            mail.setParameterValue("subject", (Serializable)((Object)subject));
        }
        if ((body = notificationContext.getBody()) != null && body.length() != 0) {
            mail.setParameterValue("text", (Serializable)((Object)body));
        } else {
            NodeRef template = notificationContext.getBodyTemplate();
            if (template == null) {
                this.errorEncountered(notificationContext, I18NUtil.getMessage((String)MSG_NO_BODY_OR_TEMPLATE, (Object[])new Object[]{notificationContext.getDocument()}));
                return;
            }
            template = this.fileFolderService.getLocalizedSibling(template);
            mail.setParameterValue("template", (Serializable)template);
            mail.setParameterValue("template_model", (Serializable)((Object)this.buildTemplateModel(notificationContext.getTemplateArgs())));
        }
        mail.setParameterValue("ignore_send_failure", Boolean.valueOf(notificationContext.isIgnoreNotificationFailure()));
        this.actionService.executeAction(mail, notificationContext.getDocument(), false, notificationContext.isAsyncNotification());
    }

    private String getEMailFromUser(String user) {
        String email = null;
        NodeRef person = this.personService.getPerson(user);
        if (person != null) {
            email = (String)((Object)this.nodeService.getProperty(person, ContentModel.PROP_EMAIL));
        }
        return email;
    }

    private Map<String, Serializable> buildTemplateModel(Map<String, Serializable> templateArgs) {
        HashMap<String, Serializable> model = new HashMap<String, Serializable>();
        model.put("companyhome", (Serializable)this.repository.getCompanyHome());
        NodeRef person = this.repository.getPerson();
        if (person != null) {
            model.put("person", (Serializable)person);
            model.put("userhome", (Serializable)this.repository.getUserHome(person));
        }
        model.put("productName", (Serializable)((Object)ModelUtil.getProductName(this.repoAdminService)));
        if (templateArgs != null && templateArgs.size() != 0) {
            model.put("args", (Serializable)((Object)templateArgs));
        }
        return model;
    }

    private void errorEncountered(NotificationContext notificationContext, String message) {
        if (logger.isWarnEnabled()) {
            logger.warn((Object)message);
        }
        if (!notificationContext.isIgnoreNotificationFailure()) {
            throw new AlfrescoRuntimeException(message);
        }
    }
}

