/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.ownable.impl;

import java.io.Serializable;
import java.util.HashMap;
import javax.transaction.UserTransaction;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.MutableAuthenticationDao;
import org.alfresco.repo.security.permissions.dynamic.OwnerDynamicAuthority;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.OwnableService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.springframework.context.ApplicationContext;

public class OwnableServiceTest
extends TestCase {
    private static ApplicationContext ctx = ApplicationContextHelper.getApplicationContext();
    private NodeService nodeService;
    private MutableAuthenticationService authenticationService;
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationDao authenticationDAO;
    private OwnableService ownableService;
    private NodeRef rootNodeRef;
    private UserTransaction txn;
    private PermissionService permissionService;
    private OwnerDynamicAuthority dynamicAuthority;

    public OwnableServiceTest() {
    }

    public OwnableServiceTest(String arg0) {
        super(arg0);
    }

    public void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        this.nodeService = (NodeService)ctx.getBean("nodeService");
        this.authenticationService = (MutableAuthenticationService)ctx.getBean("authenticationService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.ownableService = (OwnableService)ctx.getBean("ownableService");
        this.permissionService = (PermissionService)ctx.getBean("permissionService");
        this.authenticationComponent.setCurrentUser(this.authenticationComponent.getSystemUserName());
        this.authenticationDAO = (MutableAuthenticationDao)ctx.getBean("authenticationDao");
        TransactionService transactionService = (TransactionService)ctx.getBean(ServiceRegistry.TRANSACTION_SERVICE.getLocalName());
        this.txn = transactionService.getUserTransaction();
        this.txn.begin();
        StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
        this.rootNodeRef = this.nodeService.getRootNode(storeRef);
        this.permissionService.setPermission(this.rootNodeRef, "GROUP_EVERYONE", "AddChildren", true);
        if (this.authenticationDAO.userExists("andy")) {
            this.authenticationService.deleteAuthentication("andy");
        }
        this.authenticationService.createAuthentication("andy", "andy".toCharArray());
        this.dynamicAuthority = new OwnerDynamicAuthority();
        this.dynamicAuthority.setOwnableService(this.ownableService);
        this.authenticationComponent.clearCurrentSecurityContext();
    }

    protected void tearDown() throws Exception {
        try {
            this.authenticationComponent.clearCurrentSecurityContext();
            this.txn.rollback();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.tearDown();
    }

    public void testSetup() {
        OwnableServiceTest.assertNotNull((Object)this.nodeService);
        OwnableServiceTest.assertNotNull((Object)this.authenticationService);
        OwnableServiceTest.assertNotNull((Object)this.ownableService);
    }

    public void testUnSet() {
        OwnableServiceTest.assertNull((Object)this.ownableService.getOwner(this.rootNodeRef));
        OwnableServiceTest.assertFalse((boolean)this.ownableService.hasOwner(this.rootNodeRef));
    }

    public void testCMObject() {
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        NodeRef testNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_PERSON, ContentModel.TYPE_CMOBJECT, null).getChildRef();
        this.permissionService.setPermission(this.rootNodeRef, "andy", "TakeOwnership", true);
        OwnableServiceTest.assertEquals((String)"andy", (String)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertTrue((boolean)this.ownableService.hasOwner(testNode));
        OwnableServiceTest.assertTrue((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_AUDITABLE));
        OwnableServiceTest.assertFalse((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_OWNABLE));
        OwnableServiceTest.assertTrue((boolean)this.dynamicAuthority.hasAuthority(testNode, "andy"));
        OwnableServiceTest.assertEquals((String)"andy", (String)this.ownableService.getOwner(testNode));
        this.permissionService.setInheritParentPermissions(testNode, false);
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "SetOwner"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "SetOwner"));
        this.permissionService.setPermission(this.rootNodeRef, "andy", "WriteProperties", true);
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "SetOwner"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "SetOwner"));
        this.ownableService.setOwner(testNode, "woof");
        OwnableServiceTest.assertEquals((String)"woof", (String)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertTrue((boolean)this.dynamicAuthority.hasAuthority(testNode, "woof"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(testNode, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(testNode, "SetOwner"));
        this.ownableService.setOwner(testNode, "muppet");
        OwnableServiceTest.assertEquals((String)"muppet", (String)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertTrue((boolean)this.dynamicAuthority.hasAuthority(testNode, "muppet"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(testNode, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.DENIED, (Object)this.permissionService.hasPermission(testNode, "SetOwner"));
        this.ownableService.takeOwnership(testNode);
        OwnableServiceTest.assertEquals((String)"andy", (String)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertTrue((boolean)this.dynamicAuthority.hasAuthority(testNode, "andy"));
        OwnableServiceTest.assertTrue((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_AUDITABLE));
        OwnableServiceTest.assertTrue((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_OWNABLE));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(this.rootNodeRef, "SetOwner"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "TakeOwnership"));
        OwnableServiceTest.assertEquals((Object)AccessStatus.ALLOWED, (Object)this.permissionService.hasPermission(testNode, "SetOwner"));
        this.nodeService.setProperty(testNode, ContentModel.PROP_OWNER, (Serializable)((Object)"muppet"));
        OwnableServiceTest.assertEquals((String)"muppet", (String)this.ownableService.getOwner(testNode));
        this.nodeService.removeAspect(testNode, ContentModel.ASPECT_OWNABLE);
        OwnableServiceTest.assertEquals((String)"andy", (String)this.ownableService.getOwner(testNode));
        HashMap<QName, String> aspectProperties = new HashMap<QName, String>();
        aspectProperties.put(ContentModel.PROP_OWNER, "muppet");
        this.nodeService.addAspect(testNode, ContentModel.ASPECT_OWNABLE, aspectProperties);
        OwnableServiceTest.assertEquals((String)"muppet", (String)this.ownableService.getOwner(testNode));
    }

    public void testContainer() {
        this.authenticationService.authenticate("andy", "andy".toCharArray());
        NodeRef testNode = this.nodeService.createNode(this.rootNodeRef, ContentModel.ASSOC_CHILDREN, ContentModel.TYPE_PERSON, ContentModel.TYPE_CONTAINER, null).getChildRef();
        OwnableServiceTest.assertNull((Object)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertFalse((boolean)this.ownableService.hasOwner(testNode));
        OwnableServiceTest.assertFalse((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_AUDITABLE));
        OwnableServiceTest.assertFalse((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_OWNABLE));
        OwnableServiceTest.assertFalse((boolean)this.dynamicAuthority.hasAuthority(testNode, "andy"));
        OwnableServiceTest.assertFalse((this.permissionService.hasPermission(testNode, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        OwnableServiceTest.assertFalse((this.permissionService.hasPermission(testNode, this.permissionService.getAllPermission()) == AccessStatus.ALLOWED ? 1 : 0) != 0);
        this.permissionService.setPermission(this.rootNodeRef, this.permissionService.getOwnerAuthority(), this.permissionService.getAllPermission(), true);
        this.ownableService.setOwner(testNode, "muppet");
        OwnableServiceTest.assertEquals((String)"muppet", (String)this.ownableService.getOwner(testNode));
        this.ownableService.takeOwnership(testNode);
        OwnableServiceTest.assertEquals((String)"andy", (String)this.ownableService.getOwner(testNode));
        OwnableServiceTest.assertFalse((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_AUDITABLE));
        OwnableServiceTest.assertTrue((boolean)this.nodeService.hasAspect(testNode, ContentModel.ASPECT_OWNABLE));
        OwnableServiceTest.assertTrue((boolean)this.dynamicAuthority.hasAuthority(testNode, "andy"));
        OwnableServiceTest.assertTrue((this.permissionService.hasPermission(testNode, "Read") == AccessStatus.ALLOWED ? 1 : 0) != 0);
        OwnableServiceTest.assertTrue((this.permissionService.hasPermission(testNode, this.permissionService.getAllPermission()) == AccessStatus.ALLOWED ? 1 : 0) != 0);
    }
}

