/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourDefinition;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.PolicyList;
import org.alfresco.repo.policy.TransactionInvocationHandlerFactory;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;

class PolicyFactory<B extends BehaviourBinding, P extends Policy> {
    private BehaviourIndex<B> index;
    private Class<P> policyClass;
    private static InvocationHandler NOOPHandler = new NOOPHandler();
    private static TransactionInvocationHandlerFactory transactionHandlerFactory = null;
    private static TenantService tenantService = null;

    PolicyFactory(Class<P> policyClass, BehaviourIndex<B> index) {
        this.policyClass = policyClass;
        this.index = index;
    }

    protected static void setTransactionInvocationHandlerFactory(TransactionInvocationHandlerFactory factory) {
        transactionHandlerFactory = factory;
    }

    protected static void setTenantService(TenantService service) {
        tenantService = service;
    }

    protected Class<P> getPolicyClass() {
        return this.policyClass;
    }

    public P create(B binding) {
        Collection<P> policyInterfaces = this.createList(binding);
        return this.toPolicy(policyInterfaces);
    }

    public Collection<P> createList(B binding) {
        Collection<BehaviourDefinition> behaviourDefs = this.index.find(binding);
        ArrayList<Policy> policyInterfaces = new ArrayList<Policy>(behaviourDefs.size());
        for (BehaviourDefinition behaviourDef : behaviourDefs) {
            Behaviour behaviour = behaviourDef.getBehaviour();
            Policy policyIF = (Policy)behaviour.getInterface(this.policyClass);
            if (!behaviour.getNotificationFrequency().equals((Object)Behaviour.NotificationFrequency.EVERY_EVENT)) {
                if (transactionHandlerFactory == null) {
                    throw new PolicyException("Transaction-level policies not supported as transaction support for the Policy Component has not been initialised.");
                }
                InvocationHandler trxHandler = transactionHandlerFactory.createHandler(behaviour, behaviourDef.getPolicyDefinition(), policyIF);
                policyIF = (Policy)Proxy.newProxyInstance(this.policyClass.getClassLoader(), new Class[]{this.policyClass}, trxHandler);
            }
            policyInterfaces.add(policyIF);
        }
        return policyInterfaces;
    }

    public P toPolicy(Collection<P> policyList) {
        if (policyList.size() == 1) {
            return (P)((Policy)policyList.iterator().next());
        }
        if (policyList.size() == 0) {
            return (P)((Policy)Proxy.newProxyInstance(this.policyClass.getClassLoader(), new Class[]{this.policyClass}, NOOPHandler));
        }
        return (P)((Policy)Proxy.newProxyInstance(this.policyClass.getClassLoader(), new Class[]{this.policyClass, PolicyList.class}, new MultiHandler<P>(policyList)));
    }

    private static class MultiHandler<P extends Policy>
    implements InvocationHandler,
    PolicyList {
        private Collection<P> policyInterfaces;

        public MultiHandler(Collection<P> policyInterfaces) {
            this.policyInterfaces = Collections.unmodifiableCollection(policyInterfaces);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (tenantService != null && tenantService.isEnabled() && args != null) {
                for (int i = 0; i < args.length; ++i) {
                    StoreRef ref;
                    Object arg;
                    Object newArg = arg = args[i];
                    if (arg == null) {
                        // empty if block
                    }
                    if (arg instanceof StoreRef) {
                        ref = (StoreRef)arg;
                        newArg = tenantService.getBaseName(ref);
                    } else if (arg instanceof NodeRef) {
                        ref = (NodeRef)arg;
                        newArg = tenantService.getBaseName((NodeRef)ref);
                    } else if (arg instanceof ChildAssociationRef) {
                        ref = (ChildAssociationRef)arg;
                        newArg = tenantService.getBaseName((ChildAssociationRef)ref);
                    } else if (arg instanceof AssociationRef) {
                        ref = (AssociationRef)arg;
                        newArg = tenantService.getBaseName((AssociationRef)ref);
                    }
                    args[i] = newArg;
                }
            }
            if (method.getDeclaringClass().equals(PolicyList.class)) {
                return method.invoke((Object)this, args);
            }
            if (method.getName().equals("toString")) {
                return this.toString() + ": wrapped " + this.policyInterfaces.size() + " policies";
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.equals(args[0]);
            }
            try {
                Object result = null;
                for (Policy policyInterface : this.policyInterfaces) {
                    result = method.invoke((Object)policyInterface, args);
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        public Collection getPolicies() {
            return this.policyInterfaces;
        }
    }

    private static class NOOPHandler
    implements InvocationHandler {
        private NOOPHandler() {
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.equals(args[0]);
            }
            return null;
        }
    }
}

