/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyDefinition;
import org.alfresco.repo.policy.PolicyException;
import org.alfresco.repo.policy.TransactionBehaviourQueue;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;

public class TransactionInvocationHandlerFactory {
    private static final String EXECUTED_KEY = TransactionHandler.class.getName() + ".executed";
    private TransactionBehaviourQueue queue;

    public TransactionInvocationHandlerFactory(TransactionBehaviourQueue queue) {
        this.queue = queue;
    }

    public <P extends Policy> InvocationHandler createHandler(Behaviour behaviour, PolicyDefinition<P> definition, P policyInterface) {
        return new TransactionHandler(this, behaviour, definition, policyInterface);
    }

    private class ExecutionInstanceKey {
        Behaviour behaviour;
        ArrayList<Object> keys = new ArrayList();

        public ExecutionInstanceKey(Behaviour behaviour, Policy.Arg[] argDefs, Object[] args) {
            this.behaviour = behaviour;
            for (int i = 0; i < argDefs.length; ++i) {
                if (!argDefs[i].equals((Object)Policy.Arg.KEY)) continue;
                this.keys.add(args[i]);
            }
        }

        public int hashCode() {
            int key = this.behaviour.hashCode();
            for (int i = 0; i < this.keys.size(); ++i) {
                key = 37 * key + this.keys.get(i).hashCode();
            }
            return key;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof ExecutionInstanceKey) {
                ExecutionInstanceKey that = (ExecutionInstanceKey)obj;
                if (this.behaviour.equals(that.behaviour)) {
                    if (this.keys.size() != that.keys.size()) {
                        return false;
                    }
                    if (this.keys.containsAll(that.keys)) {
                        return true;
                    }
                }
                return false;
            }
            return false;
        }
    }

    private static class TransactionHandler<P extends Policy>
    implements InvocationHandler {
        private Behaviour behaviour;
        private PolicyDefinition<P> definition;
        private P policyInterface;
        final /* synthetic */ TransactionInvocationHandlerFactory this$0;

        public TransactionHandler(Behaviour behaviour, PolicyDefinition<P> definition, P policyInterface) {
            this.this$0 = var1_1;
            this.behaviour = behaviour;
            this.definition = definition;
            this.policyInterface = policyInterface;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("toString")) {
                return this.policyInterface.toString();
            }
            if (method.getName().equals("hashCode")) {
                return this.policyInterface.hashCode();
            }
            if (method.getName().equals("equals")) {
                return this.policyInterface.equals(args[0]);
            }
            Object result = null;
            if (this.behaviour.getNotificationFrequency().equals((Object)Behaviour.NotificationFrequency.FIRST_EVENT)) {
                ExecutionInstanceKey key;
                HashMap<ExecutionInstanceKey, Object> executedBehaviours = (HashMap<ExecutionInstanceKey, Object>)AlfrescoTransactionSupport.getResource(EXECUTED_KEY);
                if (executedBehaviours == null) {
                    executedBehaviours = new HashMap<ExecutionInstanceKey, Object>();
                    AlfrescoTransactionSupport.bindResource(EXECUTED_KEY, executedBehaviours);
                }
                if (!executedBehaviours.containsKey(key = this.this$0.new ExecutionInstanceKey(this.behaviour, this.definition.getArguments(), args))) {
                    try {
                        result = method.invoke(this.policyInterface, args);
                        executedBehaviours.put(key, result);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                } else {
                    result = executedBehaviours.get(key);
                }
            } else if (this.behaviour.getNotificationFrequency().equals((Object)Behaviour.NotificationFrequency.TRANSACTION_COMMIT)) {
                this.this$0.queue.queue(this.behaviour, this.definition, this.policyInterface, method, args);
            } else {
                throw new PolicyException("Invalid Notification frequency " + (Object)((Object)this.behaviour.getNotificationFrequency()));
            }
            return result;
        }
    }
}

