/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.processor;

import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.SysAdminParams;
import org.alfresco.repo.jscript.ScriptUrls;
import org.alfresco.scripts.ScriptException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptLocation;
import org.alfresco.service.cmr.repository.ScriptProcessor;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ScriptServiceImpl
implements ScriptService {
    private static final Log logger = LogFactory.getLog(ScriptServiceImpl.class);
    private String defaultScriptProcessor;
    private Map<String, ScriptProcessor> scriptProcessors = new HashMap<String, ScriptProcessor>(8);
    private Map<String, String> scriptProcessorNamesByExtension = new HashMap<String, String>(8);
    private NodeService nodeService;
    private SysAdminParams sysAdminParams;

    public void setDefaultScriptProcessor(String defaultScriptProcessor) {
        this.defaultScriptProcessor = defaultScriptProcessor;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setSysAdminParams(SysAdminParams sysAdminParams) {
        this.sysAdminParams = sysAdminParams;
    }

    @Override
    public void registerScriptProcessor(ScriptProcessor scriptProcessor) {
        this.scriptProcessors.put(scriptProcessor.getName(), scriptProcessor);
        this.scriptProcessorNamesByExtension.put(scriptProcessor.getExtension(), scriptProcessor.getName());
    }

    @Override
    public void resetScriptProcessors() {
        for (ScriptProcessor p : this.scriptProcessors.values()) {
            p.reset();
        }
    }

    @Override
    public Object executeScript(String scriptClasspath, Map<String, Object> model) throws ScriptException {
        ParameterCheck.mandatory((String)"scriptClasspath", (Object)scriptClasspath);
        ScriptProcessor scriptProcessor = this.getScriptProcessor(scriptClasspath);
        return this.execute(scriptProcessor, scriptClasspath, model);
    }

    @Override
    public Object executeScript(String engine, String scriptClasspath, Map<String, Object> model) throws ScriptException {
        ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
        return this.execute(scriptProcessor, scriptClasspath, model);
    }

    @Override
    public Object executeScript(NodeRef scriptRef, QName contentProp, Map<String, Object> model) throws ScriptException {
        ParameterCheck.mandatory((String)"scriptRef", (Object)scriptRef);
        ScriptProcessor scriptProcessor = this.getScriptProcessor(scriptRef);
        return this.execute(scriptProcessor, scriptRef, contentProp, model);
    }

    @Override
    public Object executeScript(String engine, NodeRef scriptRef, QName contentProp, Map<String, Object> model) throws ScriptException {
        ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
        return this.execute(scriptProcessor, scriptRef, contentProp, model);
    }

    @Override
    public Object executeScript(ScriptLocation location, Map<String, Object> model) throws ScriptException {
        ParameterCheck.mandatory((String)"location", (Object)location);
        ScriptProcessor scriptProcessor = this.getScriptProcessor(location.toString());
        return this.execute(scriptProcessor, location, model);
    }

    @Override
    public Object executeScript(String engine, ScriptLocation location, Map<String, Object> model) throws ScriptException {
        ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
        return this.execute(scriptProcessor, location, model);
    }

    @Override
    public Object executeScriptString(String script, Map<String, Object> model) throws ScriptException {
        return this.executeScriptString(this.defaultScriptProcessor, script, model);
    }

    @Override
    public Object executeScriptString(String engine, String script, Map<String, Object> model) throws ScriptException {
        ScriptProcessor scriptProcessor = this.lookupScriptProcessor(engine);
        return this.executeString(scriptProcessor, script, model);
    }

    protected Object execute(ScriptProcessor processor, ScriptLocation location, Map<String, Object> model) {
        ParameterCheck.mandatory((String)"location", (Object)location);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script:\n" + location));
        }
        try {
            return processor.execute(location, model);
        }
        catch (Throwable err) {
            throw this.translateProcessingException(location.toString(), err);
        }
    }

    protected Object execute(ScriptProcessor processor, NodeRef scriptRef, QName contentProp, Map<String, Object> model) {
        ParameterCheck.mandatory((String)"scriptRef", (Object)scriptRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script:\n" + scriptRef));
        }
        try {
            return processor.execute(scriptRef, contentProp, model);
        }
        catch (Throwable err) {
            throw this.translateProcessingException(scriptRef.toString(), err);
        }
    }

    protected Object execute(ScriptProcessor processor, String location, Map<String, Object> model) {
        ParameterCheck.mandatoryString((String)"location", (String)location);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script:\n" + location));
        }
        try {
            return processor.execute(location, model);
        }
        catch (Throwable err) {
            throw this.translateProcessingException(location, err);
        }
    }

    protected Object executeString(ScriptProcessor processor, String script, Map<String, Object> model) {
        ParameterCheck.mandatoryString((String)"script", (String)script);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing script:\n" + script));
        }
        try {
            return processor.executeString(script, model);
        }
        catch (Throwable err) {
            throw this.translateProcessingException("provided by caller", err);
        }
    }

    protected ScriptException translateProcessingException(String scriptInfo, Throwable err) {
        ScriptException result = null;
        String msg = "Failed to execute script " + (scriptInfo == null ? "" : scriptInfo);
        if (logger.isWarnEnabled()) {
            logger.warn((Object)msg, err);
        }
        result = ScriptException.class.isAssignableFrom(err.getClass()) ? (ScriptException)err : new ScriptException(msg, err);
        return result;
    }

    protected ScriptProcessor lookupScriptProcessor(String name) {
        ScriptProcessor scriptProcessor;
        ScriptProcessor scriptProcessor2 = scriptProcessor = name == null ? null : this.scriptProcessors.get(name);
        if (scriptProcessor == null) {
            scriptProcessor = this.scriptProcessors.get(this.defaultScriptProcessor);
        }
        return scriptProcessor;
    }

    protected ScriptProcessor getScriptProcessor(NodeRef scriptNode) {
        String scriptName = (String)((Object)this.nodeService.getProperty(scriptNode, ContentModel.PROP_NAME));
        return this.getScriptProcessorImpl(scriptName);
    }

    protected ScriptProcessor getScriptProcessor(String scriptLocation) {
        if (scriptLocation.indexOf("://") != -1) {
            NodeRef nodeRef = new NodeRef(scriptLocation);
            scriptLocation = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_NAME));
        }
        return this.getScriptProcessorImpl(scriptLocation);
    }

    protected ScriptProcessor getScriptProcessorImpl(String scriptFileName) {
        String extension;
        String engine = null;
        if (scriptFileName != null && (extension = this.getFileExtension(scriptFileName)) != null) {
            engine = this.scriptProcessorNamesByExtension.get(extension);
        }
        return this.lookupScriptProcessor(engine);
    }

    private String getFileExtension(String fileName) {
        String extension = null;
        int index = fileName.lastIndexOf(46);
        if (index > -1 && index < fileName.length() - 1) {
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    @Override
    public void buildCoreModel(Map<String, Object> inputMap) {
        ParameterCheck.mandatory((String)"InputMap", inputMap);
        inputMap.put("urls", new ScriptUrls(this.sysAdminParams));
    }

    @Override
    public Map<String, Object> buildDefaultModel(NodeRef person, NodeRef companyHome, NodeRef userHome, NodeRef script, NodeRef document, NodeRef space) {
        HashMap<String, Object> model = new HashMap<String, Object>();
        this.buildCoreModel(model);
        model.put("companyhome", companyHome);
        if (userHome != null) {
            model.put("userhome", userHome);
        }
        if (person != null) {
            model.put("person", person);
        }
        if (script != null) {
            model.put("script", script);
        }
        if (document != null) {
            model.put("document", document);
        }
        if (space != null) {
            model.put("space", space);
        }
        return model;
    }
}

