/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.publishing.PublishingEventFilterImpl;
import org.alfresco.repo.publishing.PublishingEventHelper;
import org.alfresco.repo.publishing.StatusUpdateImpl;
import org.alfresco.service.cmr.publishing.PublishingDetails;
import org.alfresco.service.cmr.publishing.PublishingEvent;
import org.alfresco.service.cmr.publishing.PublishingEventFilter;
import org.alfresco.service.cmr.publishing.PublishingQueue;
import org.alfresco.service.cmr.publishing.StatusUpdate;
import org.alfresco.service.cmr.repository.NodeRef;

public class PublishingQueueImpl
implements PublishingQueue {
    private static final String MSG_FAILED_TO_CREATE_PUBLISHING_EVENT = "publishing-create-event-failed";
    private final NodeRef nodeRef;
    private final PublishingEventHelper publishingEventHelper;

    public PublishingQueueImpl(NodeRef nodeRef, PublishingEventHelper publishingEventHelper) {
        this.nodeRef = nodeRef;
        this.publishingEventHelper = publishingEventHelper;
    }

    @Override
    public PublishingDetails createPublishingDetails() {
        return this.publishingEventHelper.createPublishingDetails();
    }

    public StatusUpdate createStatusUpdate(String message, NodeRef nodeToLinkTo, String ... channelNames) {
        return this.createStatusUpdate(message, nodeToLinkTo, Arrays.asList(channelNames));
    }

    public StatusUpdate createStatusUpdate(String message, NodeRef nodeToLinkTo, Collection<String> channelNames) {
        return new StatusUpdateImpl(message, nodeToLinkTo, channelNames);
    }

    public List<PublishingEvent> getPublishingEvents(PublishingEventFilter filter) {
        return this.publishingEventHelper.findPublishingEvents(this.nodeRef, filter);
    }

    public PublishingEventFilter createPublishingEventFilter() {
        return new PublishingEventFilterImpl();
    }

    @Override
    public String scheduleNewEvent(PublishingDetails publishingDetails) {
        try {
            NodeRef eventNode = this.publishingEventHelper.createNode(this.nodeRef, publishingDetails);
            this.publishingEventHelper.startPublishingWorkflow(eventNode, publishingDetails.getSchedule());
            return eventNode.toString();
        }
        catch (Exception ex) {
            throw new AlfrescoRuntimeException(MSG_FAILED_TO_CREATE_PUBLISHING_EVENT, (Throwable)ex);
        }
    }

    public NodeRef getNodeRef() {
        return this.nodeRef;
    }
}

