/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.flickr;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.publishing.Environment;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingQueueImpl;
import org.alfresco.repo.publishing.flickr.FlickrChannelType;
import org.alfresco.repo.publishing.flickr.FlickrPublishingModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.BaseSpringTest;
import org.alfresco.util.GUID;
import org.junit.Assert;
import org.springframework.core.io.ClassPathResource;

public class FlickrTest
extends BaseSpringTest {
    protected ServiceRegistry serviceRegistry;
    protected SiteService siteService;
    protected FileFolderService fileFolderService;
    protected NodeService nodeService;
    protected String siteId;
    protected PublishingQueueImpl queue;
    protected Environment environment;
    protected NodeRef docLib;
    private ChannelService channelService;
    private RetryingTransactionHelper transactionHelper;

    public void onSetUp() throws Exception {
        this.serviceRegistry = (ServiceRegistry)this.getApplicationContext().getBean("ServiceRegistry");
        this.channelService = (ChannelService)this.getApplicationContext().getBean("channelService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
        this.siteService = this.serviceRegistry.getSiteService();
        this.fileFolderService = this.serviceRegistry.getFileFolderService();
        this.nodeService = this.serviceRegistry.getNodeService();
        this.transactionHelper = this.serviceRegistry.getRetryingTransactionHelper();
        this.siteId = GUID.generate();
        this.siteService.createSite("test", this.siteId, "Site created by publishing test", "Site created by publishing test", SiteVisibility.PUBLIC);
        this.docLib = this.siteService.createContainer(this.siteId, "documentLibrary", ContentModel.TYPE_FOLDER, null);
    }

    public void onTearDown() {
        this.siteService.deleteSite(this.siteId);
    }

    public void testBlank() {
    }

    public void xtestFlickrPublishAndUnpublishActions() throws Exception {
        final String channelName = "FlickrTestChannel_" + GUID.generate();
        final FlickrChannelType channelType = (FlickrChannelType)this.channelService.getChannelType("flickr");
        final NodeRef contentNode = this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                HashMap<QName, Serializable> props = new HashMap<QName, Serializable>();
                props.put(PublishingModel.PROP_OAUTH1_TOKEN_VALUE, (Serializable)((Object)"YOUR_OAUTH_TOKEN_VALUE"));
                props.put(PublishingModel.PROP_OAUTH1_TOKEN_SECRET, (Serializable)((Object)"YOUR_OAUTH_TOKEN_SECRET"));
                props.put(PublishingModel.PROP_AUTHORISATION_COMPLETE, Boolean.TRUE);
                Channel channel = FlickrTest.this.channelService.createChannel("flickr", channelName, props);
                FlickrTest.this.channelService.updateChannel(channel, props);
                NodeRef channelNode = channel.getNodeRef();
                ClassPathResource file = new ClassPathResource("test/alfresco/TestImageFile.png");
                HashMap<QName, String> contentProps = new HashMap<QName, String>();
                contentProps.put(ContentModel.PROP_NAME, "Test Image");
                NodeRef contentNode = FlickrTest.this.nodeService.createNode(channelNode, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"testImage"), ContentModel.TYPE_CONTENT, contentProps).getChildRef();
                ContentService contentService = FlickrTest.this.serviceRegistry.getContentService();
                ContentWriter writer = contentService.getWriter(contentNode, ContentModel.PROP_CONTENT, true);
                writer.setMimetype("image/png");
                writer.putContent(file.getFile());
                return contentNode;
            }
        });
        this.transactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Channel channel = FlickrTest.this.channelService.getChannelByName(channelName);
                channelType.publish(contentNode, channel.getProperties());
                Map props = FlickrTest.this.nodeService.getProperties(contentNode);
                Assert.assertTrue((boolean)FlickrTest.this.nodeService.hasAspect(contentNode, FlickrPublishingModel.ASPECT_ASSET));
                Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_ID));
                Assert.assertNotNull(props.get(PublishingModel.PROP_ASSET_URL));
                System.out.println("Asset id: " + props.get(PublishingModel.PROP_ASSET_ID));
                System.out.println("Asset URL: " + props.get(PublishingModel.PROP_ASSET_URL));
                channelType.unpublish(contentNode, channel.getProperties());
                props = FlickrTest.this.nodeService.getProperties(contentNode);
                Assert.assertFalse((boolean)FlickrTest.this.nodeService.hasAspect(contentNode, FlickrPublishingModel.ASPECT_ASSET));
                Assert.assertFalse((boolean)FlickrTest.this.nodeService.hasAspect(contentNode, PublishingModel.ASPECT_ASSET));
                Assert.assertNull(props.get(PublishingModel.PROP_ASSET_ID));
                Assert.assertNull(props.get(PublishingModel.PROP_ASSET_URL));
                return null;
            }
        });
    }
}

