/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing.slideshare;

import com.benfante.jslideshare.DocumentParser;
import com.benfante.jslideshare.DocumentParserResult;
import com.benfante.jslideshare.SlideShareConnector;
import com.benfante.jslideshare.SlideShareErrorException;
import com.benfante.jslideshare.SlideShareException;
import com.benfante.jslideshare.messages.Group;
import com.benfante.jslideshare.messages.Slideshow;
import com.benfante.jslideshare.messages.SlideshowInfo;
import com.benfante.jslideshare.messages.Tag;
import com.benfante.jslideshare.messages.User;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.repo.publishing.slideshare.SlideShareApi;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SlideShareApiImpl
implements SlideShareApi {
    private static final Log logger = LogFactory.getLog(SlideShareApiImpl.class);
    public static final String URL_GET_SLIDESHOW = "URL_GET_SLIDESHOW";
    public static final String URL_GET_SLIDESHOW_INFO = "URL_GET_SLIDESHOW_INFO";
    public static final String URL_GET_SLIDESHOW_BY_USER = "URL_GET_SLIDESHOW_BY_USER";
    public static final String URL_GET_SLIDESHOW_BY_TAG = "URL_GET_SLIDESHOW_BY_TAG";
    public static final String URL_GET_SLIDESHOW_BY_GROUP = "URL_GET_SLIDESHOW_BY_GROUP";
    public static final String URL_UPLOAD_SLIDESHOW = "URL_UPLOAD_SLIDESHOW";
    public static final String URL_DELETE_SLIDESHOW = "URL_DELETE_SLIDESHOW";
    private static Map<String, String> DEFAULT_API_URLS = new TreeMap<String, String>();
    private Map<String, String> apiUrls = new TreeMap<String, String>(DEFAULT_API_URLS);
    protected SlideShareConnector connector;
    private String username;
    private String password;

    public SlideShareApiImpl() {
    }

    public SlideShareApiImpl(SlideShareConnector connector) {
        this.connector = connector;
    }

    public SlideShareConnector getConnector() {
        return this.connector;
    }

    public void setConnector(SlideShareConnector connector) {
        this.connector = connector;
    }

    public void setApiUrls(Map<String, String> urls) {
        if (urls == null || !urls.keySet().containsAll(DEFAULT_API_URLS.keySet())) {
            throw new IllegalArgumentException("Specified URL set is missing one or more values. Expected " + DEFAULT_API_URLS.keySet() + "; Received " + (urls == null ? urls : urls.keySet()));
        }
    }

    public Slideshow getSlideshow(String id) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshow with id=" + id));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "slideshow_id", id);
        return this.sendMessage(URL_GET_SLIDESHOW, parameters).getSlideShow();
    }

    public SlideshowInfo getSlideshowInfo(String id, String url) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowInfo with id=" + id + ", url=" + url));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "slideshow_id", id);
        this.addParameter(parameters, "slideshow_url", url);
        return this.sendGetMessage(URL_GET_SLIDESHOW_INFO, parameters).getSlideShowInfo();
    }

    public User getSlideshowByUser(String username) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByUser with username=" + username));
        return this.getSlideshowByUser(username, -1, -1);
    }

    public User getSlideshowByUser(String username, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByUser with username=" + username + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "username_for", username);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_USER, parameters).getUser();
    }

    public Tag getSlideshowByTag(String tag) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByTag with tag=" + tag));
        return this.getSlideshowByTag(tag, -1, -1);
    }

    public Tag getSlideshowByTag(String tag, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByTag with tag=" + tag + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "tag", tag);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_TAG, parameters).getTag();
    }

    public Group getSlideshowByGroup(String groupName) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByGroup with groupName=" + groupName));
        return this.getSlideshowByGroup(groupName, -1, -1);
    }

    public Group getSlideshowByGroup(String groupName, int offset, int limit) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called getSlideshowByGrop with groupName=" + groupName + ", offset=" + offset + ", limit=" + limit));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "group_name", groupName);
        this.addLimits(parameters, offset, limit);
        return this.sendMessage(URL_GET_SLIDESHOW_BY_GROUP, parameters).getGroup();
    }

    public String uploadSlideshow(String username, String password, String title, File src, String description, String tags, boolean makeSrcPublic, boolean makeSlideshowPrivate, boolean generateSecretUrl, boolean allowEmbeds, boolean shareWithContacts) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called uploadSlideshow with username=" + username + ", password=XXX, title=" + title + ", description=" + description + ", tags=" + tags + ", makeSrcPublic=" + makeSrcPublic + ", makeSlideshowPrivate=" + makeSlideshowPrivate + ", generateSecretUrl=" + generateSecretUrl + ", allowEmbeds=" + allowEmbeds + ", shareWithContacts=" + shareWithContacts));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "username", username);
        this.addParameter(parameters, "password", password);
        this.addParameter(parameters, "slideshow_title", title);
        this.addParameter(parameters, "slideshow_description", description);
        this.addParameter(parameters, "slideshow_tags", tags);
        this.addParameter(parameters, "make_src_public", makeSrcPublic);
        this.addParameter(parameters, "make_slideshow_private", makeSlideshowPrivate);
        this.addParameter(parameters, "generate_secret_url", generateSecretUrl);
        this.addParameter(parameters, "allow_embeds", allowEmbeds);
        this.addParameter(parameters, "share_with_contacts", shareWithContacts);
        HashMap<String, File> files = new HashMap<String, File>();
        files.put("slideshow_srcfile", src);
        return this.sendMessage(URL_UPLOAD_SLIDESHOW, parameters, files).getSlideShowId();
    }

    @Override
    public String deleteSlideshow(String username, String password, String id) throws SlideShareException, SlideShareErrorException {
        logger.info((Object)("Called deleteSlideshow with username=" + username + ", password=XXX, id=" + id));
        HashMap<String, String> parameters = new HashMap<String, String>();
        this.addParameter(parameters, "username", username);
        this.addParameter(parameters, "password", password);
        this.addParameter(parameters, "slideshow_id", id);
        return this.sendGetMessage(URL_DELETE_SLIDESHOW, parameters).getSlideShowId();
    }

    private Map<String, String> addParameter(Map<String, String> parameters, String name, String value) {
        if (value != null) {
            parameters.put(name, value);
        }
        return parameters;
    }

    private Map<String, String> addParameter(Map<String, String> parameters, String name, boolean value) {
        parameters.put(name, value ? "Y" : "N");
        return parameters;
    }

    private Map<String, String> addLimits(Map<String, String> parameters, int offset, int limit) {
        if (offset >= 0) {
            parameters.put("offset", Integer.toString(offset));
        }
        if (limit >= 0) {
            parameters.put("limit", Integer.toString(limit));
        }
        return parameters;
    }

    private DocumentParserResult sendMessage(String url, Map<String, String> parameters) throws SlideShareErrorException {
        DocumentParserResult result;
        this.addCredentials(parameters);
        try {
            InputStream response = this.connector.sendMessage(this.apiUrls.get(url), parameters);
            result = DocumentParser.parse((InputStream)response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a message to the url " + this.apiUrls.get(url), (Throwable)iOException);
        }
        return result;
    }

    private DocumentParserResult sendGetMessage(String url, Map<String, String> parameters) throws SlideShareErrorException {
        DocumentParserResult result;
        this.addCredentials(parameters);
        try {
            InputStream response = this.connector.sendGetMessage(this.apiUrls.get(url), parameters);
            result = DocumentParser.parse((InputStream)response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a message to the url " + this.apiUrls.get(url), (Throwable)iOException);
        }
        return result;
    }

    private DocumentParserResult sendMessage(String url, Map<String, String> parameters, Map<String, File> files) throws SlideShareErrorException {
        DocumentParserResult result;
        this.addCredentials(parameters);
        try {
            InputStream response = this.connector.sendMultiPartMessage(this.apiUrls.get(url), parameters, files);
            result = DocumentParser.parse((InputStream)response);
        }
        catch (IOException iOException) {
            throw new SlideShareErrorException(-1, "Error sending a multipart message to the url " + this.apiUrls.get(url), (Throwable)iOException);
        }
        return result;
    }

    private void addCredentials(Map<String, String> parameters) {
        if (this.username != null && this.password != null) {
            this.addParameter(parameters, "username", this.username);
            this.addParameter(parameters, "password", this.password);
        }
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    static {
        DEFAULT_API_URLS.put(URL_GET_SLIDESHOW, "https://www.slideshare.net/api/2/get_slideshow");
        DEFAULT_API_URLS.put(URL_GET_SLIDESHOW_INFO, "https://www.slideshare.net/api/2/get_slideshow");
        DEFAULT_API_URLS.put(URL_GET_SLIDESHOW_BY_USER, "https://www.slideshare.net/api/2/get_slideshow_by_user");
        DEFAULT_API_URLS.put(URL_GET_SLIDESHOW_BY_TAG, "https://www.slideshare.net/api/2/get_slideshow_by_tag");
        DEFAULT_API_URLS.put(URL_GET_SLIDESHOW_BY_GROUP, "https://www.slideshare.net/api/2/get_slideshow_from_group");
        DEFAULT_API_URLS.put(URL_UPLOAD_SLIDESHOW, "https://www.slideshare.net/api/2/upload_slideshow");
        DEFAULT_API_URLS.put(URL_DELETE_SLIDESHOW, "https://www.slideshare.net/api/2/delete_slideshow");
    }
}

