/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.thumbnail.ThumbnailDefinition;
import org.alfresco.service.cmr.attributes.AttributeService;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.quickshare.QuickShareDisabledException;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.NoSuchPersonException;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;

public class QuickShareServiceImpl
implements QuickShareService,
NodeServicePolicies.BeforeDeleteNodePolicy,
CopyServicePolicies.OnCopyNodePolicy {
    private static final Log logger = LogFactory.getLog(QuickShareServiceImpl.class);
    static final String ATTR_KEY_SHAREDIDS_ROOT = ".sharedIds";
    private boolean enabled;
    private AttributeService attributeService;
    private NodeService nodeService;
    private PersonService personService;
    private PolicyComponent policyComponent;
    private TenantService tenantService;
    private ThumbnailService thumbnailService;

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setAttributeService(AttributeService attributeService) {
        this.attributeService = attributeService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setThumbnailService(ThumbnailService thumbnailService) {
        this.thumbnailService = thumbnailService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeDeleteNode"), ContentModel.TYPE_CONTENT, (Behaviour)new JavaBehaviour(this, "beforeDeleteNode"));
        this.policyComponent.bindClassBehaviour(CopyServicePolicies.OnCopyNodePolicy.QNAME, QuickShareModel.ASPECT_QSHARE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    @Override
    public QuickShareDTO shareContent(NodeRef nodeRef) {
        String sharedId;
        this.checkEnabled();
        QName typeQName = this.nodeService.getType(nodeRef);
        if (!typeQName.equals((Object)ContentModel.TYPE_CONTENT)) {
            throw new InvalidNodeRefException(nodeRef);
        }
        if (!this.nodeService.getAspects(nodeRef).contains(QuickShareModel.ASPECT_QSHARE)) {
            UUID uuid = UUIDGenerator.getInstance().generateRandomBasedUUID();
            sharedId = Base64.encodeBase64URLSafeString((byte[])uuid.toByteArray());
            HashMap<QName, String> props = new HashMap<QName, String>(2);
            props.put(QuickShareModel.PROP_QSHARE_SHAREDID, sharedId);
            props.put(QuickShareModel.PROP_QSHARE_SHAREDBY, AuthenticationUtil.getRunAsUser());
            this.nodeService.addAspect(nodeRef, QuickShareModel.ASPECT_QSHARE, props);
            final NodeRef tenantNodeRef = this.tenantService.getName(nodeRef);
            TenantUtil.runAsDefaultTenant(new TenantUtil.TenantRunAsWork<Void>(){

                @Override
                public Void doWork() throws Exception {
                    QuickShareServiceImpl.this.attributeService.setAttribute((Serializable)tenantNodeRef, new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
                    return null;
                }
            });
            if (logger.isInfoEnabled()) {
                logger.info((Object)("QuickShare - shared content: " + sharedId + " [" + nodeRef + "]"));
            }
        } else {
            sharedId = (String)((Object)this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("QuickShare - content already shared: " + sharedId + " [" + nodeRef + "]"));
            }
        }
        return new QuickShareDTO(sharedId);
    }

    private void checkEnabled() {
        if (!this.enabled) {
            throw new QuickShareDisabledException("QuickShare is disabled system-wide");
        }
    }

    @Override
    public Map<String, Object> getMetaData(NodeRef nodeRef) {
        Map personProps;
        ContentData contentData;
        Map nodeProps;
        block11: {
            this.checkEnabled();
            nodeProps = this.nodeService.getProperties(nodeRef);
            contentData = (ContentData)this.nodeService.getProperty(nodeRef, ContentModel.PROP_CONTENT);
            String modifierUserName = (String)nodeProps.get(ContentModel.PROP_MODIFIER);
            personProps = null;
            if (modifierUserName != null) {
                try {
                    NodeRef personRef = this.personService.getPerson(modifierUserName);
                    if (personRef != null) {
                        personProps = this.nodeService.getProperties(personRef);
                    }
                }
                catch (NoSuchPersonException nspe) {
                    if (!logger.isInfoEnabled()) break block11;
                    logger.info((Object)("MetaDataGet - no such person: " + modifierUserName));
                }
            }
        }
        HashMap metadata = new HashMap(8);
        metadata.put("name", nodeProps.get(ContentModel.PROP_NAME));
        metadata.put("title", nodeProps.get(ContentModel.PROP_TITLE));
        if (contentData != null) {
            metadata.put("mimetype", contentData.getMimetype());
            metadata.put("size", contentData.getSize());
        } else {
            metadata.put("size", 0L);
        }
        metadata.put("modified", nodeProps.get(ContentModel.PROP_MODIFIED));
        if (personProps != null) {
            metadata.put("modifierFirstName", personProps.get(ContentModel.PROP_FIRSTNAME));
            metadata.put("modifierLastName", personProps.get(ContentModel.PROP_LASTNAME));
        }
        ArrayList<String> thumbnailDefs = new ArrayList<String>(7);
        if (contentData != null) {
            List<ThumbnailDefinition> thumbnailDefinitions = this.thumbnailService.getThumbnailRegistry().getThumbnailDefinitions(contentData.getMimetype(), contentData.getSize());
            for (ThumbnailDefinition thumbnailDefinition : thumbnailDefinitions) {
                thumbnailDefs.add(thumbnailDefinition.getName());
            }
        }
        metadata.put("thumbnailDefinitions", thumbnailDefs);
        List<NodeRef> thumbnailRefs = this.thumbnailService.getThumbnails(nodeRef, ContentModel.PROP_CONTENT, null, null);
        ArrayList<String> thumbnailNames = new ArrayList<String>(thumbnailRefs.size());
        for (NodeRef thumbnailRef : thumbnailRefs) {
            thumbnailNames.add((String)((Object)this.nodeService.getProperty(thumbnailRef, ContentModel.PROP_NAME)));
        }
        metadata.put("thumbnailNames", thumbnailNames);
        metadata.put("lastThumbnailModificationData", (List)nodeProps.get(ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
        if (nodeProps.containsKey(QuickShareModel.PROP_QSHARE_SHAREDID)) {
            metadata.put("sharedId", nodeProps.get(QuickShareModel.PROP_QSHARE_SHAREDID));
        }
        HashMap<String, Object> model = new HashMap<String, Object>(1);
        model.put("item", metadata);
        return model;
    }

    @Override
    public Pair<String, NodeRef> getTenantNodeRefFromSharedId(final String sharedId) {
        NodeRef nodeRef = TenantUtil.runAsDefaultTenant(new TenantUtil.TenantRunAsWork<NodeRef>(){

            @Override
            public NodeRef doWork() throws Exception {
                return (NodeRef)QuickShareServiceImpl.this.attributeService.getAttribute(new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
            }
        });
        if (nodeRef == null) {
            throw new InvalidSharedIdException(sharedId);
        }
        String tenantDomain = this.tenantService.getDomain(nodeRef.getStoreRef().getIdentifier());
        return new Pair((Object)tenantDomain, (Object)this.tenantService.getBaseName(nodeRef));
    }

    @Override
    public Map<String, Object> getMetaData(String sharedId) {
        Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(sharedId);
        String tenantDomain = (String)pair.getFirst();
        final NodeRef nodeRef = (NodeRef)pair.getSecond();
        Map<String, Object> model = TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Map<String, Object>>(){

            @Override
            public Map<String, Object> doWork() throws Exception {
                QuickShareServiceImpl.this.checkQuickShareNode(nodeRef);
                return QuickShareServiceImpl.this.getMetaData(nodeRef);
            }
        }, tenantDomain);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("QuickShare - retrieved metadata: " + sharedId + " [" + nodeRef + "][" + model + "]"));
        }
        return model;
    }

    private void checkQuickShareNode(NodeRef nodeRef) {
        if (!this.nodeService.getAspects(nodeRef).contains(QuickShareModel.ASPECT_QSHARE)) {
            throw new InvalidNodeRefException(nodeRef);
        }
    }

    @Override
    public void beforeDeleteNode(final NodeRef beforeDeleteNodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String sharedId = (String)((Object)QuickShareServiceImpl.this.nodeService.getProperty(beforeDeleteNodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                if (sharedId != null) {
                    Pair<String, NodeRef> pair = QuickShareServiceImpl.this.getTenantNodeRefFromSharedId(sharedId);
                    String tenantDomain = (String)pair.getFirst();
                    NodeRef nodeRef = (NodeRef)pair.getSecond();
                    if (nodeRef.equals((Object)beforeDeleteNodeRef)) {
                        QuickShareServiceImpl.this.removeSharedId(sharedId);
                    }
                }
                return null;
            }
        });
    }

    private void removeSharedId(final String sharedId) {
        TenantUtil.runAsDefaultTenant(new TenantUtil.TenantRunAsWork<Void>(){

            @Override
            public Void doWork() throws Exception {
                QuickShareServiceImpl.this.attributeService.removeAttribute(new Serializable[]{QuickShareServiceImpl.ATTR_KEY_SHAREDIDS_ROOT, sharedId});
                return null;
            }
        });
    }

    @Override
    public void unshareContent(final String sharedId) {
        Pair<String, NodeRef> pair = this.getTenantNodeRefFromSharedId(sharedId);
        String tenantDomain = (String)pair.getFirst();
        final NodeRef nodeRef = (NodeRef)pair.getSecond();
        TenantUtil.runAsSystemTenant(new TenantUtil.TenantRunAsWork<Void>(){

            @Override
            public Void doWork() throws Exception {
                QName typeQName = QuickShareServiceImpl.this.nodeService.getType(nodeRef);
                if (!typeQName.equals((Object)ContentModel.TYPE_CONTENT)) {
                    throw new InvalidNodeRefException(nodeRef);
                }
                String nodeSharedId = (String)((Object)QuickShareServiceImpl.this.nodeService.getProperty(nodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                if (!EqualsHelper.nullSafeEquals((Object)nodeSharedId, (Object)sharedId)) {
                    logger.warn((Object)("SharedId mismatch: expected=" + sharedId + ",actual=" + nodeSharedId));
                }
                QuickShareServiceImpl.this.nodeService.removeAspect(nodeRef, QuickShareModel.ASPECT_QSHARE);
                return null;
            }
        }, tenantDomain);
        this.removeSharedId(sharedId);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("QuickShare - unshared content: " + sharedId + " [" + nodeRef + "]"));
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }
}

