/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.quickshare;

import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.model.QuickShareModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.service.cmr.quickshare.InvalidSharedIdException;
import org.alfresco.service.cmr.quickshare.QuickShareDTO;
import org.alfresco.service.cmr.quickshare.QuickShareService;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.apache.commons.codec.binary.Base64;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.safehaus.uuid.UUID;
import org.safehaus.uuid.UUIDGenerator;
import org.springframework.context.ApplicationContext;

public class QuickShareServiceIntegrationTest {
    private static final ApplicationContextInit testContext = new ApplicationContextInit();
    private static CopyService copyService;
    private static NodeService nodeService;
    private static QuickShareService quickShareService;
    private static Repository repository;
    private static AlfrescoPerson user1;
    private static AlfrescoPerson user2;
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(testContext);
    @ClassRule
    public static RuleChain classChain;
    private NodeRef testNode;
    private NodeRef userHome;

    @BeforeClass
    public static void beforeClass() throws Exception {
        QuickShareServiceIntegrationTest.findServices();
    }

    private static void findServices() {
        ApplicationContext ctx = testContext.getApplicationContext();
        copyService = (CopyService)ctx.getBean("CopyService", CopyService.class);
        nodeService = (NodeService)ctx.getBean("NodeService", NodeService.class);
        quickShareService = (QuickShareService)ctx.getBean("QuickShareService", QuickShareService.class);
        repository = (Repository)ctx.getBean("repositoryHelper", Repository.class);
    }

    @Before
    public void createTestData() {
        this.userHome = repository.getUserHome(user1.getPersonNode());
        this.testNode = this.testNodes.createNodeWithTextContent(this.userHome, "Quick Share Test Node", ContentModel.TYPE_CONTENT, user1.getUsername(), "Quick Share Test Node Content");
    }

    @Test
    public void getMetaDataFromNodeRefByOwner() {
        Map metadata = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return quickShareService.getMetaData(QuickShareServiceIntegrationTest.this.testNode);
            }
        }, (String)user1.getUsername());
        Assert.assertNotNull((Object)metadata);
        Assert.assertTrue((metadata.size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=AccessDeniedException.class)
    public void getMetaDataFromNodeRefByNonOwner() {
        Map metadata = (Map)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Map<String, Object>>(){

            public Map<String, Object> doWork() throws Exception {
                return quickShareService.getMetaData(QuickShareServiceIntegrationTest.this.testNode);
            }
        }, (String)user2.getUsername());
    }

    @Test
    public void share() {
        this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.getAspects(QuickShareServiceIntegrationTest.this.testNode).contains(QuickShareModel.ASPECT_QSHARE));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Assert.assertEquals((Object)user1.getUsername(), (Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                return null;
            }
        });
    }

    @Test
    public void unshare() {
        final QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                quickShareService.unshareContent(dto.getId());
                return null;
            }
        }, (String)user1.getUsername());
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Assert.assertFalse((boolean)nodeService.getAspects(QuickShareServiceIntegrationTest.this.testNode).contains(QuickShareModel.ASPECT_QSHARE));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Assert.assertNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                return null;
            }
        });
    }

    private QuickShareDTO share(final NodeRef nodeRef, String username) {
        return (QuickShareDTO)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<QuickShareDTO>(){

            public QuickShareDTO doWork() throws Exception {
                return quickShareService.shareContent(nodeRef);
            }
        }, (String)username);
    }

    @Test
    public void getMetadataFromShareId() {
        QuickShareDTO dto = this.share(this.testNode, user1.getUsername());
        Map<String, Object> metadata = quickShareService.getMetaData(dto.getId());
        Assert.assertNotNull(metadata);
        Assert.assertTrue((metadata.size() > 0 ? 1 : 0) != 0);
    }

    @Test(expected=InvalidSharedIdException.class)
    public void getMetadataFromShareIdWithInvalidId() {
        UUID uuid = UUIDGenerator.getInstance().generateRandomBasedUUID();
        String sharedId = Base64.encodeBase64URLSafeString((byte[])uuid.toByteArray());
        Map<String, Object> metadata = quickShareService.getMetaData(sharedId);
    }

    @Test
    public void copyNode() {
        this.share(this.testNode, user1.getUsername());
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Assert.assertTrue((boolean)nodeService.hasAspect(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.ASPECT_QSHARE));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDBY));
                Assert.assertNotNull((Object)nodeService.getProperty(QuickShareServiceIntegrationTest.this.testNode, QuickShareModel.PROP_QSHARE_SHAREDID));
                Map originalProps = nodeService.getProperties(QuickShareServiceIntegrationTest.this.testNode);
                NodeRef copyNodeRef = copyService.copyAndRename(QuickShareServiceIntegrationTest.this.testNode, QuickShareServiceIntegrationTest.this.userHome, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"copy"), true);
                Map copyProps = nodeService.getProperties(copyNodeRef);
                Assert.assertFalse((boolean)nodeService.hasAspect(copyNodeRef, QuickShareModel.ASPECT_QSHARE));
                Assert.assertNull((Object)nodeService.getProperty(copyNodeRef, QuickShareModel.PROP_QSHARE_SHAREDBY));
                Assert.assertNull((Object)nodeService.getProperty(copyNodeRef, QuickShareModel.PROP_QSHARE_SHAREDID));
                for (QName property : originalProps.keySet()) {
                    if (property.equals((Object)QuickShareModel.PROP_QSHARE_SHAREDBY) || property.equals((Object)QuickShareModel.PROP_QSHARE_SHAREDID)) continue;
                    Assert.assertTrue((String)("Mising property " + property), (boolean)copyProps.containsKey(property));
                }
                return null;
            }
        }, (String)user1.getUsername());
    }

    static {
        user1 = new AlfrescoPerson(testContext, "UserOne");
        user2 = new AlfrescoPerson(testContext, "UserTwo");
        classChain = RuleChain.outerRule((TestRule)testContext).around((TestRule)user1).around((TestRule)user2);
    }
}

