/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.ClasspathScriptLocation;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.rating.RatingNamingConventionsUtil;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rating.Rating;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.cmr.rating.RatingService;
import org.alfresco.service.cmr.rating.RatingServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.ScriptService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public class RatingServiceIntegrationTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER1 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserOne");
    public static AlfrescoPerson TEST_USER2 = new AlfrescoPerson(APP_CONTEXT_INIT, "UserTwo");
    public static TemporaryNodes STATIC_TEST_NODES = new TemporaryNodes(APP_CONTEXT_INIT);
    @ClassRule
    public static RuleChain ruleChain = RuleChain.outerRule((TestRule)APP_CONTEXT_INIT).around((TestRule)TEST_USER1).around((TestRule)TEST_USER2).around((TestRule)STATIC_TEST_NODES);
    @Rule
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CONTEXT_INIT);
    @Rule
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER1);
    private static CopyService COPY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static RatingService RATING_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static ScriptService SCRIPT_SERVICE;
    private static RatingNamingConventionsUtil RATING_NAMING_CONVENTIONS;
    private static NodeRef COMPANY_HOME;
    private static NodeRef COPY_DEST_FOLDER;
    private static NodeRef TEST_FOLDER;
    private NodeRef testDoc_Admin;
    private NodeRef testDoc_Copy;
    private NodeRef testDoc_UserOne;
    private NodeRef testDoc_UserTwo;
    private static final String LIKES_SCHEME_NAME = "likesRatingScheme";
    private static final String FIVE_STAR_SCHEME_NAME = "fiveStarRatingScheme";

    @BeforeClass
    public static void initStaticData() throws Exception {
        COPY_SERVICE = (CopyService)APP_CONTEXT_INIT.getApplicationContext().getBean("copyService");
        NODE_SERVICE = (NodeService)APP_CONTEXT_INIT.getApplicationContext().getBean("nodeService");
        RATING_NAMING_CONVENTIONS = (RatingNamingConventionsUtil)APP_CONTEXT_INIT.getApplicationContext().getBean("rollupNamingConventions");
        RATING_SERVICE = (RatingService)APP_CONTEXT_INIT.getApplicationContext().getBean("ratingService");
        SCRIPT_SERVICE = (ScriptService)APP_CONTEXT_INIT.getApplicationContext().getBean("scriptService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)APP_CONTEXT_INIT.getApplicationContext().getBean("retryingTransactionHelper");
        Repository repositoryHelper = (Repository)APP_CONTEXT_INIT.getApplicationContext().getBean("repositoryHelper");
        COMPANY_HOME = repositoryHelper.getCompanyHome();
        TEST_FOLDER = STATIC_TEST_NODES.createNode(COMPANY_HOME, "testFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
        COPY_DEST_FOLDER = STATIC_TEST_NODES.createNode(COMPANY_HOME, "testCopyDestinationFolder", ContentModel.TYPE_FOLDER, AuthenticationUtil.getAdminUserName());
    }

    @Before
    public void createTestContent() {
        this.testDoc_Admin = this.testNodes.createNode(TEST_FOLDER, "testDocInFolder", ContentModel.TYPE_CONTENT, AuthenticationUtil.getAdminUserName());
        this.testDoc_UserOne = this.testNodes.createNode(TEST_FOLDER, "userOnesDoc", ContentModel.TYPE_CONTENT, TEST_USER1.getUsername());
        this.testDoc_UserTwo = this.testNodes.createNode(TEST_FOLDER, "userTwosDoc", ContentModel.TYPE_CONTENT, TEST_USER2.getUsername());
    }

    @Test
    public void outOfTheBoxRatingSchemes() throws Exception {
        Map<String, RatingScheme> schemes = RATING_SERVICE.getRatingSchemes();
        Assert.assertNotNull((String)"rating scheme collection was null.", schemes);
        Assert.assertTrue((String)"rating scheme collection was empty.", (!schemes.isEmpty() ? 1 : 0) != 0);
        RatingScheme likesRS = schemes.get(LIKES_SCHEME_NAME);
        Assert.assertNotNull((String)"'likes' rating scheme was missing.", (Object)likesRS);
        Assert.assertEquals((String)"'likes' rating scheme had wrong name.", (Object)LIKES_SCHEME_NAME, (Object)likesRS.getName());
        Assert.assertEquals((String)"'likes' rating scheme had wrong min.", (long)1L, (long)((int)likesRS.getMinRating()));
        Assert.assertEquals((String)"'likes' rating scheme had wrong max.", (long)1L, (long)((int)likesRS.getMaxRating()));
        RatingScheme fiveStarRS = schemes.get(FIVE_STAR_SCHEME_NAME);
        Assert.assertNotNull((String)"'5*' rating scheme was missing.", (Object)fiveStarRS);
        Assert.assertEquals((String)"'5*' rating scheme had wrong name.", (Object)FIVE_STAR_SCHEME_NAME, (Object)fiveStarRS.getName());
        Assert.assertEquals((String)"'5*' rating scheme had wrong min.", (long)1L, (long)((int)fiveStarRS.getMinRating()));
        Assert.assertEquals((String)"'5*' rating scheme had wrong max.", (long)5L, (long)((int)fiveStarRS.getMaxRating()));
    }

    @Test
    public void applyIllegalRatings() throws Exception {
        float[] illegalRatings;
        for (float illegalRating : illegalRatings = new float[]{0.0f, 2.0f}) {
            this.applyIllegalRating(this.testDoc_Admin, illegalRating, LIKES_SCHEME_NAME);
        }
    }

    private void applyIllegalRating(NodeRef nodeRef, float illegalRating, String schemeName) {
        try {
            RATING_SERVICE.applyRating(nodeRef, illegalRating, schemeName);
        }
        catch (RatingServiceException expectedException) {
            return;
        }
        Assert.fail((String)("Illegal rating " + illegalRating + " should have caused exception."));
    }

    @Test
    public void applyUpdateDeleteRatings() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER2.getUsername());
                Rating nullRating = RATING_SERVICE.getRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.LIKES_SCHEME_NAME);
                Assert.assertNull((String)"Expected a null rating,", (Object)nullRating);
                Assert.assertNull((String)"Expected a null remove result.", (Object)RATING_SERVICE.removeRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.LIKES_SCHEME_NAME));
                int fiveStarScore = 5;
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 5.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                Assert.assertTrue((String)(ContentModel.ASPECT_RATEABLE + " aspect missing."), (boolean)NODE_SERVICE.hasAspect(RatingServiceIntegrationTest.this.testDoc_Admin, ContentModel.ASPECT_RATEABLE));
                List allChildren = NODE_SERVICE.getChildAssocs(RatingServiceIntegrationTest.this.testDoc_Admin, (QNamePattern)ContentModel.ASSOC_RATINGS, RegexQNamePattern.MATCH_ALL);
                Assert.assertEquals((String)"Wrong number of ratings nodes.", (long)1L, (long)allChildren.size());
                Assert.assertEquals((String)"Wrong type qname on ratings assoc", (Object)ContentModel.ASSOC_RATINGS, (Object)((ChildAssociationRef)allChildren.get(0)).getTypeQName());
                QName expectedAssocName = RATING_NAMING_CONVENTIONS.getRatingAssocNameFor(AuthenticationUtil.getFullyAuthenticatedUser(), RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Wrong qname on ratings assoc", (Object)expectedAssocName, (Object)((ChildAssociationRef)allChildren.get(0)).getQName());
                Rating fiveStarRating = RATING_SERVICE.getRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertNotNull((String)"'5*' rating was null.", (Object)fiveStarRating);
                Assert.assertEquals((String)"Wrong score for rating", (long)5L, (long)((int)fiveStarRating.getScore()));
                Assert.assertEquals((String)"Wrong user for rating", (Object)AuthenticationUtil.getFullyAuthenticatedUser(), (Object)fiveStarRating.getAppliedBy());
                Date fiveStarRatingAppliedAt = fiveStarRating.getAppliedAt();
                int updatedFiveStarScore = 3;
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 3.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                allChildren = NODE_SERVICE.getChildAssocs(RatingServiceIntegrationTest.this.testDoc_Admin, (QNamePattern)ContentModel.ASSOC_RATINGS, RegexQNamePattern.MATCH_ALL);
                Assert.assertEquals((String)"Wrong number of ratings nodes.", (long)1L, (long)allChildren.size());
                Assert.assertEquals((String)"Wrong type qname on ratings assoc", (Object)ContentModel.ASSOC_RATINGS, (Object)((ChildAssociationRef)allChildren.get(0)).getTypeQName());
                Assert.assertEquals((String)"Wrong qname on ratings assoc", (Object)expectedAssocName, (Object)((ChildAssociationRef)allChildren.get(0)).getQName());
                Rating updatedFiveStarRating = RATING_SERVICE.getRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertNotNull((String)"'5*' rating was null.", (Object)updatedFiveStarRating);
                Assert.assertEquals((String)"Wrong score for rating", (long)3L, (long)((int)updatedFiveStarRating.getScore()));
                Assert.assertEquals((String)"Wrong user for rating", (Object)AuthenticationUtil.getFullyAuthenticatedUser(), (Object)updatedFiveStarRating.getAppliedBy());
                Assert.assertTrue((String)"five star rating date was unchanged.", (!fiveStarRatingAppliedAt.equals(updatedFiveStarRating.getAppliedAt()) ? 1 : 0) != 0);
                Rating deletedStarRating = RATING_SERVICE.removeRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                Assert.assertNotNull((String)"'5*' rating was null.", (Object)deletedStarRating);
                Assert.assertEquals((String)"Wrong score for rating", (long)3L, (long)((int)deletedStarRating.getScore()));
                Assert.assertEquals((String)"Wrong user for rating", (Object)AuthenticationUtil.getFullyAuthenticatedUser(), (Object)deletedStarRating.getAppliedBy());
                Assert.assertEquals((String)"Wrong date for rating", (Object)updatedFiveStarRating.getAppliedAt(), (Object)deletedStarRating.getAppliedAt());
                Assert.assertNull((String)"5* rating not null.", (Object)RATING_SERVICE.getRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME));
                return null;
            }
        });
    }

    @Test
    public void oneUserRatesAndRerates() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 1.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 2.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                float meanRating = RATING_SERVICE.getAverageRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong mean rating.", (long)2L, (long)((int)meanRating));
                float totalRating = RATING_SERVICE.getTotalRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong total rating.", (long)2L, (long)((int)totalRating));
                int ratingsCount = RATING_SERVICE.getRatingsCount(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong ratings count.", (long)1L, (long)ratingsCount);
                Assert.assertEquals((String)"Wrong number of child nodes", (long)1L, (long)NODE_SERVICE.getChildAssocs(RatingServiceIntegrationTest.this.testDoc_Admin).size());
                return null;
            }
        });
    }

    @Test
    public void oneUserRatesInTwoSchemes() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserTwo, 2.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserTwo, 1.0f, RatingServiceIntegrationTest.LIKES_SCHEME_NAME);
                Assert.assertEquals((String)"Wrong number of child nodes", (long)2L, (long)NODE_SERVICE.getChildAssocs(RatingServiceIntegrationTest.this.testDoc_UserTwo).size());
                List<Rating> ratings = RATING_SERVICE.getRatingsByCurrentUser(RatingServiceIntegrationTest.this.testDoc_UserTwo);
                Assert.assertEquals((long)2L, (long)ratings.size());
                Assert.assertEquals((Object)RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME, (Object)ratings.get(0).getScheme().getName());
                Assert.assertEquals((Object)RatingServiceIntegrationTest.LIKES_SCHEME_NAME, (Object)ratings.get(1).getScheme().getName());
                return null;
            }
        });
    }

    @Test
    public void applyRating_MultipleUsers() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER1.getUsername());
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 4.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER2.getUsername());
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_Admin, 2.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                float meanRating = RATING_SERVICE.getAverageRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong mean rating.", (long)3L, (long)((int)meanRating));
                float totalRating = RATING_SERVICE.getTotalRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong total rating.", (long)6L, (long)((int)totalRating));
                int ratingsCount = RATING_SERVICE.getRatingsCount(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong ratings count.", (long)2L, (long)ratingsCount);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                RATING_SERVICE.removeRatingByCurrentUser(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                meanRating = RATING_SERVICE.getAverageRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong mean rating.", (long)4L, (long)((int)meanRating));
                totalRating = RATING_SERVICE.getTotalRating(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong total rating.", (long)4L, (long)((int)totalRating));
                ratingsCount = RATING_SERVICE.getRatingsCount(RatingServiceIntegrationTest.this.testDoc_Admin, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((String)"Document had wrong ratings count.", (long)1L, (long)ratingsCount);
                RatingServiceIntegrationTest.this.assertModifierIs(RatingServiceIntegrationTest.this.testDoc_Admin, AuthenticationUtil.getAdminUserName());
                return null;
            }
        });
    }

    private void assertModifierIs(NodeRef nodeRef, String expectedModifier) {
        String actualModifier = (String)((Object)NODE_SERVICE.getProperty(nodeRef, ContentModel.PROP_MODIFIER));
        Assert.assertEquals((String)"Incorrect cm:modifier", (Object)expectedModifier, (Object)actualModifier);
    }

    @Test
    public void usersCantRateTheirOwnContent() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserOne, 1.0f, RatingServiceIntegrationTest.LIKES_SCHEME_NAME);
                boolean expectedExceptionThrown = false;
                try {
                    RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserOne, 4.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                }
                catch (RatingServiceException expected) {
                    expectedExceptionThrown = true;
                }
                Assert.assertTrue((boolean)expectedExceptionThrown);
                return null;
            }
        });
    }

    @Test
    @RunAsFullyAuthenticatedRule.RunAsUser(userName="UserTwo")
    public void javascriptAPI() throws Exception {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("testNode", RatingServiceIntegrationTest.this.testDoc_UserOne);
                ClasspathScriptLocation location = new ClasspathScriptLocation("org/alfresco/repo/rating/script/test_ratingService.js");
                SCRIPT_SERVICE.executeScript(location, model);
                return null;
            }
        });
    }

    @Test
    public void copyNodeNotRatings() {
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER1.getUsername());
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserTwo, 2.0f, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                RATING_SERVICE.applyRating(RatingServiceIntegrationTest.this.testDoc_UserTwo, 1.0f, RatingServiceIntegrationTest.LIKES_SCHEME_NAME);
                Assert.assertEquals((String)"Wrong number of child nodes", (long)2L, (long)NODE_SERVICE.getChildAssocs(RatingServiceIntegrationTest.this.testDoc_UserTwo).size());
                List<Rating> ratings = RATING_SERVICE.getRatingsByCurrentUser(RatingServiceIntegrationTest.this.testDoc_UserTwo);
                Assert.assertEquals((long)2L, (long)ratings.size());
                Assert.assertEquals((Object)RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME, (Object)ratings.get(0).getScheme().getName());
                Assert.assertEquals((Object)RatingServiceIntegrationTest.LIKES_SCHEME_NAME, (Object)ratings.get(1).getScheme().getName());
                AuthenticationUtil.setFullyAuthenticatedUser((String)AuthenticationUtil.getAdminUserName());
                QName childName = QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)"userTwosDoc");
                NodeRef testDocCopy = COPY_SERVICE.copy(RatingServiceIntegrationTest.this.testDoc_UserTwo, COPY_DEST_FOLDER, ContentModel.ASSOC_CONTAINS, childName, true);
                RatingServiceIntegrationTest.this.testNodes.addNodeRef(testDocCopy);
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER1.getUsername());
                List<Rating> copiedRatings = RATING_SERVICE.getRatingsByCurrentUser(testDocCopy);
                Assert.assertEquals((long)0L, (long)copiedRatings.size());
                int likesRatingCount = RATING_SERVICE.getRatingsCount(testDocCopy, RatingServiceIntegrationTest.LIKES_SCHEME_NAME);
                int fiveStarRatingCount = RATING_SERVICE.getRatingsCount(testDocCopy, RatingServiceIntegrationTest.FIVE_STAR_SCHEME_NAME);
                Assert.assertEquals((long)0L, (long)fiveStarRatingCount);
                Assert.assertEquals((long)0L, (long)likesRatingCount);
                return null;
            }
        });
    }
}

