/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remoteconnector;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorRequest;
import org.alfresco.service.cmr.remoteconnector.RemoteConnectorResponse;
import org.apache.commons.httpclient.Header;
import org.apache.tika.io.IOUtils;

public class RemoteConnectorResponseImpl
implements RemoteConnectorResponse {
    private RemoteConnectorRequest request;
    private String contentType;
    private String charset;
    private int status;
    private Header[] headers;
    private InputStream bodyStream;
    private byte[] bodyBytes;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public RemoteConnectorResponseImpl(RemoteConnectorRequest request, String contentType, String charset, int status, Header[] headers, InputStream response) {
        this.request = request;
        this.contentType = contentType;
        this.charset = charset;
        this.headers = headers;
        this.status = status;
        this.bodyStream = response;
        this.bodyBytes = null;
    }

    public RemoteConnectorResponseImpl(RemoteConnectorRequest request, String contentType, String charset, int status, Header[] headers, byte[] response) {
        this(request, contentType, charset, status, headers, new ByteArrayInputStream(RemoteConnectorResponseImpl.ensureBytes(response)));
        this.bodyBytes = RemoteConnectorResponseImpl.ensureBytes(response);
    }

    private static byte[] ensureBytes(byte[] bytes) {
        if (bytes == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return bytes;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }

    @Override
    public String getContentType() {
        int split = this.contentType.indexOf(59);
        if (split == -1) {
            return this.contentType;
        }
        return this.contentType.substring(0, split);
    }

    @Override
    public String getRawContentType() {
        return this.contentType;
    }

    @Override
    public RemoteConnectorRequest getRequest() {
        return this.request;
    }

    @Override
    public Header[] getResponseHeaders() {
        return this.headers;
    }

    @Override
    public byte[] getResponseBodyAsBytes() throws IOException {
        if (this.bodyBytes == null) {
            this.bodyBytes = IOUtils.toByteArray((InputStream)this.bodyStream);
            this.bodyStream.close();
            this.bodyStream = new ByteArrayInputStream(this.bodyBytes);
        }
        return this.bodyBytes;
    }

    @Override
    public InputStream getResponseBodyAsStream() {
        return this.bodyStream;
    }

    @Override
    public String getResponseBodyAsString() throws IOException {
        String charset = this.charset;
        if (charset == null) {
            charset = "UTF-8";
        }
        return new String(this.getResponseBodyAsBytes(), charset);
    }
}

