/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.rendition.RenderCallback;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RenditionedAspect
implements NodeServicePolicies.OnUpdatePropertiesPolicy,
CopyServicePolicies.OnCopyNodePolicy {
    private static final Log logger = LogFactory.getLog(RenditionedAspect.class);
    private ActionService actionService;
    private DictionaryService dictionaryService;
    private NodeService nodeService;
    private PolicyComponent policyComponent;
    private RenditionService renditionService;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onUpdateProperties"), RenditionModel.ASPECT_RENDITIONED, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), RenditionModel.ASPECT_RENDITIONED, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef)) {
            List<QName> changedProperties = this.getChangedProperties(before, after);
            List<ChildAssociationRef> renditions = this.renditionService.getRenditions(nodeRef);
            for (ChildAssociationRef chAssRef : renditions) {
                final QName renditionAssocName = chAssRef.getQName();
                RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

                    public RenditionDefinition doWork() throws Exception {
                        return RenditionedAspect.this.renditionService.loadRenditionDefinition(renditionAssocName);
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
                if (rendDefn == null) {
                    if (!logger.isDebugEnabled()) continue;
                    StringBuilder msg = new StringBuilder();
                    msg.append("Cannot update rendition ").append(renditionAssocName).append(" on node ").append(nodeRef).append(" as the renditionDefinition could not be loaded.");
                    logger.debug((Object)msg.toString());
                    continue;
                }
                Serializable updateRenditionsPolicy = rendDefn.getParameterValue("update-renditions-on-any-property-change");
                boolean updateRenditionsAlways = updateRenditionsPolicy == null ? false : (Boolean)updateRenditionsPolicy;
                boolean renditionUpdateRequired = false;
                for (QName qname : changedProperties) {
                    try {
                        PropertyDefinition propertyDef = this.dictionaryService.getProperty(qname);
                        if (propertyDef == null) continue;
                        if (!propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT)) {
                            if (!updateRenditionsAlways) continue;
                            renditionUpdateRequired = true;
                            continue;
                        }
                        renditionUpdateRequired = true;
                    }
                    catch (ClassCastException ccx) {}
                }
                if (!renditionUpdateRequired) continue;
                this.queueUpdate(nodeRef, rendDefn, chAssRef);
            }
        }
    }

    private List<QName> getChangedProperties(Map<QName, Serializable> before, Map<QName, Serializable> after) {
        ArrayList<QName> results = new ArrayList<QName>();
        for (QName propQName : before.keySet()) {
            Serializable afterValue;
            if (!after.keySet().contains(propQName)) {
                results.add(propQName);
                continue;
            }
            Serializable beforeValue = before.get(propQName);
            if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(propQName)))) continue;
            results.add(propQName);
        }
        for (QName propQName : after.keySet()) {
            if (before.containsKey(propQName)) continue;
            results.add(propQName);
        }
        return results;
    }

    private void queueUpdate(final NodeRef sourceNodeRef, final RenditionDefinition rendDefn, ChildAssociationRef renditionAssoc) {
        if (logger.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Queueing rendition update for node ").append(sourceNodeRef).append(": ").append(rendDefn.getRenditionName());
            logger.debug((Object)msg.toString());
        }
        if (rendDefn != null) {
            Action deleteRendition = this.actionService.createAction("delete-rendition");
            deleteRendition.setParameterValue("rendition-definition-name", (Serializable)rendDefn.getRenditionName());
            rendDefn.setCompensatingAction(deleteRendition);
            this.renditionService.render(sourceNodeRef, rendDefn, new RenderCallback(){

                @Override
                public void handleFailedRendition(Throwable t) {
                    if (logger.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Re-rendering of node ").append(sourceNodeRef).append(" with renditionDefinition ").append(rendDefn.getRenditionName()).append(" failed. Deleting defunct rendition. ").append("The following exception is shown for informational purposes only ").append("and does not affect operation of the system.");
                        logger.debug((Object)msg.toString(), t);
                    }
                }

                @Override
                public void handleSuccessfulRendition(ChildAssociationRef primaryParentOfNewRendition) {
                }
            });
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return RenditionedAspectCopyBehaviourCallback.INSTANCE;
    }

    private static class RenditionedAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new RenditionedAspectCopyBehaviourCallback();

        private RenditionedAspectCopyBehaviourCallback() {
        }

        @Override
        public boolean getMustCopy(QName classQName, CopyDetails copyDetails) {
            return false;
        }

        @Override
        public Pair<CopyBehaviourCallback.AssocCopySourceAction, CopyBehaviourCallback.AssocCopyTargetAction> getAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyAssociationDetails assocCopyDetails) {
            return new Pair((Object)CopyBehaviourCallback.AssocCopySourceAction.IGNORE, (Object)CopyBehaviourCallback.AssocCopyTargetAction.USE_COPIED_OTHERWISE_ORIGINAL_TARGET);
        }

        @Override
        public CopyBehaviourCallback.ChildAssocCopyAction getChildAssociationCopyAction(QName classQName, CopyDetails copyDetails, CopyBehaviourCallback.CopyChildAssociationDetails childAssocCopyDetails) {
            return CopyBehaviourCallback.ChildAssocCopyAction.IGNORE;
        }
    }
}

