/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rule;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rule.RuleModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.CopyService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.test.junitrules.AlfrescoPerson;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.alfresco.util.test.junitrules.RunAsFullyAuthenticatedRule;
import org.alfresco.util.test.junitrules.TemporaryNodes;
import org.alfresco.util.test.junitrules.TemporarySites;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;
import org.springframework.context.ApplicationContext;

public class MiscellaneousRulesTest {
    private static final Log log = LogFactory.getLog(MiscellaneousRulesTest.class);
    public static ApplicationContextInit APP_CTXT_INIT = new ApplicationContextInit();
    public static AlfrescoPerson TEST_USER = new AlfrescoPerson(APP_CTXT_INIT);
    @ClassRule
    public static RuleChain STATIC_RULE_CHAIN = RuleChain.outerRule((TestRule)APP_CTXT_INIT).around((TestRule)TEST_USER);
    public RunAsFullyAuthenticatedRule runAsRule = new RunAsFullyAuthenticatedRule(TEST_USER);
    public TemporarySites testSites = new TemporarySites(APP_CTXT_INIT);
    public TemporaryNodes testNodes = new TemporaryNodes(APP_CTXT_INIT);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.runAsRule).around((TestRule)this.testSites).around((TestRule)this.testNodes);
    private static ActionService ACTION_SERVICE;
    private static CopyService COPY_SERVICE;
    private static NodeService NODE_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static RuleService RULE_SERVICE;
    private static SiteService SITE_SERVICE;
    private SiteInfo testSite;

    @BeforeClass
    public static void initSpringBeans() throws Exception {
        ApplicationContext appCtxt = APP_CTXT_INIT.getApplicationContext();
        ACTION_SERVICE = (ActionService)appCtxt.getBean("ActionService", ActionService.class);
        COPY_SERVICE = (CopyService)appCtxt.getBean("CopyService", CopyService.class);
        NODE_SERVICE = (NodeService)appCtxt.getBean("NodeService", NodeService.class);
        TRANSACTION_HELPER = (RetryingTransactionHelper)appCtxt.getBean("retryingTransactionHelper", RetryingTransactionHelper.class);
        RULE_SERVICE = (RuleService)appCtxt.getBean("RuleService", RuleService.class);
        SITE_SERVICE = (SiteService)appCtxt.getBean("SiteService", SiteService.class);
    }

    @Before
    public void createTestData() throws Exception {
        this.testSite = this.testSites.createSite("sitePreset", "testSiteName", "testSiteTitle", "test site description", SiteVisibility.PUBLIC, TEST_USER.getUsername());
    }

    @Test
    public void alf14568() throws Exception {
        NodeRef testSiteDocLib = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return SITE_SERVICE.getContainer(MiscellaneousRulesTest.this.testSite.getShortName(), "documentLibrary");
            }
        });
        Assert.assertNotNull((String)"Null doclib", (Object)testSiteDocLib);
        final NodeRef[] folders = new NodeRef[4];
        for (int i : new int[]{0, 1, 2, 3}) {
            folders[i] = this.testNodes.createFolder(testSiteDocLib, "folder" + i, TEST_USER.getUsername());
        }
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
                rule.setRuleType("inbound");
                rule.applyToChildren(false);
                rule.setRuleDisabled(false);
                rule.setTitle("Copy to folder2");
                rule.setExecuteAsynchronously(false);
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("destination-folder", (Serializable)folders[2]);
                Action copyAction = ACTION_SERVICE.createAction("copy", params);
                rule.setAction(copyAction);
                RULE_SERVICE.saveRule(folders[1], rule);
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
                rule.setRuleType("update");
                rule.applyToChildren(false);
                rule.setRuleDisabled(false);
                rule.setTitle("Copy to folder3");
                rule.setExecuteAsynchronously(false);
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("destination-folder", (Serializable)folders[3]);
                Action copyAction = ACTION_SERVICE.createAction("copy", params);
                rule.setAction(copyAction);
                RULE_SERVICE.saveRule(folders[2], rule);
                return null;
            }
        });
        this.testNodes.createQuickFile("text/plain", folders[1], "quick.txt", TEST_USER.getUsername());
        final HashSet foldersContainingFile = new HashSet();
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (NodeRef folder : folders) {
                    NodeRef child = NODE_SERVICE.getChildByName(folder, ContentModel.ASSOC_CONTAINS, "quick.txt");
                    if (child == null) continue;
                    foldersContainingFile.add(folder);
                }
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                for (NodeRef folder : folders) {
                    RULE_SERVICE.removeAllRules(folder);
                }
                return null;
            }
        });
        HashSet<NodeRef> expectedFolders = new HashSet<NodeRef>();
        expectedFolders.add(folders[1]);
        expectedFolders.add(folders[2]);
        Assert.assertEquals(expectedFolders, foldersContainingFile);
    }

    @Test
    public void alf14568_supplementary() throws Exception {
        NodeRef testSiteDocLib = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return SITE_SERVICE.getContainer(MiscellaneousRulesTest.this.testSite.getShortName(), "documentLibrary");
            }
        });
        Assert.assertNotNull((String)"Null doclib", (Object)testSiteDocLib);
        final NodeRef ruleFolder = this.testNodes.createFolder(testSiteDocLib, "ruleFolder", TEST_USER.getUsername());
        final NodeRef originalContent = this.testNodes.createQuickFile("text/plain", testSiteDocLib, "original.txt", TEST_USER.getUsername());
        final NodeRef copyNode = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return COPY_SERVICE.copy(originalContent, ruleFolder, ContentModel.ASSOC_CONTAINS, ContentModel.ASSOC_CONTAINS);
            }
        });
        final QName exifAspectQName = QName.createQName((String)"{http://www.alfresco.org/model/exif/1.0}exif");
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
                rule.setRuleType("update");
                rule.applyToChildren(false);
                rule.setRuleDisabled(false);
                rule.setTitle("Put EXIF aspect on changed nodes");
                rule.setExecuteAsynchronously(false);
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("aspect-name", (Serializable)exifAspectQName);
                Action addAspectAction = ACTION_SERVICE.createAction("add-features", params);
                rule.setAction(addAspectAction);
                RULE_SERVICE.saveRule(ruleFolder, rule);
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                NODE_SERVICE.deleteNode(originalContent);
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertFalse((String)"Rule executed when it shouldn't have.", (boolean)NODE_SERVICE.hasAspect(copyNode, exifAspectQName));
                return null;
            }
        });
    }

    @Test
    public void alf13192_rulesFromFirstFolderMoveToSecondWhenDeleteFirstFolder() throws Exception {
        NodeRef testSiteDocLib = TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return SITE_SERVICE.getContainer(MiscellaneousRulesTest.this.testSite.getShortName(), "documentLibrary");
            }
        });
        Assert.assertNotNull((String)"Null doclib", (Object)testSiteDocLib);
        final NodeRef folder1 = this.testNodes.createFolder(testSiteDocLib, "folder 1", TEST_USER.getUsername());
        final NodeRef folder2 = this.testNodes.createFolder(testSiteDocLib, "folder 2", TEST_USER.getUsername());
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                org.alfresco.service.cmr.rule.Rule rule = new org.alfresco.service.cmr.rule.Rule();
                rule.setRuleType("outbound");
                rule.applyToChildren(false);
                rule.setRuleDisabled(false);
                rule.setTitle("Copy to folder2");
                rule.setExecuteAsynchronously(false);
                HashMap<String, Serializable> params = new HashMap<String, Serializable>();
                params.put("destination-folder", (Serializable)folder2);
                Action copyAction = ACTION_SERVICE.createAction("copy", params);
                rule.setAction(copyAction);
                RULE_SERVICE.saveRule(folder1, rule);
                List ruleFolders = NODE_SERVICE.getChildAssocs(folder1, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER, (QNamePattern)RuleModel.ASSOC_RULE_FOLDER);
                Assert.assertEquals((long)1L, (long)ruleFolders.size());
                log.debug((Object)("Rule SystemFolder noderef is " + ((ChildAssociationRef)ruleFolders.get(0)).getChildRef()));
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                log.debug((Object)("About to delete the ruled folder: " + folder1));
                NODE_SERVICE.deleteNode(folder1);
                return null;
            }
        });
        TRANSACTION_HELPER.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                Assert.assertFalse((boolean)RULE_SERVICE.hasRules(folder2));
                Assert.assertFalse((boolean)NODE_SERVICE.hasAspect(folder2, RuleModel.ASPECT_RULES));
                return null;
            }
        });
    }
}

