/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.alfresco.repo.search.DocumentNavigator;
import org.alfresco.repo.search.NodeServiceXPath;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.XPathException;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.jaxen.JaxenException;

public class NodeSearcher {
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private SearchService searchService;

    public NodeSearcher(NodeService nodeService, DictionaryService dictionaryService, SearchService searchService) {
        this.nodeService = nodeService;
        this.dictionaryService = dictionaryService;
        this.searchService = searchService;
    }

    public List<NodeRef> selectNodes(NodeRef contextNodeRef, String xpathIn, QueryParameterDefinition[] paramDefs, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) {
        try {
            String xpath = xpathIn;
            boolean useJCRXPath = language.equalsIgnoreCase("jcr-xpath");
            ArrayList<AttributeOrder> order = null;
            if (useJCRXPath) {
                order = new ArrayList<AttributeOrder>();
                xpath = xpath.replaceAll("element\\(\\s*(\\*|\\w*:\\w*)\\s*,\\s*(\\*|\\w*:\\w*)\\s*\\)", "$1[subtypeOf(\"$2\")]");
                String[] split = xpath.split("order\\s*by\\s*", 2);
                xpath = split[0];
                if (split.length > 1 && split[1].length() > 0) {
                    String[] clauses;
                    for (String clause : clauses = split[1].split("\\s,\\s")) {
                        if (clause.startsWith("@")) {
                            String attribute = clause.replaceFirst("@(\\p{Alpha}[\\w:]*)(?:\\s+(.*))?", "$1");
                            String sort = clause.replaceFirst("@(\\p{Alpha}[\\w:]*)(?:\\s+(.*))?", "$2");
                            if (sort.length() == 0) {
                                sort = "ascending";
                            }
                            QName attributeQName = QName.createQName((String)attribute, (NamespacePrefixResolver)namespacePrefixResolver);
                            order.add(new AttributeOrder(attributeQName, sort.equalsIgnoreCase("ascending")));
                            continue;
                        }
                        if (clause.startsWith("jcr:score")) continue;
                        throw new IllegalArgumentException("Malformed order by expression " + split[1]);
                    }
                }
            }
            DocumentNavigator documentNavigator = new DocumentNavigator(this.dictionaryService, this.nodeService, this.searchService, namespacePrefixResolver, followAllParentLinks, useJCRXPath);
            NodeServiceXPath nsXPath = new NodeServiceXPath(xpath, documentNavigator, paramDefs);
            for (String prefix : namespacePrefixResolver.getPrefixes()) {
                nsXPath.addNamespace(prefix, namespacePrefixResolver.getNamespaceURI(prefix));
            }
            List list = nsXPath.selectNodes(this.nodeService.getPrimaryParent(contextNodeRef));
            HashSet<NodeRef> unique = new HashSet<NodeRef>(list.size());
            for (Object o : list) {
                if (o instanceof ChildAssociationRef) {
                    unique.add(((ChildAssociationRef)o).getChildRef());
                    continue;
                }
                if (o instanceof DocumentNavigator.Property) {
                    unique.add(((DocumentNavigator.Property)o).parent);
                    continue;
                }
                throw new XPathException("Xpath expression must only select nodes");
            }
            ArrayList<NodeRef> answer = new ArrayList<NodeRef>(unique.size());
            answer.addAll(unique);
            if (order != null) {
                this.orderNodes(answer, order);
                for (NodeRef node : answer) {
                    StringBuffer buffer = new StringBuffer();
                    for (AttributeOrder attOrd : order) {
                        buffer.append(" ").append(this.nodeService.getProperty(node, attOrd.attribute));
                    }
                }
            }
            return answer;
        }
        catch (JaxenException e) {
            throw new XPathException("Error executing xpath: \n   xpath: " + xpathIn, (Throwable)e);
        }
    }

    private void orderNodes(List<NodeRef> answer, List<AttributeOrder> order) {
        Collections.sort(answer, new NodeRefComparator(this.nodeService, order));
    }

    public List<Serializable> selectProperties(NodeRef contextNodeRef, String xpath, QueryParameterDefinition[] paramDefs, NamespacePrefixResolver namespacePrefixResolver, boolean followAllParentLinks, String language) {
        try {
            boolean useJCRXPath = language.equalsIgnoreCase("jcr-xpath");
            DocumentNavigator documentNavigator = new DocumentNavigator(this.dictionaryService, this.nodeService, this.searchService, namespacePrefixResolver, followAllParentLinks, useJCRXPath);
            NodeServiceXPath nsXPath = new NodeServiceXPath(xpath, documentNavigator, paramDefs);
            for (String prefix : namespacePrefixResolver.getPrefixes()) {
                nsXPath.addNamespace(prefix, namespacePrefixResolver.getNamespaceURI(prefix));
            }
            List list = nsXPath.selectNodes(this.nodeService.getPrimaryParent(contextNodeRef));
            ArrayList<Serializable> answer = new ArrayList<Serializable>(list.size());
            for (Object o : list) {
                if (!(o instanceof DocumentNavigator.Property)) {
                    throw new XPathException("Xpath expression must only select nodes");
                }
                answer.add(((DocumentNavigator.Property)o).value);
            }
            return answer;
        }
        catch (JaxenException e) {
            throw new XPathException("Error executing xpath", (Throwable)e);
        }
    }

    private static class AttributeOrder {
        QName attribute;
        boolean ascending;

        AttributeOrder(QName attribute, boolean ascending) {
            this.attribute = attribute;
            this.ascending = ascending;
        }
    }

    static class NodeRefComparator
    implements Comparator<NodeRef> {
        List<AttributeOrder> order;
        NodeService nodeService;

        NodeRefComparator(NodeService nodeService, List<AttributeOrder> order) {
            this.nodeService = nodeService;
            this.order = order;
        }

        @Override
        public int compare(NodeRef n1, NodeRef n2) {
            for (AttributeOrder attributeOrder : this.order) {
                Serializable o1 = this.nodeService.getProperty(n1, attributeOrder.attribute);
                Serializable o2 = this.nodeService.getProperty(n2, attributeOrder.attribute);
                if (o1 == null) {
                    if (o2 == null) continue;
                    return attributeOrder.ascending ? -1 : 1;
                }
                if (o2 == null) {
                    return attributeOrder.ascending ? 1 : -1;
                }
                if (!(o1 instanceof Comparable) || !(o2 instanceof Comparable)) continue;
                return (attributeOrder.ascending ? 1 : -1) * ((Comparable)((Object)o1)).compareTo((Comparable)((Object)o2));
            }
            return 0;
        }
    }
}

