/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.IndexerException;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.CategoryService;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.ResultSetRow;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;

public class LuceneCategoryServiceImpl
implements CategoryService {
    protected NodeService nodeService;
    protected NodeService publicNodeService;
    protected TenantService tenantService;
    protected NamespacePrefixResolver namespacePrefixResolver;
    protected DictionaryService dictionaryService;
    protected IndexerAndSearcher indexerAndSearcher;
    HashMap<String, String> prefixLookup = new HashMap();

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPublicNodeService(NodeService publicNodeService) {
        this.publicNodeService = publicNodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setIndexerAndSearcher(IndexerAndSearcher indexerAndSearcher) {
        this.indexerAndSearcher = indexerAndSearcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ChildAssociationRef> getChildren(NodeRef categoryRef, CategoryService.Mode mode, CategoryService.Depth depth) {
        if (categoryRef == null) {
            return Collections.emptyList();
        }
        categoryRef = this.tenantService.getBaseName(categoryRef);
        ResultSet resultSet = null;
        try {
            StringBuilder luceneQuery = new StringBuilder(64);
            switch (mode) {
                case ALL: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    break;
                }
                case MEMBERS: {
                    luceneQuery.append("PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("member").append("\" ");
                    break;
                }
                case SUB_CATEGORIES: {
                    luceneQuery.append("+PATH:\"");
                    luceneQuery.append(this.buildXPath(this.nodeService.getPath(categoryRef))).append("/");
                    if (depth.equals((Object)CategoryService.Depth.ANY)) {
                        luceneQuery.append("/");
                    }
                    luceneQuery.append("*").append("\" ");
                    luceneQuery.append("+TYPE:\"" + ContentModel.TYPE_CATEGORY.toString() + "\"");
                }
            }
            SearchService searcher = this.indexerAndSearcher.getSearcher(categoryRef.getStoreRef(), true);
            resultSet = searcher.query(categoryRef.getStoreRef(), "lucene", luceneQuery.toString(), null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    private String buildXPath(Path path) {
        StringBuilder pathBuffer = new StringBuilder(64);
        for (Path.Element element : path) {
            if (!(element instanceof Path.ChildAssocElement)) {
                throw new IndexerException("Confused path: " + path);
            }
            Path.ChildAssocElement cae = (Path.ChildAssocElement)element;
            if (cae.getRef().getParentRef() == null) continue;
            pathBuffer.append("/");
            pathBuffer.append(this.getPrefix(cae.getRef().getQName().getNamespaceURI()));
            pathBuffer.append(ISO9075.encode((String)cae.getRef().getQName().getLocalName()));
        }
        return pathBuffer.toString();
    }

    private String getPrefix(String uri) {
        String prefix = this.prefixLookup.get(uri);
        if (prefix == null) {
            Collection prefixes = this.namespacePrefixResolver.getPrefixes(uri);
            Iterator i$ = prefixes.iterator();
            if (i$.hasNext()) {
                String first;
                prefix = first = (String)i$.next();
            }
            this.prefixLookup.put(uri, prefix);
        }
        if (prefix == null) {
            return "";
        }
        return prefix + ":";
    }

    private Collection<ChildAssociationRef> resultSetToChildAssocCollection(ResultSet resultSet) {
        LinkedList<ChildAssociationRef> collection = new LinkedList<ChildAssociationRef>();
        if (resultSet != null) {
            for (ResultSetRow row : resultSet) {
                try {
                    ChildAssociationRef car = this.nodeService.getPrimaryParent(row.getNodeRef());
                    collection.add(car);
                }
                catch (InvalidNodeRefException inre) {}
            }
        }
        return collection;
    }

    @Override
    public Collection<ChildAssociationRef> getCategories(StoreRef storeRef, QName aspectQName, CategoryService.Depth depth) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectQName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, depth));
        }
        return assocs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<NodeRef> getClassificationNodes(StoreRef storeRef, QName qname) {
        ResultSet resultSet = null;
        try {
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH:\"/" + this.getPrefix(qname.getNamespaceURI()) + ISO9075.encode((String)qname.getLocalName()) + "\"", null);
            HashSet<NodeRef> nodeRefs = new HashSet<NodeRef>(resultSet.length());
            for (ResultSetRow row : resultSet) {
                nodeRefs.add(row.getNodeRef());
            }
            HashSet<NodeRef> hashSet = nodeRefs;
            return hashSet;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ChildAssociationRef> getClassifications(StoreRef storeRef) {
        ResultSet resultSet = null;
        try {
            resultSet = this.indexerAndSearcher.getSearcher(storeRef, false).query(storeRef, "lucene", "PATH:\"//cm:categoryRoot/*\"", null);
            Collection<ChildAssociationRef> collection = this.resultSetToChildAssocCollection(resultSet);
            return collection;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    @Override
    public Collection<QName> getClassificationAspects() {
        return this.dictionaryService.getSubAspects(ContentModel.ASPECT_CLASSIFIABLE, true);
    }

    @Override
    public NodeRef createClassification(StoreRef storeRef, QName typeName, String attributeName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName) {
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        for (NodeRef nodeRef : nodeRefs) {
            assocs.addAll(this.getChildren(nodeRef, CategoryService.Mode.SUB_CATEGORIES, CategoryService.Depth.IMMEDIATE));
        }
        return assocs;
    }

    @Override
    public ChildAssociationRef getCategory(NodeRef parent, QName aspectName, String name) {
        String validLocalName;
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        List assocs = this.nodeService.getChildAssocs(parent, (QNamePattern)ContentModel.ASSOC_SUBCATEGORIES, (QNamePattern)QName.createQName((String)uri, (String)(validLocalName = QName.createValidLocalName((String)name))), false);
        if (assocs.isEmpty()) {
            return null;
        }
        return (ChildAssociationRef)assocs.iterator().next();
    }

    @Override
    public Collection<ChildAssociationRef> getRootCategories(StoreRef storeRef, QName aspectName, String name, boolean create) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedList<ChildAssociationRef> assocs = new LinkedList<ChildAssociationRef>();
        for (NodeRef nodeRef : nodeRefs) {
            ChildAssociationRef category = this.getCategory(nodeRef, aspectName, name);
            if (category == null) continue;
            assocs.add(category);
        }
        if (create && assocs.isEmpty()) {
            assocs.add(this.createCategoryInternal(nodeRefs.iterator().next(), name));
        }
        return assocs;
    }

    @Override
    public NodeRef createCategory(NodeRef parent, String name) {
        return this.createCategoryInternal(parent, name).getChildRef();
    }

    private ChildAssociationRef createCategoryInternal(NodeRef parent, String name) {
        if (!this.nodeService.exists(parent)) {
            throw new AlfrescoRuntimeException("Missing category?");
        }
        String uri = this.nodeService.getPrimaryParent(parent).getQName().getNamespaceURI();
        String validLocalName = QName.createValidLocalName((String)name);
        ChildAssociationRef newCategory = this.publicNodeService.createNode(parent, ContentModel.ASSOC_SUBCATEGORIES, QName.createQName((String)uri, (String)validLocalName), ContentModel.TYPE_CATEGORY);
        this.publicNodeService.setProperty(newCategory.getChildRef(), ContentModel.PROP_NAME, (Serializable)((Object)name));
        return newCategory;
    }

    @Override
    public NodeRef createRootCategory(StoreRef storeRef, QName aspectName, String name) {
        Set<NodeRef> nodeRefs = this.getClassificationNodes(storeRef, aspectName);
        if (nodeRefs.size() == 0) {
            throw new AlfrescoRuntimeException("Missing classification: " + aspectName);
        }
        NodeRef parent = nodeRefs.iterator().next();
        return this.createCategory(parent, name);
    }

    @Override
    public void deleteCategory(NodeRef nodeRef) {
        this.publicNodeService.deleteNode(nodeRef);
    }

    @Override
    public void deleteClassification(StoreRef storeRef, QName aspectName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Pair<NodeRef, Integer>> getTopCategories(StoreRef storeRef, QName aspectName, int count) {
        if (this.indexerAndSearcher instanceof LuceneIndexerAndSearcher) {
            AspectDefinition definition = this.dictionaryService.getAspect(aspectName);
            if (definition == null) {
                throw new IllegalStateException("Unknown aspect");
            }
            QName catProperty = null;
            Map properties = definition.getProperties();
            for (QName pName : properties.keySet()) {
                PropertyDefinition def;
                if (!pName.getNamespaceURI().equals(aspectName.getNamespaceURI()) || !pName.getLocalName().equalsIgnoreCase(aspectName.getLocalName()) || !(def = (PropertyDefinition)properties.get(pName)).getDataType().getName().equals((Object)DataTypeDefinition.CATEGORY)) continue;
                catProperty = pName;
            }
            if (catProperty == null) {
                throw new IllegalStateException("Aspect does not have category property mirroring the aspect name");
            }
            LuceneIndexerAndSearcher lias = (LuceneIndexerAndSearcher)this.indexerAndSearcher;
            String field = "@" + catProperty;
            SearchService searchService = lias.getSearcher(storeRef, false);
            if (searchService instanceof LuceneSearcher) {
                LuceneSearcher luceneSearcher = (LuceneSearcher)searchService;
                List<Pair<String, Integer>> topTerms = luceneSearcher.getTopTerms(field, count);
                LinkedList<Pair<NodeRef, Integer>> answer = new LinkedList<Pair<NodeRef, Integer>>();
                for (Pair<String, Integer> term : topTerms) {
                    NodeRef nodeRef = new NodeRef((String)term.getFirst());
                    Pair toAdd = this.nodeService.exists(nodeRef) ? new Pair((Object)nodeRef, term.getSecond()) : new Pair(null, term.getSecond());
                    answer.add((Pair<NodeRef, Integer>)toAdd);
                }
                return answer;
            }
            throw new UnsupportedOperationException("getPolularCategories is only supported for lucene indexes");
        }
        throw new UnsupportedOperationException("getPolularCategories is only supported for lucene indexes");
    }
}

