/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.search.AbstractResultSetRow;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class LuceneResultSetRow
extends AbstractResultSetRow {
    private Document document;
    private TenantService tenantService;

    public LuceneResultSetRow(LuceneResultSet resultSet, int index) {
        super(resultSet, index);
        this.tenantService = resultSet.getTenantService();
    }

    public Document getDocument() {
        if (this.document == null) {
            this.document = ((LuceneResultSet)this.getResultSet()).getDocument(this.getIndex());
        }
        return this.document;
    }

    @Override
    protected Map<QName, Serializable> getDirectProperties() {
        LuceneResultSet lrs = (LuceneResultSet)this.getResultSet();
        return lrs.getNodeService().getProperties(lrs.getNodeRef(this.getIndex()));
    }

    @Override
    public QName getQName() {
        Field field = this.getDocument().getField("QNAME");
        if (field != null) {
            String qname = field.stringValue();
            if (qname == null || qname.length() == 0) {
                return null;
            }
            return QName.createQName((String)qname);
        }
        return null;
    }

    public QName getPrimaryAssocTypeQName() {
        Field field = this.getDocument().getField("PRIMARYASSOCTYPEQNAME");
        if (field != null) {
            String qname = field.stringValue();
            return QName.createQName((String)qname);
        }
        return ContentModel.ASSOC_CHILDREN;
    }

    @Override
    public ChildAssociationRef getChildAssocRef() {
        Field field = this.getDocument().getField("PRIMARYPARENT");
        String primaryParent = null;
        if (field != null) {
            primaryParent = field.stringValue();
        }
        NodeRef childNodeRef = this.getNodeRef();
        NodeRef parentNodeRef = primaryParent == null ? null : this.tenantService.getBaseName(new NodeRef(primaryParent));
        return new ChildAssociationRef(this.getPrimaryAssocTypeQName(), parentNodeRef, this.getQName(), childNodeRef);
    }

    public NodeRef getNodeRef(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, NodeRef> getNodeRefs() {
        throw new UnsupportedOperationException();
    }

    public float getScore(String selectorName) {
        throw new UnsupportedOperationException();
    }

    public Map<String, Float> getScores() {
        throw new UnsupportedOperationException();
    }

    public int doc() {
        return ((LuceneResultSet)this.getResultSet()).doc(this.getIndex());
    }
}

