/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene.fts;

import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.alfresco.repo.search.BackgroundIndexerAware;
import org.alfresco.repo.search.Indexer;
import org.alfresco.repo.search.IndexerAndSearcher;
import org.alfresco.repo.search.SupportsBackgroundIndexing;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerException;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.transaction.TransactionService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class FullTextSearchIndexerImpl
implements FTSIndexerAware,
FullTextSearchIndexer,
DisposableBean {
    private static Log s_logger = LogFactory.getLog(FullTextSearchIndexerImpl.class);
    private static Set<StoreRef> requiresIndex = new LinkedHashSet<StoreRef>();
    private static Set<StoreRef> indexing = new HashSet<StoreRef>();
    private IndexerAndSearcher indexerAndSearcherFactory;
    private TransactionService transactionService;
    private int pauseCount = 0;
    private boolean paused = false;
    private int batchSize = 1000;

    @Override
    public synchronized void requiresIndex(StoreRef storeRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("FTS index request for " + storeRef));
        }
        requiresIndex.add(storeRef);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void indexCompleted(StoreRef storeRef, int remaining, Throwable t) {
        try {
            if (s_logger.isDebugEnabled()) {
                s_logger.debug((Object)("FTS index completed for " + storeRef + " ... " + remaining + " remaining"));
            }
            indexing.remove(storeRef);
            if (remaining > 0 || t != null) {
                this.requiresIndex(storeRef);
            }
            if (t != null) {
                throw new FTSIndexerException(t);
            }
        }
        finally {
            this.notifyAll();
        }
    }

    @Override
    public synchronized void pause() throws InterruptedException {
        ++this.pauseCount;
        if (s_logger.isTraceEnabled()) {
            s_logger.trace((Object)("..Waiting " + this.pauseCount + " id is " + this));
        }
        while (indexing.size() > 0) {
            if (s_logger.isTraceEnabled()) {
                s_logger.trace((Object)("Pause: Waiting with count of " + indexing.size() + " id is " + this));
            }
            this.wait();
        }
        --this.pauseCount;
        if (this.pauseCount == 0) {
            this.paused = true;
            this.notifyAll();
        }
        if (s_logger.isTraceEnabled()) {
            s_logger.trace((Object)("..Remaining " + this.pauseCount + " paused = " + this.paused + " id is " + this));
        }
    }

    @Override
    public synchronized void resume() throws InterruptedException {
        if (this.pauseCount == 0) {
            if (s_logger.isTraceEnabled()) {
                s_logger.trace((Object)("Direct resume id is " + this));
            }
            this.paused = false;
        } else {
            while (this.pauseCount > 0) {
                if (s_logger.isTraceEnabled()) {
                    s_logger.trace((Object)("Resume waiting on " + this.pauseCount + " id is " + this));
                }
                this.wait();
            }
            this.paused = false;
        }
    }

    private synchronized boolean isPaused() throws InterruptedException {
        if (this.pauseCount == 0) {
            return this.paused;
        }
        while (this.pauseCount > 0) {
            this.wait();
        }
        return this.paused;
    }

    @Override
    public void index() {
        int done = 0;
        while (done == 0) {
            final StoreRef toIndex = this.getNextRef();
            try {
                if (toIndex != null) {
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("FTS Indexing " + toIndex + " at " + new Date()));
                    }
                    try {
                        done += this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Integer>(){

                            @Override
                            public Integer execute() throws Throwable {
                                Indexer indexer = FullTextSearchIndexerImpl.this.indexerAndSearcherFactory.getIndexer(toIndex);
                                indexer.setReadThrough(true);
                                if (indexer instanceof BackgroundIndexerAware) {
                                    BackgroundIndexerAware backgroundIndexerAware = (BackgroundIndexerAware)((Object)indexer);
                                    backgroundIndexerAware.registerCallBack(FullTextSearchIndexerImpl.this);
                                    return backgroundIndexerAware.updateFullTextSearch(FullTextSearchIndexerImpl.this.batchSize);
                                }
                                return 0;
                            }
                        }, true).intValue();
                    }
                    catch (Exception ex) {
                        this.indexCompleted(toIndex, 0, ex);
                        if (!s_logger.isWarnEnabled()) continue;
                        s_logger.warn((Object)"FTS Job threw exception", (Throwable)ex);
                    }
                    continue;
                }
                if (!s_logger.isTraceEnabled()) break;
                s_logger.trace((Object)("Nothing to FTS index at " + new Date()));
                break;
            }
            catch (Throwable t) {
                this.indexCompleted(toIndex, 0, t);
            }
        }
    }

    private synchronized StoreRef getNextRef() {
        if (this.paused || this.pauseCount > 0) {
            if (s_logger.isTraceEnabled()) {
                s_logger.trace((Object)("Indexing suspended - no store available -  id is " + this));
            }
            return null;
        }
        StoreRef nextStoreRef = null;
        for (StoreRef ref : requiresIndex) {
            if (indexing.contains(ref)) continue;
            nextStoreRef = ref;
            break;
        }
        if (nextStoreRef != null) {
            requiresIndex.remove(nextStoreRef);
            indexing.add(nextStoreRef);
        }
        return nextStoreRef;
    }

    public void setIndexerAndSearcherFactory(IndexerAndSearcher indexerAndSearcherFactory) {
        this.indexerAndSearcherFactory = indexerAndSearcherFactory;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public static void main(String[] args) throws InterruptedException {
        ClassPathXmlApplicationContext ctx = new ClassPathXmlApplicationContext("classpath:alfresco/application-context.xml");
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        ListableBeanFactory listableBeanFactory = (ListableBeanFactory)beanFactory;
        for (Object bgindexable : listableBeanFactory.getBeansOfType(SupportsBackgroundIndexing.class).values()) {
            if (!(bgindexable instanceof SupportsBackgroundIndexing)) continue;
            ((SupportsBackgroundIndexing)bgindexable).setFullTextSearchIndexer(this);
        }
    }

    public void setBatchSize(int batchSzie) {
        this.batchSize = batchSzie;
    }

    public void destroy() throws Exception {
        this.pause();
        requiresIndex.clear();
        indexing.clear();
    }
}

