/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.Collections;
import java.util.Set;
import org.alfresco.repo.management.subsystems.ActivateableBean;
import org.alfresco.repo.security.authentication.AbstractAuthenticationService;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.TicketComponent;

public class AuthenticationServiceImpl
extends AbstractAuthenticationService
implements ActivateableBean {
    AuthenticationComponent authenticationComponent;
    TicketComponent ticketComponent;
    private String domain;
    private boolean allowsUserCreation = true;
    private boolean allowsUserDeletion = true;
    private boolean allowsUserPasswordChange = true;

    public void setTicketComponent(TicketComponent ticketComponent) {
        this.ticketComponent = ticketComponent;
    }

    public void setAuthenticationComponent(AuthenticationComponent authenticationComponent) {
        this.authenticationComponent = authenticationComponent;
    }

    @Override
    public boolean isActive() {
        return !(this.authenticationComponent instanceof ActivateableBean) || ((ActivateableBean)((Object)this.authenticationComponent)).isActive();
    }

    @Override
    public void authenticate(String userName, char[] password) throws AuthenticationException {
        try {
            this.clearCurrentSecurityContext();
            this.preAuthenticationCheck(userName);
            this.authenticationComponent.authenticate(userName, password);
        }
        catch (AuthenticationException ae) {
            this.clearCurrentSecurityContext();
            throw ae;
        }
        this.ticketComponent.clearCurrentTicket();
        this.getCurrentTicket();
    }

    @Override
    public String getCurrentUserName() throws AuthenticationException {
        return this.authenticationComponent.getCurrentUserName();
    }

    @Override
    public void invalidateUserSession(String userName) throws AuthenticationException {
        this.ticketComponent.invalidateTicketByUser(userName);
    }

    @Override
    public Set<String> getUsersWithTickets(boolean nonExpiredOnly) {
        return this.ticketComponent.getUsersWithTickets(nonExpiredOnly);
    }

    @Override
    public void invalidateTicket(String ticket) throws AuthenticationException {
        this.ticketComponent.invalidateTicketById(ticket);
    }

    @Override
    public int countTickets(boolean nonExpiredOnly) {
        return this.ticketComponent.countTickets(nonExpiredOnly);
    }

    @Override
    public int invalidateTickets(boolean expiredOnly) {
        return this.ticketComponent.invalidateTickets(expiredOnly);
    }

    @Override
    public void validate(String ticket) throws AuthenticationException {
        String currentUser = null;
        try {
            this.clearCurrentSecurityContext();
            currentUser = this.ticketComponent.validateTicket(ticket);
            this.authenticationComponent.setCurrentUser(currentUser, AuthenticationComponent.UserNameValidationMode.NONE);
        }
        catch (AuthenticationException ae) {
            this.clearCurrentSecurityContext();
            throw ae;
        }
    }

    @Override
    public String getCurrentTicket() throws AuthenticationException {
        String userName = this.getCurrentUserName();
        String ticket = this.ticketComponent.getCurrentTicket(userName, false);
        if (ticket == null) {
            return this.getNewTicket();
        }
        return ticket;
    }

    @Override
    public String getNewTicket() {
        String userName = this.getCurrentUserName();
        try {
            this.preAuthenticationCheck(userName);
        }
        catch (AuthenticationException e) {
            this.clearCurrentSecurityContext();
            throw e;
        }
        return this.ticketComponent.getNewTicket(userName);
    }

    @Override
    public void clearCurrentSecurityContext() {
        this.authenticationComponent.clearCurrentSecurityContext();
        this.ticketComponent.clearCurrentTicket();
    }

    @Override
    public boolean isCurrentUserTheSystemUser() {
        return this.authenticationComponent.isSystemUserName(this.getCurrentUserName());
    }

    @Override
    public void authenticateAsGuest() throws AuthenticationException {
        String defaultGuestName = AuthenticationUtil.getGuestUserName();
        if (defaultGuestName == null || defaultGuestName.length() == 0) {
            throw new AuthenticationException("Guest authentication not supported");
        }
        this.preAuthenticationCheck(defaultGuestName);
        this.authenticationComponent.setGuestUserAsCurrentUser();
        String guestUser = this.authenticationComponent.getCurrentUserName();
        this.ticketComponent.clearCurrentTicket();
        this.ticketComponent.getCurrentTicket(guestUser, true);
    }

    @Override
    public boolean guestUserAuthenticationAllowed() {
        return this.authenticationComponent.guestUserAuthenticationAllowed();
    }

    public boolean getAllowsUserCreation() {
        return this.allowsUserCreation;
    }

    public void setAllowsUserCreation(boolean allowsUserCreation) {
        this.allowsUserCreation = allowsUserCreation;
    }

    public boolean getAllowsUserDeletion() {
        return this.allowsUserDeletion;
    }

    public void setAllowsUserDeletion(boolean allowsUserDeletion) {
        this.allowsUserDeletion = allowsUserDeletion;
    }

    public boolean getAllowsUserPasswordChange() {
        return this.allowsUserPasswordChange;
    }

    public void setAllowsUserPasswordChange(boolean allowsUserPasswordChange) {
        this.allowsUserPasswordChange = allowsUserPasswordChange;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public Set<String> getDomains() {
        return Collections.singleton(this.getDomain());
    }

    @Override
    public Set<String> getDomainsThatAllowUserCreation() {
        if (this.getAllowsUserCreation()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomainsThatAllowUserDeletion() {
        if (this.getAllowsUserDeletion()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDomiansThatAllowUserPasswordChanges() {
        if (this.getAllowsUserPasswordChange()) {
            return Collections.singleton(this.getDomain());
        }
        return Collections.emptySet();
    }

    @Override
    public Set<TicketComponent> getTicketComponents() {
        return Collections.singleton(this.ticketComponent);
    }

    @Override
    public Set<String> getDefaultAdministratorUserNames() {
        return this.authenticationComponent.getDefaultAdministratorUserNames();
    }

    @Override
    public Set<String> getDefaultGuestUserNames() {
        return this.authenticationComponent.getDefaultGuestUserNames();
    }

    @Override
    public boolean authenticationExists(String userName) {
        return true;
    }

    @Override
    public boolean getAuthenticationEnabled(String userName) throws AuthenticationException {
        return true;
    }
}

