/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import junit.framework.TestCase;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.ChainingAuthenticationServiceImpl;
import org.alfresco.repo.security.authentication.TestAuthenticationServiceImpl;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.service.cmr.security.AuthenticationService;

public class ChainingAuthenticationServiceTest
extends TestCase {
    private static final String EMPTY = "Empty";
    private static final String FIVE_AND_MORE = "FiveAndMore";
    private static final String FIVE = "Five";
    private static final String LONELY_DISABLE = "LonelyDisable";
    private static final String LONELY_ENABLED = "LonelyEnabled";
    private static final String ALFRESCO = "Alfresco";
    TestAuthenticationServiceImpl service1;
    TestAuthenticationServiceImpl service2;
    TestAuthenticationServiceImpl service3;
    TestAuthenticationServiceImpl service4;
    TestAuthenticationServiceImpl service5;
    private TestAuthenticationServiceImpl service6;

    public ChainingAuthenticationServiceTest() {
    }

    public ChainingAuthenticationServiceTest(String arg0) {
        super(arg0);
    }

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new AlfrescoRuntimeException("A previous tests did not clean up transaction: " + AlfrescoTransactionSupport.getTransactionId());
        }
        AuthenticationUtil authUtil = new AuthenticationUtil();
        authUtil.setDefaultAdminUserName("admin");
        authUtil.setDefaultGuestUserName("guest");
        authUtil.afterPropertiesSet();
        this.service1 = new TestAuthenticationServiceImpl(ALFRESCO, true, true, true, false);
        this.service1.createAuthentication("andy", "andy".toCharArray());
        HashMap<String, String> up = new HashMap<String, String>();
        HashSet<String> disabled = new HashSet<String>();
        up.put("lone", "lone");
        this.service2 = new TestAuthenticationServiceImpl(LONELY_ENABLED, false, false, false, true, up, disabled);
        up.clear();
        disabled.clear();
        up.put("ranger", "ranger");
        disabled.add("ranger");
        this.service3 = new TestAuthenticationServiceImpl(LONELY_DISABLE, false, false, false, false, up, disabled);
        this.service4 = new TestAuthenticationServiceImpl(EMPTY, true, true, true, false);
        up.clear();
        disabled.clear();
        up.put("A", "A");
        up.put("B", "B");
        up.put("C", "C");
        up.put("D", "D");
        up.put("E", "E");
        this.service5 = new TestAuthenticationServiceImpl(FIVE, false, false, false, false, up, disabled);
        up.clear();
        disabled.clear();
        up.put("A", "a");
        up.put("B", "b");
        up.put("C", "c");
        up.put("D", "d");
        up.put("E", "e");
        up.put("F", "f");
        up.put("G", "g");
        up.put("H", "h");
        up.put("I", "i");
        up.put("J", "j");
        up.put("K", "k");
        this.service6 = new TestAuthenticationServiceImpl(FIVE_AND_MORE, false, false, false, false, up, disabled);
    }

    public void testServiceOne_Auth() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        as.setAuthenticationServices(ases);
        as.authenticate("andy", "andy".toCharArray());
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)"andy");
    }

    public void testServiceOne_AuthFail() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        as.setAuthenticationServices(ases);
        try {
            as.authenticate("andy", "woof".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testServiceOne_GuestDenied() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        as.setAuthenticationServices(ases);
        try {
            as.authenticateAsGuest();
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testServiceTwo_GuestAllowed() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        as.setAuthenticationServices(ases);
        as.authenticateAsGuest();
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)AuthenticationUtil.getGuestUserName());
        as.clearCurrentSecurityContext();
        ChainingAuthenticationServiceTest.assertNull((Object)as.getCurrentUserName());
    }

    public void testServiceOne_CRUD_Fails() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        as.setAuthenticationServices(ases);
        try {
            as.authenticate("bob", "bob".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            as.createAuthentication("bob", "bob".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testServiceOne_CRUD() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        as.setMutableAuthenticationService(this.service1);
        try {
            as.authenticate("bob", "bob".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        as.createAuthentication("bob", "bob".toCharArray());
        as.authenticate("bob", "bob".toCharArray());
        as.updateAuthentication("bob", "bob".toCharArray(), "carol".toCharArray());
        try {
            as.authenticate("bob", "bob".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        as.authenticate("bob", "carol".toCharArray());
        as.deleteAuthentication("bob");
        try {
            as.authenticate("bob", "carol".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testServiceOne_Enabled() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        as.setMutableAuthenticationService(this.service1);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("andy"));
        as.setAuthenticationEnabled("andy", false);
        ChainingAuthenticationServiceTest.assertFalse((boolean)as.getAuthenticationEnabled("andy"));
        as.setAuthenticationEnabled("andy", true);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("andy"));
        as.authenticate("andy", "andy".toCharArray());
        as.setAuthenticationEnabled("andy", false);
        ChainingAuthenticationServiceTest.assertFalse((boolean)as.getAuthenticationEnabled("andy"));
        try {
            as.authenticate("andy", "andy".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testServiceOneDomains() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        as.setMutableAuthenticationService(this.service1);
        HashSet<String> testDomains = new HashSet<String>();
        testDomains.add(ALFRESCO);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomains().equals(testDomains));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserCreation().equals(testDomains));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserDeletion().equals(testDomains));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomiansThatAllowUserPasswordChanges().equals(testDomains));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomains().equals(this.service1.getDomains()));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserCreation().equals(this.service1.getDomainsThatAllowUserCreation()));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserDeletion().equals(this.service1.getDomainsThatAllowUserDeletion()));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomiansThatAllowUserPasswordChanges().equals(this.service1.getDomiansThatAllowUserPasswordChanges()));
    }

    public void testServiceOneTickets() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        as.setMutableAuthenticationService(this.service1);
        as.authenticate("andy", "andy".toCharArray());
        String ticket = as.getCurrentTicket();
        ChainingAuthenticationServiceTest.assertTrue((ticket == as.getCurrentTicket() ? 1 : 0) != 0);
        as.validate(ticket);
        as.invalidateTicket(ticket);
        try {
            as.validate(ticket);
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        ticket = as.getCurrentTicket();
        as.validate(ticket);
        as.invalidateUserSession("andy");
        try {
            as.validate(ticket);
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAll_Auth() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        as.authenticate("andy", "andy".toCharArray());
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)"andy");
        as.authenticate("lone", "lone".toCharArray());
        try {
            as.authenticate("ranger", "ranger".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        as.authenticate("A", "A".toCharArray());
        as.authenticate("B", "B".toCharArray());
        as.authenticate("C", "C".toCharArray());
        as.authenticate("D", "D".toCharArray());
        as.authenticate("E", "E".toCharArray());
        as.authenticate("A", "a".toCharArray());
        as.authenticate("B", "b".toCharArray());
        as.authenticate("C", "c".toCharArray());
        as.authenticate("D", "d".toCharArray());
        as.authenticate("E", "e".toCharArray());
        as.authenticate("F", "f".toCharArray());
        as.authenticate("G", "g".toCharArray());
        as.authenticate("H", "h".toCharArray());
        as.authenticate("I", "i".toCharArray());
        as.authenticate("J", "j".toCharArray());
        as.authenticate("K", "k".toCharArray());
    }

    public void testAll_AuthOverLapReversed() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service6);
        ases.add(this.service5);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        as.authenticate("andy", "andy".toCharArray());
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)"andy");
        as.authenticate("lone", "lone".toCharArray());
        try {
            as.authenticate("ranger", "ranger".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            as.authenticate("A", "B".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
        as.authenticate("A", "A".toCharArray());
        as.authenticate("B", "B".toCharArray());
        as.authenticate("C", "C".toCharArray());
        as.authenticate("D", "D".toCharArray());
        as.authenticate("E", "E".toCharArray());
        as.authenticate("A", "a".toCharArray());
        as.authenticate("B", "b".toCharArray());
        as.authenticate("C", "c".toCharArray());
        as.authenticate("D", "d".toCharArray());
        as.authenticate("E", "e".toCharArray());
        as.authenticate("F", "f".toCharArray());
        as.authenticate("G", "g".toCharArray());
        as.authenticate("H", "h".toCharArray());
        as.authenticate("I", "i".toCharArray());
        as.authenticate("J", "j".toCharArray());
        as.authenticate("K", "k".toCharArray());
    }

    public void testAll_MutAuth() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        as.authenticate("andy", "andy".toCharArray());
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)"andy");
        as.authenticate("lone", "lone".toCharArray());
        try {
            as.authenticate("ranger", "ranger".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        as.authenticate("A", "A".toCharArray());
        as.authenticate("B", "B".toCharArray());
        as.authenticate("C", "C".toCharArray());
        as.authenticate("D", "D".toCharArray());
        as.authenticate("E", "E".toCharArray());
        as.authenticate("A", "a".toCharArray());
        as.authenticate("B", "b".toCharArray());
        as.authenticate("C", "c".toCharArray());
        as.authenticate("D", "d".toCharArray());
        as.authenticate("E", "e".toCharArray());
        as.authenticate("F", "f".toCharArray());
        as.authenticate("G", "g".toCharArray());
        as.authenticate("H", "h".toCharArray());
        as.authenticate("I", "i".toCharArray());
        as.authenticate("J", "j".toCharArray());
        as.authenticate("K", "k".toCharArray());
        as.createAuthentication("A", "woof".toCharArray());
        as.authenticate("A", "woof".toCharArray());
        as.updateAuthentication("A", "woof".toCharArray(), "bark".toCharArray());
        as.authenticate("A", "bark".toCharArray());
        as.setAuthentication("A", "tree".toCharArray());
        as.authenticate("A", "tree".toCharArray());
        as.deleteAuthentication("A");
        as.authenticate("A", "A".toCharArray());
        as.authenticate("A", "a".toCharArray());
        try {
            as.authenticate("A", "woof".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            as.authenticate("A", "bark".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        try {
            as.authenticate("A", "tree".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testAll_AuthEnabled() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("andy"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("lone"));
        ChainingAuthenticationServiceTest.assertFalse((boolean)as.getAuthenticationEnabled("ranger"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("A"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("B"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("C"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("D"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("E"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("F"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("G"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("H"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("I"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("J"));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("K"));
        as.setAuthenticationEnabled("andy", false);
        ChainingAuthenticationServiceTest.assertFalse((boolean)as.getAuthenticationEnabled("andy"));
        as.setAuthenticationEnabled("andy", true);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getAuthenticationEnabled("andy"));
        as.setAuthenticationEnabled("andy", false);
        try {
            as.authenticate("andy", "andy".toCharArray());
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testService_GuestDenied() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        try {
            as.authenticateAsGuest();
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException authenticationException) {
            // empty catch block
        }
    }

    public void testService_GuestAllowed() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service1);
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.authenticateAsGuest();
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)AuthenticationUtil.getGuestUserName());
        as.clearCurrentSecurityContext();
        ChainingAuthenticationServiceTest.assertNull((Object)as.getCurrentUserName());
    }

    public void testService_NoGuestConfigured() throws Exception {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        as.setAuthenticationServices(ases);
        ChainingAuthenticationServiceTest.assertNotNull((Object)AuthenticationUtil.getGuestUserName());
        as.authenticateAsGuest();
        ChainingAuthenticationServiceTest.assertEquals((String)as.getCurrentUserName(), (String)AuthenticationUtil.getGuestUserName());
        as.clearCurrentSecurityContext();
        ChainingAuthenticationServiceTest.assertNull((Object)as.getCurrentUserName());
        AuthenticationUtil authUtil = new AuthenticationUtil();
        authUtil.setDefaultAdminUserName("admin");
        authUtil.setDefaultGuestUserName(null);
        authUtil.afterPropertiesSet();
        try {
            as.authenticateAsGuest();
            ChainingAuthenticationServiceTest.fail((String)"Guest authentication should not be supported");
        }
        catch (AuthenticationException ae) {
            ChainingAuthenticationServiceTest.assertTrue((boolean)ae.getMessage().contains("Guest authentication not supported"));
        }
        ChainingAuthenticationServiceTest.assertNull((Object)as.getCurrentUserName());
    }

    public void testService_Domains() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        HashSet<String> testDomains = new HashSet<String>();
        testDomains.add(ALFRESCO);
        testDomains.add(LONELY_ENABLED);
        testDomains.add(LONELY_DISABLE);
        testDomains.add(EMPTY);
        testDomains.add(FIVE);
        testDomains.add(FIVE_AND_MORE);
        HashSet<String> onlyAlfDomain = new HashSet<String>();
        onlyAlfDomain.add(ALFRESCO);
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomains().equals(testDomains));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserCreation().equals(onlyAlfDomain));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomainsThatAllowUserDeletion().equals(onlyAlfDomain));
        ChainingAuthenticationServiceTest.assertTrue((boolean)as.getDomiansThatAllowUserPasswordChanges().equals(onlyAlfDomain));
    }

    public void testServiceTickets() {
        ChainingAuthenticationServiceImpl as = new ChainingAuthenticationServiceImpl();
        ArrayList<AuthenticationService> ases = new ArrayList<AuthenticationService>();
        ases.add(this.service2);
        ases.add(this.service3);
        ases.add(this.service4);
        ases.add(this.service5);
        ases.add(this.service6);
        as.setAuthenticationServices(ases);
        as.setMutableAuthenticationService(this.service1);
        as.authenticate("andy", "andy".toCharArray());
        String ticket = as.getCurrentTicket();
        ChainingAuthenticationServiceTest.assertTrue((ticket == as.getCurrentTicket() ? 1 : 0) != 0);
        as.validate(ticket);
        as.invalidateTicket(ticket);
        try {
            as.validate(ticket);
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
        ticket = as.getCurrentTicket();
        as.validate(ticket);
        as.invalidateUserSession("andy");
        try {
            as.validate(ticket);
            ChainingAuthenticationServiceTest.fail();
        }
        catch (AuthenticationException e) {
            // empty catch block
        }
    }
}

