/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import net.sf.acegisecurity.Authentication;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AbstractAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;

public class SimpleAcceptOrRejectAllAuthenticationComponentImpl
extends AbstractAuthenticationComponent
implements NLTMAuthenticator {
    private boolean accept = false;
    private boolean supportNtlm = false;

    public void setAccept(boolean accept) {
        this.accept = accept;
    }

    public void setSupportNtlm(boolean supportNtlm) {
        this.supportNtlm = supportNtlm;
    }

    @Override
    public void authenticateImpl(String userName, char[] password) throws AuthenticationException {
        if (!this.accept) {
            throw new AuthenticationException("Access Denied");
        }
        this.setCurrentUser(userName);
    }

    @Override
    protected boolean implementationAllowsGuestLogin() {
        return this.accept;
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        if (this.accept) {
            return "0cb6948805f797bf2a82807973b89537";
        }
        throw new AuthenticationException("Access Denied");
    }

    @Override
    public NTLMMode getNTLMMode() {
        return this.supportNtlm ? NTLMMode.MD4_PROVIDER : NTLMMode.NONE;
    }

    @Override
    public Authentication authenticate(Authentication token) throws AuthenticationException {
        throw new AlfrescoRuntimeException("Authentication via token not supported");
    }
}

